#ifndef ETHERCRC_TLM_H
#define ETHERCRC_TLM_H

/* $Id: ethercrc_tlm.h,v 1.2 2011/03/22 07:45:01 djg11 Exp $
 *
 * (C) 2009-10 DJ Greaves - Ethernet CRC coprocessor example
 */

#include "systemc.h"

#include "tlm.h"


#include "tlm_utils/simple_target_socket.h"
#include "tenos.h"

#include "ethercrc_bev_core.h"


#define LLSC_ENABLE 2

SC_MODULE(ethercrc_tlm)
{
  const sc_time latency;

  ethercrc_bev_core bevcore;

  //TLM-2 socket, defaults to 32-bits wide, base protocol
  tlm_utils::simple_target_socket<ethercrc_tlm> port0;
  
  // blocking transport
  void b_access(tlm::tlm_generic_payload &trans, sc_time &delay);

// Constructor
  ethercrc_tlm(sc_module_name name): sc_module(name), latency(5, SC_NS)
    {
      
      // Register callback for incoming b_transport interface method call
      port0.register_b_transport(this, &ethercrc_tlm::b_access);
    }

};

#endif


