#ifndef ORSIM1200_H
#define ORSIM1200_H

//
// (C) 2009-10 DJ Greaves (TLM 2.0 Version Arturs Prieditis) 
// Blocking TLM wrapper for the fast versions of the OR1200 core.
// $Id: $
//

#include "systemc.h"
#include "tlm.h"
#include "tlm_utils/simple_initiator_socket.h"
#include "tlm_utils/tlm_quantumkeeper.h"


#include "../orsim/orsim.h"
#include "llsc_extension.h"
#include "../sw/support/socdam.h"
#include "../sw/support/spr_defs.h"

#define BENCH_RESET_TIME 10



class OR1200 : public orsim, public sc_core::sc_module
{
  int atomics;  // Non zero while attempting atomic bus transaction.
  uint32_t atomic_wdata, atomic_addr;
  llsc_mm_t llsc_mm;
 public:
  OR1200(sc_core::sc_module_name name, uint8_t pID);

  tlm_utils::simple_initiator_socket<OR1200> initiator_socket;
  uint32_t where_last;
  uint32_t counter_ticks;
  bool tracing;
  static volatile bool over;
  volatile bool halted;


 protected:
  void  doInitiatorTrans( tlm::tlm_generic_payload &trans,sc_time& delay  );
  sc_time maindelay;    // Loosely timed delay on main thread.
 private:
  tlm_utils::tlm_quantumkeeper m_qk; // Quantum keeper for temporal decoupling 




  uint8_t procID;

  void run();
  void reset();

  // The following I/O functions are pure virtual in orsim, and must be provided here:
  void                corepause(int us);  // Pause CPU for this time interval
  uint32_t eval_insn(unsigned int addr, int *bp);
  uint32_t            eval_mem32 (oraddr_t memaddr, int *);
  uint16_t            eval_mem16 (oraddr_t memaddr, int *);
  uint8_t             eval_mem8 (oraddr_t memaddr, int *);
  void                set_mem32 (oraddr_t memaddr, uint32_t value, int *);
  void                set_mem16 (oraddr_t memaddr, uint16_t value, int *);
  void                set_mem8 (oraddr_t memaddr, uint8_t value, int *);
  uint32_t            eval_compare_and_swap(uint32_t memaddr, uint32_t wdata, sc_time &delay);
  void set_direct8 (oraddr_t, uint8_t, int, int);
  uint8_t eval_direct8(unsigned int, int, int);
  void                atomic_prefix(); // Prefix following load/store pair as atomic.

  void sim_done()
  {
    over = true;
  }

  uint32_t mem_read(uint32_t addr, sc_time &delay);
  void mem_write(uint32_t  addr,  uint8_t mask, uint32_t wdata, sc_time &delay);
};

#endif

// eof
