// Generic payload blocking transport router
#ifndef BUSMUX_H
#define BUSMUX_H
#include "systemc.h"
#include "tlm.h"
#include "tlm_utils/multi_passthrough_initiator_socket.h"
#include "tlm_utils/multi_passthrough_target_socket.h"

using namespace sc_core;
using namespace sc_dt;
using namespace std;

class busmux:sc_module
{
 public:
  // Use tagged sockets to be able to distinguish incoming backward path calls
  tlm_utils::multi_passthrough_target_socket<busmux>    targ_socket;
  tlm_utils::multi_passthrough_initiator_socket<busmux> init_socket;

  // Constructor
  busmux(sc_module_name name, uint32_t threshold);


  // FORWARD PATH
  // TLM-2 blocking transport method
  virtual void b_transport(int id, tlm::tlm_generic_payload &trans, sc_time &delay);
  uint32_t threshold;
};

#endif
// eof
