#include "busmux.h"
#include <stdint.h>

// *********************************************
// Generic payload blocking transport router
// *********************************************

busmux::busmux(sc_module_name name, uint32_t threshold):
  sc_module(name), 
  targ_socket("targ_socket"), 
  init_socket("init_socket"), 
  threshold(threshold)
{
  // Register callbacks for incoming interface method calls
  targ_socket.register_b_transport(this, &busmux::b_transport);
}


// TLM-2 blocking transport method
void busmux::b_transport(int id, tlm::tlm_generic_payload &trans, sc_time &delay)
{
  uint32_t adr = (uint32_t) trans.get_address();
  if (adr < threshold) init_socket[0]->b_transport(trans, delay);
  else 
    {
      init_socket[1]->b_transport(trans, delay);
    }
}

// eof
