/**
 * Copyright 2010 Andrew Rice
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package uk.ac.cam.acr31.android.oggstreamer;



public class StreamController implements Streamable {

	public final static int STREAM_TYPE_ANDROID = 0;
	public final static int STREAM_TYPE_PUSHOGG = 1;
	
	private OggStreamerActivity mOggStreamer;
	private int mType = STREAM_TYPE_ANDROID;
	private Streamable mCurrentStream = null;

	public StreamController(OggStreamerActivity oggStreamer) {
		mOggStreamer = oggStreamer;
	}

	public void setStreamType(int type) {
		mType = type;
	}

	@Override
	public void start(String url) {
		if (mCurrentStream != null) {
			mCurrentStream.stop();
			mCurrentStream = null;
		}
		switch (mType) {
		case STREAM_TYPE_ANDROID:
			mCurrentStream = new AndroidStreamer(mOggStreamer);
			break;
		case STREAM_TYPE_PUSHOGG:
			mCurrentStream = new PushOggStreamer(mOggStreamer);
			break;
		}
		mCurrentStream.onResume();
		mCurrentStream.start(url);
	}

	@Override
	public void stop() {
		if (mCurrentStream != null) {
			mCurrentStream.stop();
			mCurrentStream = null;
		}
	}

	@Override
	public void onPause() {
		stop();
		if (mCurrentStream != null)  mCurrentStream.onPause();
	}

	@Override
	public void onResume() {
		if (mCurrentStream != null)  mCurrentStream.onResume();
	}

	@Override
	public void forceHandover() {
		if (mCurrentStream !=null) mCurrentStream.forceHandover();
	}

}
