/**
 * Copyright 2010 Andrew Rice
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package uk.ac.cam.acr31.android.oggstreamer;

import uk.ac.cam.acr31.oggdecoder.BufferedOggStream;
import uk.ac.cam.acr31.oggdecoder.EndOfStreamException;
import uk.ac.cam.acr31.oggdecoder.HttpOggStream;
import uk.ac.cam.acr31.oggdecoder.InvalidStreamException;
import uk.ac.cam.acr31.oggdecoder.OggContainer;
import uk.ac.cam.acr31.oggdecoder.OggFormatException;
import uk.ac.cam.acr31.oggdecoder.OggPacketReceiver;
import uk.ac.cam.acr31.oggdecoder.OggPacketReceiverFactory;
import uk.ac.cam.acr31.oggdecoder.OggStream;

public class PushOggStreamer implements Streamable {

	private OggStream currentStream = null;
	private OggStreamerActivity mOggStreamer;
	private String mUrl;

	public PushOggStreamer(OggStreamerActivity oggStreamer) {
		mOggStreamer = oggStreamer;
	}

	@Override
	public synchronized void start(String url) {
		mUrl = url;
		mOggStreamer
				.onStreamStateChange(OggStreamerActivity.STREAM_STATE_STARTING);
		try {
			final BufferedOggStream newStream = new BufferedOggStream(
					new HttpOggStream(url), 2048);
			currentStream = newStream;
			new Thread() {
				public void run() {
					try {
						OggContainer c = new OggContainer(currentStream);
						c
								.registerPacketReceiver(new OggPacketReceiverFactory() {
									boolean isFirstStream = true;

									@Override
									public boolean testFirstPacket(byte[] data) {
										return isFirstStream
												&& (data[1] == 'v'
														&& data[2] == 'o'
														&& data[3] == 'r'
														&& data[4] == 'b'
														&& data[5] == 'i' && data[6] == 's');
									}

									@Override
									public OggPacketReceiver getInstance() {
										isFirstStream = false;
										threadStateChange(OggStreamerActivity.STREAM_STATE_PLAYING);
										return new PushVorbisPacketReceiver();
									}
								});
						c.advance();
					} catch (InvalidStreamException e) {
						synchronized (PushOggStreamer.this) {
							if (currentStream == newStream)
								threadStateChange(OggStreamerActivity.STREAM_STATE_ERROR);
						}
					} catch (OggFormatException e) {
						synchronized (PushOggStreamer.this) {
							if (currentStream == newStream)
								threadStateChange(OggStreamerActivity.STREAM_STATE_ERROR);
						}
					} catch (EndOfStreamException e) {
						synchronized (PushOggStreamer.this) {
							if (currentStream == newStream)
								threadStateChange(OggStreamerActivity.STREAM_STATE_STOPPED);
						}
					}
				}
			}.start();
		} catch (InvalidStreamException e) {
			mOggStreamer
					.onStreamStateChange(OggStreamerActivity.STREAM_STATE_ERROR);
		}
	}

	private void threadStateChange(final int state) {
		mOggStreamer.runOnUiThread(new Runnable() {
			@Override
			public void run() {
				mOggStreamer.onStreamStateChange(state);
			}
		});
	}

	@Override
	public void stop() {
		mOggStreamer
				.onStreamStateChange(OggStreamerActivity.STREAM_STATE_STOPPING);
		currentStream.close();
	}

	@Override
	public void onPause() {
		// TODO Auto-generated method stub

	}

	@Override
	public void onResume() {
		// TODO Auto-generated method stub

	}

	@Override
	public void forceHandover() {
		OggStream c= currentStream;
		currentStream=null;
		c.close();
		start(mUrl);
	}

}
