/**
 * Copyright 2010 Andrew Rice
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package uk.ac.cam.acr31.android.oggstreamer;

import android.app.Activity;
import android.os.Bundle;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.RadioGroup;

public class OggStreamerActivity extends Activity {

	private Button mStopStream;
	private CheckBox mStreamPref;
	private RadioGroup mStreamType;

	private StreamController mStreamController;
	/** Called when the activity is first created. */
	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.main);

		mStopStream = (Button) findViewById(R.id.Button01);
		mStreamType = (RadioGroup) findViewById(R.id.radio_stream);
		mStreamPref = (CheckBox) findViewById(R.id.stream_state);

		mStreamController = new StreamController(this);

		final String url = "http://svr-acr31-acsmobile.cl.cam.ac.uk:9005/sine";
		mStopStream.setOnClickListener(new OnClickListener() {
			@Override
			public void onClick(View v) {
				mStreamController.forceHandover();
			}
		});

		mStreamPref
				.setOnCheckedChangeListener(new CheckBox.OnCheckedChangeListener() {
					@Override
					public void onCheckedChanged(CompoundButton buttonView,
							boolean isChecked) {
						if (isChecked) {
							mStreamController.start(url);
						} else {
							mStreamController.stop();
						}
					}
				});

		mStreamType
				.setOnCheckedChangeListener(new RadioGroup.OnCheckedChangeListener() {
					@Override
					public void onCheckedChanged(RadioGroup group, int checkedId) {
						switch (checkedId) {
						case R.id.radio_stream_android:
							mStreamController
									.setStreamType(StreamController.STREAM_TYPE_ANDROID);
							break;
						case R.id.radio_stream_pushogg:
							mStreamController
									.setStreamType(StreamController.STREAM_TYPE_PUSHOGG);
							break;
						}
					}
				});

	}

	public static final int STREAM_STATE_STOPPED = 0;
	public static final int STREAM_STATE_STARTING = 1;
	public static final int STREAM_STATE_PLAYING = 2;
	public static final int STREAM_STATE_ERROR = 3;
	public static final int STREAM_STATE_STOPPING = 4;

	public void onStreamStateChange(int state) {
		switch (state) {
		case STREAM_STATE_STARTING:
			mStreamType.setEnabled(false);
			mStreamPref.setEnabled(false);
			mStreamPref.setChecked(true);
			mStreamPref.setText(getString(R.string.stream_state_starting));
			break;
		case STREAM_STATE_ERROR:
			mStreamType.setEnabled(true);
			mStreamPref.setEnabled(true);
			mStreamPref.setChecked(false);
			mStreamPref.setText(getString(R.string.stream_state_error));
			break;
		case STREAM_STATE_PLAYING:
			mStreamType.setEnabled(false);
			mStreamPref.setEnabled(true);
			mStreamPref.setChecked(true);
			mStreamPref.setText(getString(R.string.stream_state_playing));
			break;
		case STREAM_STATE_STOPPED:
			mStreamType.setEnabled(true);
			mStreamPref.setEnabled(true);
			mStreamPref.setChecked(false);
			mStreamPref.setText(getString(R.string.stream_state_stopped));
			mStreamPref.setEnabled(true);
			break;
		case STREAM_STATE_STOPPING:
			mStreamType.setEnabled(false);
			mStreamPref.setEnabled(false);
			mStreamPref.setChecked(false);
			mStreamPref.setText(getString(R.string.stream_state_stopping));
			break;
		}
	}

	@Override
	protected void onPause() {
		super.onPause();
		mStreamController.onPause();
	}

	@Override
	protected void onResume() {
		super.onResume();
		mStreamController.onResume();
	}
}