/**
 * Copyright 2010 Andrew Rice
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package uk.ac.cam.acr31.android.oggstreamer;

import java.io.IOException;

import android.media.MediaPlayer;
import android.media.MediaPlayer.OnCompletionListener;
import android.media.MediaPlayer.OnErrorListener;
import android.media.MediaPlayer.OnPreparedListener;

public class AndroidStreamer implements Streamable {

	private MediaPlayer player;
	private OggStreamerActivity mOggStreamer;
	private String mUrl;

	public AndroidStreamer(OggStreamerActivity oggStreamer) {
		mOggStreamer = oggStreamer;
	}

	/* (non-Javadoc)
	 * @see uk.ac.cam.acr31.android.oggstreamer.Streamable#start(java.lang.String)
	 */
	public void start(String url) {
		mUrl = url;
		player = new MediaPlayer();
		try {
			player.setDataSource(url);
			player.setOnPreparedListener(new OnPreparedListener() {
				@Override
				public void onPrepared(MediaPlayer mp) {
					player.start();
					mOggStreamer
							.onStreamStateChange(OggStreamerActivity.STREAM_STATE_PLAYING);
				}
			});
			player.setOnErrorListener(new OnErrorListener() {
				@Override
				public boolean onError(MediaPlayer mp, int what, int extra) {
					mOggStreamer
							.onStreamStateChange(OggStreamerActivity.STREAM_STATE_ERROR);
					stopPlayer();
					return true;
				}
			});
			player.setOnCompletionListener(new OnCompletionListener() {
				@Override
				public void onCompletion(MediaPlayer mp) {
					mOggStreamer
							.onStreamStateChange(OggStreamerActivity.STREAM_STATE_STOPPED);
					stopPlayer();
				}
			});
			player.prepareAsync();
			mOggStreamer.onStreamStateChange(OggStreamerActivity.STREAM_STATE_STARTING);
		} catch (IllegalArgumentException e) {
			mOggStreamer.onStreamStateChange(OggStreamerActivity.STREAM_STATE_ERROR);
			stopPlayer();
		} catch (IllegalStateException e) {
			mOggStreamer.onStreamStateChange(OggStreamerActivity.STREAM_STATE_ERROR);
			stopPlayer();
		} catch (IOException e) {
			mOggStreamer.onStreamStateChange(OggStreamerActivity.STREAM_STATE_ERROR);
			stopPlayer();
		}
	}

	private void stopPlayer() {
		if (player != null) {
			if (player.isPlaying())
				player.stop();
			player.release();
			player = null;
		}
	}

	/* (non-Javadoc)
	 * @see uk.ac.cam.acr31.android.oggstreamer.Streamable#stop()
	 */
	public void stop() {
		stopPlayer();
		mOggStreamer.onStreamStateChange(OggStreamerActivity.STREAM_STATE_STOPPED);
	}

	@Override
	public void onPause() {
	}

	@Override
	public void onResume() {
	}

	@Override
	public void forceHandover() {
		stopPlayer();
		start(mUrl);
	}
	
}
