#!/usr/local/bin/perl -w
# make_pkts.pl
#
#
# 

use NF2::PacketGen;
use NF2::PacketLib;

use RouterLib;
use reg_defines_bir_starter;

$delay = 4000;
$batch = 0;
nf_set_environment( { PORT_MODE => 'PHYSICAL', MAX_PORTS => 4 } );

# use strict AFTER the $delay, $batch and %reg are declared
use strict;
use vars qw($delay $batch %reg);

####################################################################
# Create a new packet 
# 
# Should go from 1 -> 2

my $MAC_hdr = NF2::Ethernet_hdr->new(DA => 'FF:FF:FF:FF:FF:FF',
                                     SA => '00:ca:fe:00:00:01',
                                     Ethertype => 0x800
);

my $length = 60;

# Make rest of packet (the data)
my $PDU = NF2::PDU->new($length - $MAC_hdr->length_in_bytes() );

my $start_val = $MAC_hdr->length_in_bytes()+1;

$PDU->set_bytes(($start_val..$length));

# Build complete packet data
my $pkt = $MAC_hdr->bytes().$PDU->bytes();

print "Packet is:\n$pkt\n";

nf_packet_in(1, $length,  $delay, $batch,  $pkt);

# In this test the packet should be forwarded directly to port "2"
nf_expected_packet(2, $length,             $pkt);

$delay = 1000;

#####################################################################
# Create a 2nd packet 
#
# Should go from 2 -> nowhere

$MAC_hdr = NF2::Ethernet_hdr->new(DA => 'FF:FF:FF:FF:FF:FF',
                                     SA => '00:ca:fe:00:00:02',
                                     Ethertype => 0x800
);

$length = 60;

# Make rest of packet (the data)
$PDU = NF2::PDU->new($length - $MAC_hdr->length_in_bytes() );

$start_val = $MAC_hdr->length_in_bytes()+1;

$PDU->set_bytes(($start_val..$length));

# Build complete packet data
$pkt = $MAC_hdr->bytes().$PDU->bytes();

print "Packet is:\n$pkt\n";

nf_packet_in(2, $length,  $delay, $batch,  $pkt);

# We don't expect this packet to come out at all during this test

$delay = $delay + 1000;

# *********** Finishing Up - need this in all scripts ! **********************
my $t = nf_write_sim_files();
print  "--- make_pkts.pl: Generated all configuration packets.\n";
printf "--- make_pkts.pl: Last packet enters system at approx %0d microseconds.\n",($t/1000);
if (nf_write_expected_files()) {
  die "Unable to write expected files\n";
}

nf_create_hardware_file('LITTLE_ENDIAN');
nf_write_hardware_file('LITTLE_ENDIAN');


