# SimVision Command Script (Thu Aug 26 12:06:04 PDT 2004)

#
# Databases
#
if {[database find -match exact -name "testdump"] == {}} {
    database open /dryer/mckeown/gwatson/NF2/hw/CNET/verif/regs_tb/testdump.trn -name "testdump"
}

#
# Cursors
#
set time 1645120ps
if {[cursor find -match exact -name "TimeA"] == {}} {
    cursor new -name  "TimeA" -time $time
} else {
    cursor set -using "TimeA" -time $time
}
set time 0
if {[cursor find -match exact -name "TimeE"] == {}} {
    cursor new -name  "TimeE" -time $time
} else {
    cursor set -using "TimeE" -time $time
}
set time 0
if {[cursor find -match exact -name "TimeB"] == {}} {
    cursor new -name  "TimeB" -time $time
} else {
    cursor set -using "TimeB" -time $time
}
set time 0
if {[cursor find -match exact -name "TimeC"] == {}} {
    cursor new -name  "TimeC" -time $time
} else {
    cursor set -using "TimeC" -time $time
}

#
# Groups
#

if {[group find -match exact -name "Group 1"] == {}} {
    group new -name "Group 1" -overlay 0
} else {
    group using "Group 1"
    group set -overlay 0
    group clear 0 end
}
group insert \
    {testdump::regs_tb.cpci_bus.cpci_addr[23:0]} \
    {testdump::regs_tb.cpci_bus.cpci_bus_req} \
    {testdump::regs_tb.cpci_bus.cpci_rd_wr_L} \
    {testdump::regs_tb.cpci_bus.cpci_wr_data[31:0]} \
    {testdump::regs_tb.cpci_bus.cpci_wr_rdy} \
    {testdump::regs_tb.cpci_bus.clk33}

if {[group find -match exact -name "Group 2"] == {}} {
    group new -name "Group 2" -overlay 0
} else {
    group using "Group 2"
    group set -overlay 0
    group clear 0 end
}
group insert \
    {testdump::regs_tb.cpci_bus.write_fifo.wr_en} \
    {testdump::regs_tb.cpci_bus.write_fifo.wr_count[1:0]} \
    {testdump::regs_tb.cpci_bus.write_fifo.wr_clk} \
    {testdump::regs_tb.cpci_bus.write_fifo.din[55:0]}

#
# Design Browser Windows
#
if {[window find -match exact -name "Design Browser 1"] == {}} {
    window new DesignBrowser -name "Design Browser 1" -geometry 957x698+0+0
} else {
    window geometry "Design Browser 1" 957x698+0+0
}
window target "Design Browser 1" on
browser using "Design Browser 1"
browser set \
    -scope {testdump::regs_tb.cpci_bus.write_fifo}

#
# Waveform Windows
#
if {[window find -match exact -name "Waveform 1"] == {}} {
    window new WaveWindow -name "Waveform 1" -geometry 1425x1082+88+36
} else {
    window geometry "Waveform 1" 1425x1082+88+36
}
window target "Waveform 1" on
waveform using "Waveform 1"
waveform set \
    -primarycursor "TimeA" \
    -signalnames name \
    -signalwidth 175 \
    -units ps \
    -valuewidth 75
cursor set -using "TimeA" -time 1,645,120ps
waveform baseline set -time 1,708,000ps

set groupId [waveform add -groups {"Group 2"}]
set startIndex [lsearch -exact [waveform find] $groupId]
set id [lindex [waveform find] [expr {$startIndex + 1}]]
waveform format $id -radix %b
waveform format $id -trace "digital" -color "" -symbol ""
set id [lindex [waveform find] [expr {$startIndex + 2}]]
waveform format $id -trace "digital" -color "" -symbol ""
set id [lindex [waveform find] [expr {$startIndex + 3}]]
waveform format $id -radix %b
waveform format $id -trace "digital" -color "" -symbol ""
set id [lindex [waveform find] [expr {$startIndex + 4}]]
waveform format $id -trace "digital" -color "" -symbol ""

set groupId [waveform add -groups {"Group 1"}]
set startIndex [lsearch -exact [waveform find] $groupId]
set id [lindex [waveform find] [expr {$startIndex + 1}]]
waveform format $id -trace "digital" -color "" -symbol ""
set id [lindex [waveform find] [expr {$startIndex + 2}]]
waveform format $id -radix %b
waveform format $id -trace "digital" -color "" -symbol ""
set id [lindex [waveform find] [expr {$startIndex + 3}]]
waveform format $id -radix %b
waveform format $id -trace "digital" -color "" -symbol ""
set id [lindex [waveform find] [expr {$startIndex + 4}]]
waveform format $id -radix %d
waveform format $id -trace "digital" -color "" -symbol ""
set id [lindex [waveform find] [expr {$startIndex + 5}]]
waveform format $id -radix %b
waveform format $id -trace "digital" -color "" -symbol ""
set id [lindex [waveform find] [expr {$startIndex + 6}]]
waveform format $id -radix %b
waveform format $id -trace "digital" -color "" -symbol ""


waveform xview limits 1512000ps 1708000ps

#
# Preferences
#
preferences set analog-height {5}
preferences set color-verilog-by-value {1}
preferences set default-time-units {ns}
preferences set delete-unused-cursors-on-exit {1}
preferences set delete-unused-groups-on-exit {1}
preferences set initial-zoom-out-full {0}
preferences set key-bindings {
	Edit>Undo "Ctrl+Z"
	Edit>Redo "Ctrl+Y"
	Edit>Copy "Ctrl+C"
	Edit>Cut "Ctrl+X"
	Edit>Paste "Ctrl+V"
	Edit>Delete "Del"
	openDB "Ctrl+O"
	View>Zoom>InX "Alt+I"
	View>Zoom>OutX "Alt+O"
	View>Zoom>FullX "Alt+="
	View>Zoom>InX_widget "I"
	View>Zoom>OutX_widget "O"
	View>Zoom>FullX_widget "="
	View>Zoom>Cursor-Baseline "Alt+Z"
	View>Center "Alt+C"
	View>ExpandSequenceTime>AtCursor "Alt+X"
	View>CollapseSequenceTime>AtCursor "Alt+S"
	Edit>Create>Group "Ctrl+G"
	Edit>Ungroup "Ctrl+Shift+G"
	Edit>Create>Marker "Ctrl+M"
	Edit>Create>Condition "Ctrl+E"
	Edit>Create>Bus "Ctrl+W"
	Explore>NextEdge "Ctrl+\]"
	Explore>PreviousEdge "Ctrl+\["
	ScrollRight "Right arrow"
	ScrollLeft "Left arrow"
	ScrollUp "Up arrow"
	ScrollDown "Down arrow"
	PageUp "PageUp"
	PageDown "PageDown"
	TopOfPage "Home"
	BottomOfPage "End"
}
preferences set prompt-exit {1}
preferences set restore-state-on-startup {0}
preferences set save-state-on-startup {0}
preferences set search-toolbar {1}
preferences set seq-time-width {30}
preferences set show-times-on-cursors {1}
preferences set show-times-on-markers {1}
preferences set signal-type-colors {
	group #0000FF
	overlay #0000FF
	input #FFFF00
	output #FFA500
	inout #00FFFF
	internal #00FF00
	fiber #FF99FF
	errorsignal #FF0000
	unknown #FFFFFF
}
preferences set snap-to-edge {1}
preferences set toolbars-style {icon}
preferences set transaction-height {3}
preferences set use-signal-type-colors {0}
preferences set use-signal-type-icons {1}
preferences set verilog-colors {
	HiZ #ff9900
	StrX #ff0000
	Sm #00ff99
	Me #0000ff
	We #00ffff
	La #ff00ff
	Pu #9900ff
	St #00ff00
	Su #ff0099
	0 #00ff00
	1 #00ff00
	X #ff0000
	Z #ff9900
	other #ffff00
}
preferences set vhdl-colors {
	U #9900ff 
	X #ff0000 
	0 #00ff00 
	1 #00ff00 
	Z #ff9900 
	W #ff0000
	L #00ffff 
	H #00ffff
	- #0000ff
}
preferences set waveform-banding {1}
preferences set waveform-height {12}
preferences set waveform-space {4}
