/********************************************************
*
* C register defines file for CPCI_2.1
*
********************************************************/

#ifndef _REG_DEFINES_
#define _REG_DEFINES_

/* ========= Constants ========= */

// ===== File: lib/verilog/core/common/xml/global.xml =====

// Maximum number of phy ports
#define MAX_PHY_PORTS                 4

// PCI address bus width
#define PCI_ADDR_WIDTH                32

// PCI data bus width
#define PCI_DATA_WIDTH                32

// PCI byte enable bus width
#define PCI_BE_WIDTH                  4

// CPCI--CNET address bus width. This is byte addresses even though bottom bits are zero.
#define CPCI_CNET_ADDR_WIDTH          27

// CPCI--CNET data bus width
#define CPCI_CNET_DATA_WIDTH          32

// CPCI--NF2 address bus width. This is byte addresses even though bottom bits are zero.
#define CPCI_NF2_ADDR_WIDTH           27

// CPCI--NF2 data bus width
#define CPCI_NF2_DATA_WIDTH           32

// DMA data bus width
#define DMA_DATA_WIDTH                32

// DMA control bus width
#define DMA_CTRL_WIDTH                4

// CPCI debug bus width
#define CPCI_DEBUG_DATA_WIDTH         29

// SRAM address width
#define SRAM_ADDR_WIDTH               19

// SRAM data width
#define SRAM_DATA_WIDTH               36

// DRAM address width
#define DRAM_ADDR_WIDTH               24


// ===== File: lib/verilog/core/common/xml/nf_defines.xml =====

// Clock period of 125 MHz clock in ns
#define FAST_CLK_PERIOD               8

// Clock period of 62.5 MHz clock in ns
#define SLOW_CLK_PERIOD               16

// Header value used by the IO queues
#define IO_QUEUE_STAGE_NUM            0xff

// Data path data width
#define DATA_WIDTH                    64

// Data path control width
#define CTRL_WIDTH                    8


// ===== File: projects/CPCI_2.1/include/cpci_regs.xml =====

// CPCI version number (major number)
#define CPCI_VERSION_ID               0x000003

// CPCI revision number (minor number)
#define CPCI_REVISION_ID              0x04

// Default maximum time for DMA transfers (in clock cycles)
#define CPCI_DMA_XFER_TIME_DEFAULT    30000

// Default maximum number of retries for DMA transactions
#define CPCI_DMA_RETRIES_DEFAULT      0xffff

// Default maximum Virtex register read time
#define CPCI_CNET_READ_TIME_DEFAULT   4000

// Number of PCI cycles in an interation
#define CPCI_P_MAX_DEFAULT            3333333

// Expected number of CPCI-Virtex clocks in the PCI period defined above
#define CPCI_N_EXP_DEFAULT            6250000


// -------------------------------------
//   Modules
// -------------------------------------

// Module tags
#define CPCI_BASE_ADDR  0x0000000



/* ========== Registers ========== */

// Name: cpci (CPCI)
// Description: CPCI registers
// File: projects/CPCI_2.1/include/cpci_regs.xml
#define CPCI_ID_REG                    0x0000000
#define CPCI_BOARD_ID_REG              0x0000004
#define CPCI_CTRL_REG                  0x0000008
#define CPCI_RESET_REG                 0x000000c
#define CPCI_ERROR_REG                 0x0000010
#define CPCI_DUMMY_REG                 0x0000020
#define CPCI_INTERRUPT_MASK_REG        0x0000040
#define CPCI_INTERRUPT_STATUS_REG      0x0000044
#define CPCI_CNET_CLK_SEL_REG          0x0000050
#define CPCI_REPROG_DATA_REG           0x0000100
#define CPCI_REPROG_STATUS_REG         0x0000104
#define CPCI_REPROG_CTRL_REG           0x0000108
#define CPCI_DMA_ADDR_I_REG            0x0000140
#define CPCI_DMA_ADDR_E_REG            0x0000144
#define CPCI_DMA_SIZE_I_REG            0x0000148
#define CPCI_DMA_SIZE_E_REG            0x000014c
#define CPCI_DMA_CTRL_I_REG            0x0000150
#define CPCI_DMA_CTRL_E_REG            0x0000154
#define CPCI_DMA_XFER_TIME_REG         0x0000180
#define CPCI_DMA_RETRIES_REG           0x0000184
#define CPCI_CNET_READ_TIME_REG        0x0000188
#define CPCI_DMA_INGRESS_PKT_CNT_REG   0x0000400
#define CPCI_DMA_EGRESS_PKT_CNT_REG    0x0000404
#define CPCI_CPCI_REG_READ_CNT_REG     0x0000408
#define CPCI_CPCI_REG_WRITE_CNT_REG    0x000040c
#define CPCI_CNET_REG_READ_CNT_REG     0x0000410
#define CPCI_CNET_REG_WRITE_CNT_REG    0x0000414
#define CPCI_CLOCK_CHECK_N_CLK_REG     0x0000500
#define CPCI_CLOCK_CHECK_P_MAX_REG     0x0000504
#define CPCI_CLOCK_CHECK_N_EXP_REG     0x0000508
#define CPCI_PCI_CLK_CNT_REG           0x0000510
#define CPCI_CPCI_RESET_CNT_REG        0x0000520




#endif

