(**************************************************************)
(*                                                            *)
(*	general lib stuff for native code generator 	      *)
(*                                                            *)
(* this file contains all the function definitions that       *) 
(* are used throught the native code generator                *)
(*							      *)
(**************************************************************)


(**************************************************************)
(*
 *  generaly useful Higher order sytle functions
 *)

fun filter p l = 
    let
	fun filter'(l) = if null l then [] else
	    let 
		val (a::x) = l
	    in
		if p a then a::filter'(x) else filter'(x)
	    end
    in
	filter'(l)
    end;

(**************************************************************)
(*
 * producing a list 
 *)

infix --;

fun x -- y = 
let
    fun f' (x,y,z) = if x = y then x::z
    else f'(x,y-1,y::z)
in    
   if x<=y then f' (x,y,[]) else [] (* raise Home_and_Array*)
end;

(**************************************************************)
(*
 * Output a string to the stdout
 *)

fun outstring(e) = output(std_out,e);
fun outline(e) = output(std_out,e^"\n");

(**************************************************************)
(*
 * A sorting routine (from the compiler itself) 
 *)

    fun sort (l) =
	let 
	    fun splitn(n,l1,l2) =
		if n=0 then (l1, l2)
		else splitn( n-1, tl l1, (hd l1)::l2 )
	    fun split(l) = splitn( length(l) div 2, l, nil )
	    fun merge(l1,l2) =
		if null l1 then l2
		else if null l2 then l1
		     else
			 let val x1 = hd l1 and x2 = hd l2 in
			     if (x1 > (x2:int)) then x1::merge(tl l1,l2)
			     else x2::merge(l1,tl l2) end
	    fun sort'sub(l) =
		if length(l)>1 then
		    let val (l1,l2) = split(l) 
		    in merge(sort'sub(l1),sort'sub(l2)) end
            else l
	in
	    sort'sub (l)
	end;

(**************************************************************)

fun fst(a,b) = a and snd(a,b) = b;
	
fun I x = x; 
fun K x y = x;

(**************************************************************)
(*
 * produce an 'n' char base 'b' string of a number 
 *)
local
    fun digittochar n = chr(if n < 10 then n+48 else n+55);
in
    fun AnyBase(h,x,b) = 
	if x = 0 
	    then ""
	else (AnyBase(h div b,x-1,b)^(digittochar (h mod b)));

    fun Hex(x,y) = AnyBase(x,y,16);
end;

(*
 * produce a string from a decimal number
 *)

fun $ (x:int) = makestring x;

(**************************************************************)
(*
 * The Functions Use for Accessing and Creating texts
 *
 *)

local
    nonfix makenativetext 81 3
	
    nonfix storeByte 118 3
    nonfix storeWord 119 3
	
    nonfix textLength 236 1
	
    nonfix fetchByte 237 2
    nonfix fetchWord 238 2

    nonfix VetText 244 1;

    nonfix amnesic 6 1


    fun amnesic x = amnesic x;



    abstype literalpool = LITERALPOOL 
	with 
	    val () = () 
        end;

(*
 * create a text of a specified length
 *)    

    fun makenativetext(OldText : text,
		 ObjCodeLength:int, 
		 literals: literalpool):text = makenativetext(OldText,
							      ObjCodeLength,
							      literals)

(* 
 * store{Byte,Word,Long} value at offset in text t
 *)

    fun storeByte(value:int,t:text,offset:int):unit = storeByte(value,t,offset)
    and storeWord(value:int,t:text,offset:int):unit = storeWord(value,t,offset)

(*
 * number of bytes in text t
 * note that texts are allocated 
 * in multiples of 4 bytes so last few 
 * may be null
 *)

    fun textLength(t:text):int = textLength(t)
(*
 * get a part of a text
 *)

    fun fetchByte(t:text,offset:int):int = fetchByte(t:text,offset:int)
    and fetchWord(t:text,offset:int):int = fetchWord(t:text,offset:int)

 (*
  *  Get a literal (not used a present)
  *)

    fun getliterals(t:text):literalpool = 
	let 
	    val (lits,_) = amnesic t
	in
	    lits
	end

    fun nametext (x:text):string = 
	let
	    val (name,_) = amnesic(getliterals x)
	in
	    name
	end;

(*
 * Check that a text actualy is a text 
 *)

    fun VetText (n:text):int = VetText(n);

in
    val Text = {makenativetext = makenativetext,
		getliterals = getliterals,
		storeByte = storeByte,
		storeWord = storeWord,
		fetchByte = fetchByte,
		fetchWord = fetchWord,
		textLength = textLength,
		VetText = VetText,
		nametext = nametext
		}
end;

(**************************************************************)
(* 
 * The Array Primitives
 *)

local
    infix  3 sub 105 2; 
    nonfix assign 106 3; 
    nonfix arrayoflist 121 1;

(*
 * The ESML Array Primitives 
 *)

  fun (x: 'a array) sub (y:int) = (x sub y): 'a
  fun assign(x: 'a array, y:int, z: 'a):unit = assign(x,y,z)
  fun arrayoflist(x: '_weak list): '_weak array = arrayoflist(x);
in
    val ESML_Array = {sub = op sub,   (* look at op ? *)
		 assign = assign,
		 arrayoflist = arrayoflist
		 }
end;

fun SizeUp() = real(!(#NativeCodeSize NCinfo)) / real(!(#ByteCodeSize NCinfo));

fun SizeReset () =
let
	val _ = #ByteCodeSize NCinfo := 0
	val _ = #NativeCodeSize NCinfo := 0
in
	()
end;


(**************************************************************)
(*
 * simple stuff to supply a new number each time called 
 *
 *
 *)

		       
local
  val jumpvals = ref []
in
  fun addjump x = jumpvals := (x)::(!jumpvals);
  fun accessjumps () = !jumpvals
  fun resetjumps () = jumpvals := [];
end;


fun listof x y = map (fn _ => y) (1--x);

    
(**************************************************************)
(* 
 *  A simple symbol table
 *) 


abstype ('a,'b) SYMBOLTABLE =  
      STEMPTY | FORK of {
			 item : 'a, 
			 result : 'b, 
			 lz : int, lt : ('a,'b) SYMBOLTABLE,
			 rz : int, rt : ('a,'b) SYMBOLTABLE
			 }
with
    exception SymbolTableError of string;

    val NewTable = STEMPTY;

    fun MakeDict (f) = 
	let

	    fun FindVal'(a,FORK{item,result,lt,lz,rt,rz}) = 
		if (a=item) then result
		else if f(a,item) 
			 then FindVal'(a,lt)
		     else FindVal'(a,rt);


	    fun FindVal x = (FindVal' x handle _ => 
			     raise (SymbolTableError "Cant Find Item"));
	    fun InTable x = ((FindVal' x; true) handle _ => false);
		
	    fun GetRfromL (FORK{item,result,lz,lt,rz,rt}) =
		if rz = 0
		    then (item,result,lt)
		else
		    let
			val (i,r,t) = GetRfromL(rt)
		    in
			(i,r,FORK {item=item,
				   result=result,
				   lz=lz,
				   lt=lt,
				   rz=rz-1,
				   rt=t
				   })
		    end;

		
	    fun GetLfromR (FORK{item,result,lz,lt,rz,rt}) =
		if lz = 0
		    then (item,result,rt)
		else
		    let
			val (i,r,t) = GetLfromR(lt)
		    in
			(i,r,FORK {item=item,
				   result=result,
				   lz=lz-1,
				   lt=t,
				   rz=rz,
				   rt=rt
				   })
		    end;


	    fun (*native*) AddEntry(a,b,FORK{item,result,lz,lt,rz,rt}) =
		if (a=item) 
		    then raise (SymbolTableError "Cant add same item twice")
		else if f(a,item) 
			 then 
			     if lz <= rz then FORK{
						  item = item,
						  result = result,
						  lz = lz+1,
						  lt = AddEntry(a,b,lt),
						  rz = rz,
						  rt = rt
						  }
			     else 
				 let
				     val (i,r,t) = GetRfromL(AddEntry(a,b,lt))
				 in
				     FORK{
					  item = i,
					  result = r,
					  lz = lz,
					  lt = t,
					  rz = rz+1,
					  rt = AddEntry(item,result,rt)
					  }
				 end
		     else
			 if lz >= rz then FORK{
					      item = item,
					      result = result,
					      lz = lz,
					      lt = lt,
					      rz = rz+1,
					      rt = AddEntry(a,b,rt)
						  }
			 else 
			     let
				 val (i,r,t) = GetLfromR(AddEntry(a,b,rt))
			     in
				 FORK{
				      item = i,
				      result = r,
				      lz = lz+1,
				      lt = AddEntry(item,result,lt),
				      rz = rz,
				      rt = t
				      }
				 end
	      | AddEntry(a,b,STEMPTY) = FORK{
					      item = a,
					      result = b,
					      lz = 0,
					      lt = STEMPTY,
					      rz = 0,
					      rt = STEMPTY
					      };


	in
	    {FindVal = FindVal,AddEntry = AddEntry,InTable = InTable}
	end;

(******* (for examining the absdata type, while debuging) ********

	fun spaces 0 = ""
	  | spaces n = "   "^(spaces (n-1));

	fun lookin (STEMPTY,_,_,_,_) = ()
	  | lookin (FORK{lz,lt,rz,rt,item,result},mi,mr,y,p) = 
	    let
		val x = spaces y
	    in
		lookin(rt,mi,mr,y+1,"R");
		outstring(x^"/("^p^")---------------------------------------");
		outstring("\n"^x^"< item  = "^mi item^
			  ", result  = "^mr result^
			  ", left  = "^makestring lz^
			  ", right = "^makestring lz^"\n");
		outstring(x^"\\-------------------------------------------\n");
		lookin(lt,mi,mr,y+1,"L")
	    end;
**************)	    
	    
	
end;


(*
 *  debug 
 *)

    fun debug s = if !(#PrintDebug Ncopt)
		      then outstring s
		  else ();
