syntax nonfix Openstream 164 1;
syntax nonfix Createstream 165 1;
syntax nonfix Readstream 166 2;
syntax nonfix ReadToBuffer 167 3;
syntax nonfix Writestream 168 2;
syntax nonfix CloseInStream 169 1;
syntax nonfix CloseOutStream 169 1;
syntax nonfix Interactive 170 1;
syntax nonfix MoveWithinBuffer 159 4;
syntax nonfix BufferOfLength 160 1;

let type buffer <=> string    %AM: eventually lose this correspondence%
with absBuffer = absbuffer and repBuffer = repbuffer    %AM: and these%
and rec MoveWithinBuffer(t: buffer, from: int, to: int, n: int ): unit = 
             MoveWithinBuffer(t, from, to, n)
    and BufferOfLength(n: int): buffer = BufferOfLength(n);

let rec type {instream <=> instream and outstream <=> outstream}
with rec { Openstream(filename:string):instream = Openstream(filename)
     and   Createstream(filename:string):outstream = Createstream(filename)
     and   Readstream(s:instream, length: int):string = Readstream(s,length)
     and   ReadToBuffer(s:instream, t: buffer, start: int):int =
               ReadToBuffer(s,t,start)
     and   Writestream(s:outstream, str: string):unit = Writestream(s,str)
     and   CloseInStream(s:instream):unit = CloseInStream(s)
     and   CloseOutStream(s:outstream):unit = CloseOutStream(s)
     and   Interactive(s:instream):bool = Interactive(s)
};

let rec readlines(instr, outstr) =
  let () = Writestream(outstr, `$ `)
  enc newline = Readstream(instr,256)
  enc lineminlf = substring(newline,1,LengthTok(newline)-1) in
  (system(lineminlf); readlines(instr, outstr))
ins vms() =
  let instr = Openstream(`tt:`) enc outstr = Createstream(`tt:`) 
  enc () = Writestream(outstr, `Type Cntrl Z to terminate, or logout./R/L`) in
  readlines(instr,outstr) 
  ?? [`EndOfInput`] (CloseInStream(instr); CloseOutStream(outstr));

