
module life(
	input CLOCK_50,
	input CLOCK_27,
	inout PS2_CLK,
	input [3:0] KEY,
	output [9:0] VGA_R,
	output [9:0] VGA_G,
	output [9:0] VGA_B,
	output VGA_CLK,
	output VGA_BLANK,
	output VGA_HS,
	output VGA_VS,
	output VGA_SYNC,
	output [17:0] LEDR,
	output [8:0] LEDG,
	output [6:0] HEX0,
	output [6:0] HEX1,
	output [6:0] HEX2,
	output [6:0] HEX3,
	output [6:0] HEX4,
	output [6:0] HEX5,
	output [6:0] HEX6,
	output [6:0] HEX7,
	output TD_RESET,
	output [11:0] DRAM_ADDR,
	output DRAM_BA_0,
	output DRAM_BA_1,
	output DRAM_LDQM,
	output DRAM_UDQM,
	output DRAM_RAS_N,
	output DRAM_CAS_N,
	output DRAM_CKE,
	output DRAM_WE_N,
	output DRAM_CS_N,
	output DRAM_CLK,
	inout [15:0] DRAM_DQ,
	inout PS2_DAT
	);
	
	assign TD_RESET = 1'b1;
	
	wire video_clock;
	wire CLOCK_25;
	
	pll108MHz pll(.inclk0(CLOCK_50), .c0(video_clock));
	pll25MHz pll25(.inclk0(CLOCK_27), .c0(CLOCK_25), .c1(DRAM_CLK));
	
	assign VGA_CLK = video_clock;
	assign VGA_SYNC = 0;
	
	wire candraw;
	wire start;
	wire [10:0] x;
	wire [10:0] y;
	
	wire [7:0] change_x;
	wire [7:0] change_y;
	wire [7:0] controls;
	
	assign left = button_press;
		
	mouse m(
		.clk(CLOCK_25),
		.ps2_clk(PS2_CLK),
		.ps2_data(PS2_DAT),
		.resend(resend),
		.data(mousedata),
		.datarx(datarx)
		);
	
	wire [7:0] mousedata;
	wire [10:0] cursor_x, cursor_y;
	wire datarx;
	wire button_press;
	wire resend;
	mouse_logic ml(
		.clk(CLOCK_25),
		.data_rx(datarx),
		.data(mousedata),
		.resend(resend),
		.x(cursor_x),
		.y(cursor_y),
		.left(button_press)
		);

	params p(
		.clk(video_clock),
		.vsync(VGA_VS),
		.hsync(VGA_HS),
		.x(x),
		.y(y),
		.can_draw(candraw),
		.start_of_frame(start)
		);
		
	renderer r(
		.clk(video_clock),
		.candraw(candraw),
		.x(x),
		.y(y),
		.cursor_x(cursor_x),
		.cursor_y(cursor_y),
		.red(VGA_R),
		.green(VGA_G),
		.blue(VGA_B),
		.vga_blank(VGA_BLANK),
		.addr(rdaddr),
		.data(data_out)
		);

	wire [7:0] data_out;
	wire [10:0] rdaddr;
endmodule 