/**********************************************************
 *  This work by Richard Leivers (rjl67@cam.ac.uk)        * 
 *  is licenced under the Creative Commons                *
 *  Attribution-Non-Commercial-Share Alike 2.0 UK:        *
 *  England & Wales License.                              *
 *                                                        *
 *  To view a copy of this licence, visit                 *
 *  http://creativecommons.org/licenses/by-nc-sa/2.0/uk/  *
 *  or send a letter to Creative Commons,                 *
 *  171 Second Street, Suite 300, San Francisco,          *
 *  California 94105, USA.                                *
 *                                                        *
 **********************************************************	 	
 *	Manchester Baby simulator in Java  	*
 * 	Richard Leivers - July 2009        	*
 * 										*
 *	TOP LEVEL MODULE					*
 ****************************************/

import java.awt.*;
import javax.swing.*;

public class Baby {
	
	public static void main(String[] args) {
		
		System.out.println("\n\n****************************************");
		System.out.println("*   Manchester Baby simulator in Java  *");
		System.out.println("*   Richard Leivers - July 2009        *");
		System.out.println("****************************************\n\n");
		
		
		// Check valid number of arguments are supplied
		if (args.length != 1)
			{
			System.out.println("Usage: java Baby SOURCE.SNP");
			System.exit(1);
			}
		
		// General catch-all for exceptions
		try{
			// Create 32x32 memory and import file
		    Memory mem = new Memory(args[0]);
		    
		    // Launch display
	        JFrame frame = new JFrame("Williams Tube memory display");
	        JPanel panel = new DisplayPanel(mem);
	        frame.setSize(800,600);
	        panel.setPreferredSize(new Dimension(800,600));
	        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
	        frame.getContentPane().add(panel);
	        frame.pack();
	        frame.setVisible(true);
		    
	        // Create instance of processor and run
	        BabyProc processor = new BabyProc(mem, panel);
	        int count = processor.run();
	        
	        // Processor returns number of cycles used, so output this
	        System.out.println("Execution terminated after " + count + " instructions");	
	    }
		// Catch and print any expressions
		catch (Exception e){
			System.err.println("Error: " + e);
		}
	}
}

