//
// $Id: $
//
// A version of the BTLM system with local rams for each node.
//
// (C) 2009-10 DJ Greaves (TLM 2.0 Version Arturs Prieditis). 
//
//#include "OR1200.h"
#include "orsim_sc.h"
#include "busmux.h"
#include "cbgram.h"
#include "cbguart.h"
#include <iostream>

#define BENCH_CLK_HALFPERIOD 5
#define TIMESCALE_UNIT SC_NS

#define TRACE 0
#define NO_OF_CORES 4


SC_MODULE(procnode)
{
 public:
  OR1200 *core;              // ORP 1200 core
  cbgram *localram;          // Local private memory for this node
  busmux *busmux0;           // A multiplexor to gain access to the private memory.

  void loadprog(const char *s)
  {
    localram->loadme(s, 1);
  }

  procnode(sc_core::sc_module_name name, uint8_t pID):    sc_module(name)
    {
      char txt[20];
      sprintf(txt, "localram_%d", pID);
      localram = new cbgram(txt, 0x40000, 0);
      
      
      sprintf(txt, "orpcore_%d", pID);
      core = new OR1200(txt, pID);
      
      sprintf(txt, "busmux_%d", pID);
      busmux0 = new busmux(txt, 0x20000);
      
      busmux0->init_socket.bind(localram->port0);
      core->initiator_socket.bind(busmux0->targ_socket);
    }

};


int sc_main(int argc, char* argv[])
{
  const char *image_name = (argc > 1) ? argv[1]: "../image.out";

  procnode *nodes[NO_OF_CORES];
  cbgram initiator_ram("initiator_ram", 0x20000, 0);
  cbguart uart0("uart0", 1, 1);

  busmux uartmux("uartmux", 0x8000000);
  uartmux.init_socket.bind(initiator_ram.port0);
  uartmux.init_socket.bind(uart0.port0);


  for(int i=0;i<NO_OF_CORES;i++)
    {
      char txt[20]; sprintf(txt, "procnode_%d", i);
      nodes[i] = new procnode(txt, i);
      nodes[i]->busmux0->init_socket.bind(uartmux.targ_socket);
      nodes[i]->loadprog(image_name);
    }


  
  cout<<"Simulation is beginning..."<<endl;
  sc_start();
  return 0;
}

// eof
