//
// $Id: $
//
//
  static int kk = 0;

#include "systemc.h"
#include "orsim_sc.h"
#include "llsc_extension.h"

class argv_backdoor_setup *argv_backdoor = 0;

#define TRC(X)
#define TRCW1(X) 

SC_HAS_PROCESS(OR1200::OR1200);

volatile bool OR1200::over = false;

// Constructor
OR1200::OR1200(sc_core::sc_module_name name, uint8_t pID):
  sc_module(name),
  initiator_socket("initiator_socket"),
  orsim(name)
 
{
  atomics = 0;
  procID=pID;
  SC_THREAD(run);
  char txt[20];
  sprintf(txt, "ORSIM_CORE_%d", procID);
  tracing = 0;
  counter_ticks = 0;
  where_last = 0;
}

void OR1200::reset()
{
  halted = false;
  core_reset();
}


// Main model process loop
void OR1200::run()
{
  sc_time period(5, SC_NS);
  sc_time local_quantum(1000, SC_NS);
  maindelay = SC_ZERO_TIME;
  reset();
  while(!over)
    {
      step();
      TRC(dumpreg());
      if (kk > 152833) dumpreg();
      maindelay += period;

      while (halted) wait(1, SC_US);
      counter_ticks += 1;
      if (maindelay > local_quantum)
	{
	  wait(maindelay);
	  maindelay = period;
	}
      //      m_qk.inc( LOCAL_INC  );// Model time used for additional processing
      //      if (m_qk.need_sync()) m_qk.sync();

    }
}



uint32_t OR1200::eval_mem32 (oraddr_t memaddr, int *bp)
{
  uint32_t rdata;
  if (atomics)
    {
      assert(atomics == 1);
      assert(memaddr == atomic_addr);
      atomics = 0;
      rdata = eval_compare_and_swap(memaddr, atomic_wdata, maindelay);
    }
  else
    {
      rdata = mem_read(memaddr, maindelay);
    }    
  TRC(printf("Read data %x %x\n", memaddr, rdata));
  return rdata;
}

uint16_t OR1200::eval_mem16 (oraddr_t memaddr, int *bp)
{
  uint32_t r0 = mem_read(memaddr & ~3, maindelay);
  if (1)
    {
      uint16_t rdata =  (memaddr & 2) ? r0: r0 >> 16;
      TRC(printf("Short load %x %x %x\n", memaddr, r0, rdata));
      return rdata;
    }
}    

uint8_t OR1200::eval_mem8 (oraddr_t memaddr, int *bp)
{
  uint32_t r0 = mem_read(memaddr & ~3, maindelay);
  if (1)
    {
      uint8_t rdata =  r0 >> (8 *(3 ^(memaddr & 3)));
      TRC(printf("Byte load %x %x %x %c\n", memaddr, r0, rdata, isprint(rdata)? rdata:' '));
      return rdata;
    }

}    


void OR1200::atomic_prefix() // Prefix following load/store pair as atomic.
{
  atomics = 2; // Trigger atomic transaction state machine.
}

uint8_t eval_direct8(unsigned int a, int e, int b)
{
    assert(0);
}    


#define TRCW(addr, wdata, wdith) if (tracing > 0) { printf("[Writing %i %x %x]\n", procID, addr, wdata); tracing -= 1; }

void OR1200::set_mem32 (oraddr_t memaddr, uint32_t wdata, int *bp)
{
  if (atomics) 
  {
    atomics -= 1;
    atomic_addr = memaddr;
    atomic_wdata = wdata;
  }
  else
    {
      TRCW1(printf("Int store %x %x\n", memaddr, wdata));
      mem_write(memaddr,  15, wdata, maindelay);
    }    
}


void OR1200::set_mem16 (oraddr_t memaddr, uint16_t wdata, int *bp)
{
  TRCW1(printf("Short store %x %x\n", memaddr, wdata));
  mem_write(memaddr,  (memaddr & 2) ? 3:12, (memaddr & 2) ? wdata: wdata<<16, maindelay);

}    

void OR1200::set_mem8 (oraddr_t memaddr, uint8_t wdata, int *bp)
{
  TRCW1(printf("Byte store %x %x\n", memaddr, wdata));
  mem_write(memaddr,  1 << ((3 ^ memaddr) & 3), wdata << (8*((3 ^ memaddr) & 3)), maindelay);
}    


void OR1200::set_direct8 (oraddr_t, uint8_t, int, int)
{

};


uint8_t OR1200::eval_direct8(unsigned int, int, int)
{
  return 0;
}

uint32_t OR1200::mem_read(uint32_t memaddr, sc_time &delay)
{
  #include "backdoor_reads.C"
  uint32_t rdata;
  tlm::tlm_generic_payload  trans;
  uint8_t mask = 15;
  trans.set_read();
  trans.set_address( (sc_dt::uint64) memaddr);
  trans.set_data_length(4);
  trans.set_data_ptr( (unsigned char *) &rdata);
  trans.set_byte_enable_length(1);
  trans.set_byte_enable_ptr(&mask);
  trans.set_streaming_width( 4 );
  trans.set_dmi_allowed( false );
  trans.set_response_status( tlm::TLM_INCOMPLETE_RESPONSE );


  //  TRCR(memaddr, rdata, 32);
  initiator_socket->b_transport(trans, delay);
  if (trans.is_response_error())
    {
      char txt[100];
      sprintf(txt, "Error from b_mem_access, response status = %s", trans.get_response_string().c_str());
      SC_REPORT_ERROR("TLM-2", txt);
    } 

  if (!(counter_ticks & 0x1FFFFF))printf("[Reading %i a=%x %x]\n", procID, memaddr, rdata); 

  //  if (kk > 152833 && (memaddr & 0xFF0000) == 0xFE0000) printf("mem read %x with %x\n", memaddr, rdata);
  return rdata;

}

// Not a compare and swap : its an exchange!
uint32_t OR1200::eval_compare_and_swap(uint32_t memaddr, uint32_t wdata, sc_time &delay)
{
  uint32_t rdata;
  tlm::tlm_generic_payload *trans = llsc_mm.allocate();
  uint8_t mask = 15;
  trans->set_address( (sc_dt::uint64) memaddr);
  trans->set_data_length(4);
  trans->set_byte_enable_length(1);
  trans->set_byte_enable_ptr(&mask);
  trans->set_streaming_width( 4 );
  trans->set_dmi_allowed( false );

  llsc_extension llsc;
  llsc.id = (void *) procID;
  trans->set_auto_extension<llsc_extension>(&llsc);


  while(1)
    {
      if (!(counter_ticks & 0x7FFFF))printf("[Read/Mod/Write %i a=%x %x]\n", procID, memaddr, wdata); 
     
      // First read old value with load locked.
      trans->set_read();
      trans->set_data_ptr( (unsigned char *) &rdata);
      trans->set_response_status( tlm::TLM_INCOMPLETE_RESPONSE );
      initiator_socket->b_transport(*trans, delay);
      if (trans->is_response_error())
	{
	  char txt[100];
	  sprintf(txt, "Load locked failed : %s", trans->get_response_string().c_str());
	  SC_REPORT_ERROR("TLM-2", txt);
	  break;
	} 



      // Then store conditional
      trans->set_write();
      trans->set_data_ptr( (unsigned char *) &wdata);
      trans->set_response_status( tlm::TLM_INCOMPLETE_RESPONSE );

      llsc_extension * ext = 0;
      trans->get_extension(ext);
      assert(ext);  // not been disposed of ?

      initiator_socket->b_transport(*trans, delay);
     
      if (trans->is_response_error())
	{
	  char txt[100];
	  sprintf(txt, "Store conditional failed (will retry) : %s", trans->get_response_string().c_str());
	  SC_REPORT_ERROR("TLM-2", txt);

	  delay += sc_time(1, SC_US);
	  m_qk.sync();
	} 
      else break;
    }
  llsc_mm.free(trans);
  return rdata;
}

void OR1200::mem_write(uint32_t  memaddr,  uint8_t mask, uint32_t wdata, sc_time &delay)
{
  #include "backdoor_writes.C"
  tlm::tlm_generic_payload  trans;
  TRCW(memaddr, wdata, 32);
  trans.set_write();
  trans.set_address( (sc_dt::uint64) memaddr);
  trans.set_data_length(4);
  trans.set_data_ptr( (unsigned char *) &wdata);
  trans.set_byte_enable_length(1);
  trans.set_byte_enable_ptr(&mask);
  trans.set_streaming_width( 4 );
  trans.set_dmi_allowed( false );
  trans.set_response_status( tlm::TLM_INCOMPLETE_RESPONSE );

#if 0
  if (memaddr < 0x20000) 
    {
      printf("Wrote low %x %x %x\n", memaddr, wdata, where_last);
      dumpreg();
    }
  if (kk > 152833 && (memaddr & 0xFF0000) == 0xFE0000) printf("mem write %x with %x\n", memaddr, wdata);
#endif
  //  TRCR(memaddr, rdata, 32);
  initiator_socket->b_transport(trans, delay);
  if (trans.is_response_error())
    {
      char txt[100];
      sprintf(txt, "Error from b_mem_access, response status = %s", trans.get_response_string().c_str());
      SC_REPORT_ERROR("TLM-2", txt);
    } 
}


uint32_t OR1200::eval_insn(unsigned int memaddr, int *bp)
{
  uint32_t rdata = mem_read(memaddr, maindelay);
  TRC(printf("Fetch insn %x %x\n", memaddr, rdata));
#if 0
  if (memaddr == 0x138) kk = 1000000;
  if (abs((signed)memaddr - (signed)where_last) > 0x32)
    {
      if (!((kk++) & 63))printf(" %i %i  branch to %x\n", kk, procID, memaddr);
    }
  if (kk > 152833) printf("Fetch insn %x %x\n", memaddr, rdata);
#endif
  where_last = memaddr;
  return rdata;
}


void OR1200::corepause(int us)  // Pause CPU for this time interval
{
  // We need to implement the halt and interrupt material as well...
  sc_time delay(us, SC_US);
  maindelay += delay;
}

// eof
