// $Id: $
// DJ Greaves.
// CBG TLM/ESL console uart model: in popup xterm or using stdin/out depending on the console mode
//

#define UTRC(X) 
#include "cbguart.h"


void *input_caller0(void *it)
{
  return ((cbguart*)it)->input_process(0);
}

void *input_caller1(void *it)
{
  return ((cbguart*)it)->input_process((void *)1);
}


void *cbguart::input_process(void *arg)
{
  while (1) // Copy input characters from any source into the logged variable.
    {
      if (yielding || logged) 
	{
	  usleep(10000);
	  continue;
	}

      if (arg)
	{
	  unsigned char ch;
	  // printf("Hang in xterm read\n");
	  int c = read(xterm_fd, &ch, 1); 
	  if (c) logged = ch | 256;
	}
      else
	{
	  unsigned char c = getchar();
	  //	  printf("hang in getchar >%c<\n", c);
	  // Set bit 8 as a non zero value that is not part of the character.
	  logged = c | 256;
	}
    }
}



// The input side is a bit promiscuous, reading from the xterm or stdin...
int cbguart::testch()
{
  //  if (!xconsole) return 0; // only support xconsole input ..!
  if (!xterm_opened) open_xterm();
  if (!threads_started)
    {
      threads_started = 1;
      if (use_stdin) pthread_create(&input_thread0, 0, input_caller0, (void *)this);
      if (xterm_fd >= 0) pthread_create(&input_thread1, 0, input_caller1, (void *)this);
      if (!use_stdin && xterm_fd < 0) printf("%s: Warning: No input devices\n", name());
    }
  if (!logged) 
    {
      idle_count += 1;
      if (idle_count == 1000)
	{
	  // Yield the processor if the input is idle, to save battery
	  // or be nice to other users.
	  yielding = 1;
	  usleep(100000);
	  yielding = 0;
	  idle_count = 0;
	}
    }
  return logged != 0;
}

char cbguart::rdch_nonblock()
{
  if (logged)
    {
      idle_count = 0;
      char r = logged & 0xFF;
      logged = 0;
      return r;
    }
  return 0;
}

// Read input character
char cbguart::rdch()
{
  while (1) if (testch()) return rdch_nonblock();
  return 0;
}

void cbguart::flush()
{
  if (output_f) fflush(output_f); else fflush(stdout);
}


void cbguart::open_xterm()
{
  xterm_opened = 1; // Set this first so that no second chance is attempted on fail.
  int fd = posix_openpt(/*"/dev/ptmx",*/ O_RDWR | O_NOCTTY);
  char ptsid[132], pts[132];
  if (fd < 0 || ptsname_r(fd, ptsid, 132))
    {
      perror("pt open failed");
    }
  UTRC(printf("pts %s fd=%i\n", ptsid, fd));
  sprintf(pts, "-Svt/%i", fd);
  unlockpt(fd);
  UTRC(printf("%s: Uart server is opening xterm\n", name()));
  char *args[5];
  args[0] = "/usr/bin/xterm";
  args[1] = pts;
  args[2] = "-title";
  args[3] = strdup(name());
  args[4] = 0;
  for (int i=0; args[i]; i++) printf("%s ", args[i]);
  printf("\n");
  if (!fork())
    {
      execv(args[0], args);
    }
  else
    {
      usleep(50000);
      int fd1 = open(ptsid, O_RDWR /* O_NONBLOCK*/);
      if (fd1 < 0)
	{
	  printf("%s: Failed to open %s\n", name(), ptsid);
	  perror("cannot open uart terminal");
	  exit(1);
	}
      xterm_fd = fd1;
    }
  if (threads_started) printf("%s: error: threads started too soon\n", name());
}


// Write output character
void cbguart::wrch(char c)
{
  if (xconsole)
    {
      if (!xterm_opened) open_xterm();
      if (xterm_fd >= 0) write(xterm_fd, &c, 1);
    }
  if (output_f) putc(c, output_f); else putchar(c);
}


// Return 0 on ok.
int cbguart::open_log_file(const char *fn)
{
  if (output_f) return -1;
  output_f = fopen(fn, "w");
  if (!output_f)
    {
      printf("%s: Could not open log file\n", name());
      perror("cbguart:");
      return -1;
    }
  return 0;
}


// constructor
cbguart::cbguart(sc_module_name name, bool x, bool u) : sc_module(name), xconsole(x), use_stdin(u)
{
  idle_count = 0;
  xterm_fd = -1;
  output_f = 0;
  input_f = 0;
  xterm_opened = 0;
  logged = 0;
  yielding = 0;
  threads_started = 0;
  latency = sc_time(100, SC_NS);
  port0.register_b_transport(this, &cbguart::b_access);
}


void cbguart::b_access(tlm::tlm_generic_payload &trans, sc_time &delay)
{
  tlm::tlm_command cmd = trans.get_command();
  uint32_t    adr = ((uint32_t)trans.get_address() & 0xfc);
  uint8_t*	ptr = trans.get_data_ptr();
  uint32_t    len = trans.get_data_length();
  uint8_t*	lanes = trans.get_byte_enable_ptr();
  uint32_t    wid = trans.get_streaming_width();
  
    
  // Obliged to check address range and check for unsupported features,
  //   i.e. byte enables, streaming, and bursts
  // Can ignore DMI hint and extensions
  // Using the SystemC report handler is an acceptable way of signalling an error
  
   
  if (len > 4 || wid < len) 
    {
      trans.set_response_status( tlm::TLM_BURST_ERROR_RESPONSE );
      return;
    }
  
  // Obliged to implement read and write commands
  if (cmd == tlm::TLM_READ_COMMAND)
      {
	uint8_t r = (adr == 0) ? testch(): rdch_nonblock(); // for now
	//	printf("Read from cbguart a=%x r=%x\n", adr, r);
	ptr[0] = 0;
	ptr[0] = 0;
	ptr[0] = 0;
	ptr[3] = r;
      }
    else if (cmd == tlm::TLM_WRITE_COMMAND)
      {
	if (!*lanes) printf("No lanes in write!\n");
	
	//	if (tracing_on) printf("Write to uart %s lanes=%x %x %02x%02x%02x%02x\n", name(), *lanes, adr, ptr[3], ptr[2], ptr[1], ptr[0]);       
	char r = ptr[3];
	//	printf("Uart transmit wrch trace %x\n", r);
	wrch(r);
      }


    delay += latency;

    // Illustrates that b_transport may block
    if (0)
      {
	wait(delay);
	delay = SC_ZERO_TIME; // Reset timing annotation after waiting
      }

    trans.set_response_status( tlm::TLM_OK_RESPONSE );
}

// eof
