#ifndef CBGRAM_H
#define CBGRAM_H

/* $Id: $
 *
 * cbgram : A TLM static ram with with ELF and Intel Hex load facility.
 * (C) 2009-10 DJ Greaves (TLM 2.0 Version Arturs Prieditis). 
 */

#include "systemc.h"
#include "tlm.h"
#include "tlm_utils/simple_target_socket.h"
#include "llsc_extension.h"

#define LLSC_ENABLE 2

SC_MODULE(cbgram)
{
#ifdef LLSC_ENABLE
  // Load locked, store conditional locations.
  llsc_locks_t llsc_locks;
#endif

  // Constructor
  cbgram(sc_module_name name, uint32_t mem_size, bool tracing_on, bool dmi_on=0);

  //TLM-2 socket, defaults to 32-bits wide, base protocol
  tlm_utils::simple_target_socket<cbgram> port0;
  
  // blocking transport
  virtual void b_access(tlm::tlm_generic_payload &trans, sc_time &delay);
  
  uint32_t mem_size;
  uint8_t *mem; // byte-addressed memory
  void loadme(const char *filename, bool elff, int *entrypt=0);
 private:
  const sc_time latency;
  bool tracing_on;
  bool dmi_on;  // Allow the direct memory access optimisation

  class cbgihex *iloader;
  class cbgelf *eloader;
};

#endif


