// $Id: $
// (C) 2008 DJ Greaves.
// cbg TLM/ESL console uart model: in popup xterm or using stdin/out depending on the console mode
//
#ifndef CBGUART_H
#define CBGUART_H

#include <stdio.h>
#include <stdio.h>
#include <string.h>
#include <fcntl.h>
#include <stdlib.h>
#include <unistd.h>
#include <pthread.h>

#include "systemc.h"
#include "tlm.h"
#include "tlm_utils/simple_target_socket.h"


SC_MODULE(cbguart)
{
  bool use_stdin;
  int xterm_opened, threads_started, idle_count;
  FILE *output_f, *input_f;
  int xterm_fd;
  bool xconsole;
  void open_xterm();
  volatile int logged, yielding;
  pthread_t input_thread0, input_thread1;
  sc_time latency;
public:

  // constructor
  cbguart(sc_module_name name, bool x, bool u);

  void *input_process(void *);
  int open_log_file(const char *fn);
  int testch();
  char rdch();
  char rdch_nonblock();
  void wrch(char);
  void flush();

  //TLM-2 socket, defaults to 32-bits wide, base protocol
  tlm_utils::simple_target_socket<cbguart> port0;
  
  // blocking transport
  virtual void b_access(tlm::tlm_generic_payload &trans, sc_time &delay);

};

#endif

// eof
