/* 
 * $Id: $
 *
 * cbgram : A TLM static ram with with ELF and Intel Hex load facility.
 * (C) 2009-10 DJ Greaves (TLM 2.0 Version Arturs Prieditis). 
 */

#define TRC(X) 



#include <fcntl.h>
#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <sys/mman.h>
#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>







class cbgelf 
{
public:
  unsigned char *reader(unsigned char * p, const char *fn, int lenmax, int *entrypt);
  void dump(char *p, int l);
  // constructor
  cbgelf()  {  }
};

/* Load Ram From Intelhex */
class cbgihex
{
  int a, csum, p, finished;
  FILE *fd;
  unsigned char opd[32];
  int iread(int len);
  void opfl();
  void opbyte(int x);

public:
  unsigned char *reader(unsigned char * p, const char *fn, int lenmax);
  void dump(char *p, int l);

  // constructor
  cbgihex();
};

#if 1
#define ELFTRC(X) X
#include <linux/elf.h>


  //
  // Load elf image to buffer based at p.
  // Return hwm.
  // 
unsigned char *cbgelf::reader(unsigned char *buf, const char *fn, int mem_size, int *entrypt)
{
  int hwm = 0, fd = open(fn, O_RDONLY);
  struct stat statbuf;
  if (fd < 0 || fstat(fd, &statbuf) < 0)
    {
      perror("");
      printf("cbgelf: load %s\n", fn);
      perror("cbgelf: cannot open input file");
      exit(1);
    }

  int offset = 0;

  const char *l = (const char*) mmap(0, statbuf.st_size, PROT_READ, MAP_SHARED, fd, 0);
  if (l == MAP_FAILED)
    {
      perror("");
      printf("cbgelf: load %s\n", fn);
      perror("cbgelf: cannot map input file");
      exit(1);
    }
  if (strncmp(l+1, "ELF", 3))
    {
      printf("cbgelf: load %s\n", fn);
      perror("cbgelf: input file is not ELF format");
      exit(1);
    }
  struct elf32_hdr *hdr = (struct elf32_hdr *) l;
  if (entrypt) 
    {
      *entrypt = hdr->e_entry - offset;
      ELFTRC(printf("Entry point %x\n", *entrypt));
    }

  bool sw = true;

  // These are the endian swap routines, needed when modelling the OR1K which is big endian on an x86 little endian workstation.
#define ES16(SW, X) ((SW)?(((X)>>8)&0xFF)|(((X)<<8)&0xFF00):(X))
#define ES32(SW, X) ((SW)?(((X)>>24)&0xFF)|(((X)>>8)&0xFF00)|(((X)<<8)&0xFF0000)|((X)<<24):(X))
  for (int i=0; i < ES16(sw, hdr->e_phnum); i++)
    {
      Elf32_Phdr *phdrs = (Elf32_Phdr *)(l + sizeof(elf32_hdr)); // bug was ehdr
      int foffset = ES32(sw, phdrs[i].p_offset);
      int size = ES32(sw, phdrs[i].p_filesz);
      ELFTRC(printf("Prog section %i: offset=%x foffset=%x va=%x size=%x\n", i, offset, foffset, ES32(sw, phdrs[i].p_vaddr), size));
      for (int d = 0; d<size; d++)
	{
	  int a_old = d + phdrs[i].p_vaddr - offset; // This line does not have an endian swap in it : possible BUG 8th March 2010 but how has it worked so far? People have not had initialised statics in segments that swap wrongly! 
	  int a = d + ES32(sw, phdrs[i].p_vaddr) - offset;
	  if (a < 0 || a >= mem_size)
	    {
	      printf("cbgelf: load address is outside of memory model %x\nYou may need the bug fix from the line above: ie dont use 'a_old'", a);
	      exit(1);
	    }
	  else 
	    {
	      unsigned char dd = l[foffset + d];
	      // printf("load RAM with byte RAM[%x]=%x\n", a, dd);
	      buf[a] = dd;
	    }
	  if (a>hwm) hwm=a;
	}
    }
  close(fd);
  return buf + hwm;
}
#endif
// END of elf load code

#if 1 

  // constructor
cbgihex::cbgihex()
{
  csum = 0; 
  a = 0; 
  finished = 0;
  p = 0;
};

int cbgihex::iread(int len)
{
  int r = 0;
  int i;
  for (i=0; i < len; i++)
  {
    char c = toupper(getc(fd));
    while (c == ' ') c = toupper(getc(fd));
    c = (c <= '9') ? c-'0': c-('0'+7);
    r = (r<<4) + c;
  }
  return r;
}

  //
  // Load intel hex file to buffer based at p.
  // Return ending p.
  // 
unsigned char *cbgihex::reader(unsigned char * p, const char *fn, int lenmax)
{
  int line = 1; 
  char bdata[256];
  fd = fopen(fn, "r");
  if (fd == 0) 
    {
      printf("cbgihex load %s\n", fn);
      perror("cbgihex: cant open input file");
      exit(1);
    }
  while (feof(fd)==0)
  {
    char c = getc(fd);
    int llen, laddr, ltype;
    char lsum;
    int wq;
    if (c == '\n') line++;
    if (c != ':') continue;
    llen = iread(2);
    laddr = iread(4);
    ltype = iread(2);

    lsum = llen + laddr + ltype + (laddr >> 8);

    for (wq=0; wq<llen; wq++)
    {
      char data = iread(2);
      lsum = lsum + data;
      bdata[wq] = data;
    }
    lsum += iread(2);
    if (lsum != 0) printf("Checksum error in line %i, residue %i\n", line, lsum);
    
    if (ltype == 1) finished = 1;
    else if (ltype == 2 && llen == 2) 
      {
	if (laddr) printf("ignored type2\n");
	if (bdata[0]) printf("ignored type2\n");
	if (bdata[1]) printf("ignored type2\n");
      }
    else if (ltype == 0)
      {
	int wq;
	if (a != -1 && laddr != a)
	  {
	    printf("Disjoint addresses %x and %x in line %i\n",
		   laddr, a, line);
	  }
	
	for (wq=0; wq<llen; wq++)
	  {
	    unsigned char data = bdata[wq];
	    csum += data;
	    if (p) *(p++) = data;
	    if (lenmax-- <= 0) assert(0); // Ran out of room.
	  }
	a = laddr + llen;
      }
    else
      {
	printf("Unknown type %i encountered in line %i\n", ltype, line);
	continue;
      }
  }
  fclose(fd);
  return p;
}


void cbgihex::dump(char *p, int l)
{
  while (l > 0)
    {
      opbyte(*p++);
      l -= 1;
    }
  opfl();
}


void cbgihex::opfl()
{
  unsigned char csum = 0; 
  int i;
  if (p == 0) return;
  printf(":%02X%04X00", p, a & 0xFFFF);

  csum += p + a + (a >> 8);
  for (i=0; i<p; i++) 
    {
      csum += opd[i];
      printf("%02X", opd[i]);
    }
  printf("%02X\n", (256-csum) & 0xFF);
  a+=p;
  p = 0;
}


void cbgihex::opbyte(int x)
{
  opd[p++] = x;
  if (p >= 32) opfl();
}

#endif


#include "cbgram.h"


// Constructor
cbgram::cbgram(sc_module_name name, uint32_t mem_size, bool tracing_on, bool dmi_on): sc_module(name), port0("port0"), latency(10, SC_NS), mem_size(mem_size), tracing_on(tracing_on), dmi_on(dmi_on) 
{
  mem = (uint8_t *)malloc(mem_size); // allocate memory


  // Register callback for incoming b_transport interface method call
  port0.register_b_transport(this, &cbgram::b_access);



}


void cbgram::loadme(const char *filename, bool elff, int *entrypt)
{
  if (elff)
    {
      eloader = new cbgelf();
      uint8_t *hwm = eloader->reader(mem, filename, mem_size, entrypt);
      //      printf("%s: loaded elf file %s: hwm=0x%x\n", name, filename, hwm-mem);
    }
  else 
    {
      iloader = new cbgihex();
      uint8_t *end = iloader->reader(mem, filename, mem_size);
      //      printf("%s: loaded ihex file %s: %i bytes\n", name, filename, end-mem);
    }
  
  // Little print out
  if (1)
    for(int i=0;i<4;i++)
      {
	int b = i*16 + 0x100;
	printf("%04X  ", b);
	for (int j=0;j<16;j++)
	  {
	    printf("%02X ", mem[b+j]);
	  }
	printf("\n");
      }
}


void cbgram::b_access(tlm::tlm_generic_payload &trans, sc_time &delay)
{
  tlm::tlm_command cmd = trans.get_command();
  uint32_t    adr = ((uint32_t)trans.get_address() & 0x1Ffffffc);
  uint8_t*	ptr = trans.get_data_ptr();
  uint32_t    len = trans.get_data_length();
  uint8_t*	lanes = trans.get_byte_enable_ptr();
  uint32_t    wid = trans.get_streaming_width();

  delay += latency;
    
  // Obliged to check address range and check for unsupported features,
  //   i.e. byte enables, streaming, and bursts
  // Can ignore DMI hint and extensions
  // Using the SystemC report handler is an acceptable way of signalling an error
  
  if (adr >= mem_size)
      {
	printf("Ram address out of range %x cf %x\n", adr, mem_size);
	trans.set_response_status( tlm::TLM_ADDRESS_ERROR_RESPONSE );
	return;
      }

   
  if (len > 4 || wid < len) 
      {
	trans.set_response_status( tlm::TLM_BURST_ERROR_RESPONSE );
	return;
      }

  llsc_extension * ext;
  trans.get_extension(ext);


  // Obliged to implement read and write commands
  if (cmd == tlm::TLM_READ_COMMAND)
    {

#ifdef LLSC_ENABLE
      if (ext && (!(adr & 3)) && ext->loadlocked_fail(&llsc_locks, adr))
	{
	  // NOT CORRECT!
	  printf("%s, Ram load conditional read missed at %x\n", name(), adr);
	  trans.set_response_status( tlm::TLM_ADDRESS_ERROR_RESPONSE );
	  return;
	}
#endif

      ptr[0] = mem[adr+3];
      ptr[1] = mem[adr+2];
      ptr[2] = mem[adr+1];
      ptr[3] = mem[adr];
      if (tracing_on) printf("Read from cbgram %s %x %02x%02x%02x%02x\n", name(), adr, ptr[3], ptr[2], ptr[1], ptr[0]);  
    }
  else if (cmd == tlm::TLM_WRITE_COMMAND)
    {
      if (!*lanes)
	{
	  printf("No lanes in write!\n");
	  trans.set_response_status( tlm::TLM_ADDRESS_ERROR_RESPONSE );
	  return;
	}

#ifdef LLSC_ENABLE
      if (ext)
	{
	  if (adr & 3) printf("Store conditional unaligned %x\n", adr);
	  if (ext->storeconditional_fail(&llsc_locks, adr))
	    {
	      printf("%s, Ram store conditional write missed at %x\n", name(), adr);
	      trans.set_response_status( tlm::TLM_ADDRESS_ERROR_RESPONSE );
	      return;
	    }	
	}
#endif
      if (tracing_on) printf("Write to cbgram %s lanes=%x %x %02x%02x%02x%02x\n", name(), *lanes, adr, ptr[3], ptr[2], ptr[1], ptr[0]);       
      if (*lanes & 8)	mem[adr] = ptr[3]; 
      if (*lanes & 4)	mem[adr+1] = ptr[2];
      if (*lanes & 2)	mem[adr+2] = ptr[1];
      if (*lanes & 1)	mem[adr+3] = ptr[0];
      //	if (*lanes != 15) printf("Updated memory %i %x now %x %x %x %x\n", lanes, adr, 
      
      
      }

    // Illustrates that b_transport may block
    if (0)
      {
	wait(delay);
	delay = SC_ZERO_TIME; // Reset timing annotation after waiting
      }

    if (dmi_on)
      {
	// Set DMI hint to indicated that DMI is supported or not
	trans.set_dmi_allowed(dmi_on);
      }
    // Obliged to set response status to indicate successful completion
    trans.set_response_status( tlm::TLM_OK_RESPONSE );
}







/* End of cbgihex.c */

