#############################################################
# vim:set shiftwidth=2 softtabstop=2 expandtab:
#
# $Id: SimpleType.pm 5022 2009-02-20 20:01:06Z grg $
#
#############################################################

####################################################################################
# SimpleType
####################################################################################
package NF2::RegSystem::SimpleType;

use NF2::RegSystem::Type;

use vars qw(@ISA);
@ISA = qw(NF2::RegSystem::Type);

use Carp;
use strict;
our $AUTOLOAD;

my %fields = (
  width     => undef,
  bitmasks  => undef,
);
my %permitted = %fields;
my $initialized = 0;

#
# Create a new type
#
# Params:
#   name
#   desc
#
sub new {
  my ($class, $name, $desc) = @_;

  my $self  = $class->SUPER::new($name, $desc);

  # Initialize the class if necessary
  if (!$initialized) {
    my %superPermitted = %{$self->{_permitted}};
    @{\%permitted}{keys %superPermitted} = values %superPermitted;
    $initialized = 1;
  }

  $self->{_permitted} = \%permitted;
  @{$self}{keys %fields} = values %fields;

  bless $self, $class;

  return $self;
}


1;

__END__
