#!/usr/bin/perl
# Author: Stanford CS344 TA
# Date: 3/31/08

# Objective:
# Ensure that packets sent in port 0 are forwarded out port 1
# and that packets sent in port 1 are dropped

use NF2::RegressLib;
use NF2::PacketLib;
use strict;

# Set some initial values
my $eth1 = '00:01:02:03:04:05';
my $eth2 = '00:11:22:33:44:55';
my $ip1 = '192.168.0.1';
my $ip2 = '192.168.1.1';

my $exitCode = 0;

# launch PCAP listenting to eth1, eth2
my @interfaces = ( "eth1", "eth2" );
nftest_init( \@ARGV, \@interfaces );
nftest_start( \@interfaces );

# create mac header
my $ippkt = new NF2::IP_pkt(
	DA => $eth1,
	SA => $eth2,
	src_ip => $ip1,
	dst_ip => $ip2,
	ttl => 64
);

# Send in the packet from port 0 and expect to see it on port 1
nftest_send('eth1', $ippkt->packed());
nftest_expect('eth2', $ippkt->packed());

# Modify the packet
$ippkt->set(
	DA => $eth2,
	SA => $eth1,
	src_ip => $ip2,
	dst_ip => $ip1,
);

# Send in the packet from port 1 but don't expect to see it on port 0
nftest_send('eth2', $ippkt->packed());

sleep 2;

# Finish and print errors, if any
my $total_errors = nftest_print_errors(nftest_finish());

if ( $total_errors == 0 ) {
	print "SUCCESS!\n";
	$exitCode = 0;
}
else {
	print "FAIL: $total_errors errors\n";
	$exitCode = 1;
}

exit $exitCode;
