#############################################################
#
# Perl register defines file for CPCI_2.1
#
#############################################################

package reg_defines_CPCI_2.1;

use Exporter;

@ISA = ('Exporter');

@EXPORT = qw(
                MAX_PHY_PORTS
                PCI_ADDR_WIDTH
                PCI_DATA_WIDTH
                PCI_BE_WIDTH
                CPCI_CNET_ADDR_WIDTH
                CPCI_CNET_DATA_WIDTH
                CPCI_NF2_ADDR_WIDTH
                CPCI_NF2_DATA_WIDTH
                DMA_DATA_WIDTH
                DMA_CTRL_WIDTH
                CPCI_DEBUG_DATA_WIDTH
                SRAM_ADDR_WIDTH
                SRAM_DATA_WIDTH
                DRAM_ADDR_WIDTH
                FAST_CLK_PERIOD
                SLOW_CLK_PERIOD
                IO_QUEUE_STAGE_NUM
                DATA_WIDTH
                CTRL_WIDTH
                CPCI_VERSION_ID
                CPCI_REVISION_ID
                CPCI_DMA_XFER_TIME_DEFAULT
                CPCI_DMA_RETRIES_DEFAULT
                CPCI_CNET_READ_TIME_DEFAULT
                CPCI_P_MAX_DEFAULT
                CPCI_N_EXP_DEFAULT
                CPCI_BASE_ADDR
                CPCI_ID_REG
                CPCI_BOARD_ID_REG
                CPCI_CTRL_REG
                CPCI_RESET_REG
                CPCI_ERROR_REG
                CPCI_DUMMY_REG
                CPCI_INTERRUPT_MASK_REG
                CPCI_INTERRUPT_STATUS_REG
                CPCI_CNET_CLK_SEL_REG
                CPCI_REPROG_DATA_REG
                CPCI_REPROG_STATUS_REG
                CPCI_REPROG_CTRL_REG
                CPCI_DMA_ADDR_I_REG
                CPCI_DMA_ADDR_E_REG
                CPCI_DMA_SIZE_I_REG
                CPCI_DMA_SIZE_E_REG
                CPCI_DMA_CTRL_I_REG
                CPCI_DMA_CTRL_E_REG
                CPCI_DMA_XFER_TIME_REG
                CPCI_DMA_RETRIES_REG
                CPCI_CNET_READ_TIME_REG
                CPCI_DMA_INGRESS_PKT_CNT_REG
                CPCI_DMA_EGRESS_PKT_CNT_REG
                CPCI_CPCI_REG_READ_CNT_REG
                CPCI_CPCI_REG_WRITE_CNT_REG
                CPCI_CNET_REG_READ_CNT_REG
                CPCI_CNET_REG_WRITE_CNT_REG
                CPCI_CLOCK_CHECK_N_CLK_REG
                CPCI_CLOCK_CHECK_P_MAX_REG
                CPCI_CLOCK_CHECK_N_EXP_REG
                CPCI_PCI_CLK_CNT_REG
                CPCI_CPCI_RESET_CNT_REG
            );


# -------------------------------------
#   Constants
# -------------------------------------

# ===== File: lib/verilog/core/common/xml/global.xml =====

# Maximum number of phy ports
sub MAX_PHY_PORTS ()                { 4;}

# PCI address bus width
sub PCI_ADDR_WIDTH ()               { 32;}

# PCI data bus width
sub PCI_DATA_WIDTH ()               { 32;}

# PCI byte enable bus width
sub PCI_BE_WIDTH ()                 { 4;}

# CPCI--CNET address bus width. This is byte addresses even though bottom bits are zero.
sub CPCI_CNET_ADDR_WIDTH ()         { 27;}

# CPCI--CNET data bus width
sub CPCI_CNET_DATA_WIDTH ()         { 32;}

# CPCI--NF2 address bus width. This is byte addresses even though bottom bits are zero.
sub CPCI_NF2_ADDR_WIDTH ()          { 27;}

# CPCI--NF2 data bus width
sub CPCI_NF2_DATA_WIDTH ()          { 32;}

# DMA data bus width
sub DMA_DATA_WIDTH ()               { 32;}

# DMA control bus width
sub DMA_CTRL_WIDTH ()               { 4;}

# CPCI debug bus width
sub CPCI_DEBUG_DATA_WIDTH ()        { 29;}

# SRAM address width
sub SRAM_ADDR_WIDTH ()              { 19;}

# SRAM data width
sub SRAM_DATA_WIDTH ()              { 36;}

# DRAM address width
sub DRAM_ADDR_WIDTH ()              { 24;}


# ===== File: lib/verilog/core/common/xml/nf_defines.xml =====

# Clock period of 125 MHz clock in ns
sub FAST_CLK_PERIOD ()              { 8;}

# Clock period of 62.5 MHz clock in ns
sub SLOW_CLK_PERIOD ()              { 16;}

# Header value used by the IO queues
sub IO_QUEUE_STAGE_NUM ()            { 0xff;}

# Data path data width
sub DATA_WIDTH ()                   { 64;}

# Data path control width
sub CTRL_WIDTH ()                   { 8;}


# ===== File: projects/CPCI_2.1/include/cpci_regs.xml =====

# CPCI version number (major number)
sub CPCI_VERSION_ID ()               { 0x000003;}

# CPCI revision number (minor number)
sub CPCI_REVISION_ID ()              { 0x04;}

# Default maximum time for DMA transfers (in clock cycles)
sub CPCI_DMA_XFER_TIME_DEFAULT ()   { 30000;}

# Default maximum number of retries for DMA transactions
sub CPCI_DMA_RETRIES_DEFAULT ()      { 0xffff;}

# Default maximum Virtex register read time
sub CPCI_CNET_READ_TIME_DEFAULT ()  { 4000;}

# Number of PCI cycles in an interation
sub CPCI_P_MAX_DEFAULT ()           { 3333333;}

# Expected number of CPCI-Virtex clocks in the PCI period defined above
sub CPCI_N_EXP_DEFAULT ()           { 6250000;}



## -------------------------------------
##   Modules
## -------------------------------------

# Module tags
sub CPCI_BASE_ADDR ()   { 0x0000000; }



# -------------------------------------
#   Registers
# -------------------------------------

# Name: cpci (CPCI)
# Description: CPCI registers
# File: projects/CPCI_2.1/include/cpci_regs.xml
sub CPCI_ID_REG ()                    { 0x0000000;}
sub CPCI_BOARD_ID_REG ()              { 0x0000004;}
sub CPCI_CTRL_REG ()                  { 0x0000008;}
sub CPCI_RESET_REG ()                 { 0x000000c;}
sub CPCI_ERROR_REG ()                 { 0x0000010;}
sub CPCI_DUMMY_REG ()                 { 0x0000020;}
sub CPCI_INTERRUPT_MASK_REG ()        { 0x0000040;}
sub CPCI_INTERRUPT_STATUS_REG ()      { 0x0000044;}
sub CPCI_CNET_CLK_SEL_REG ()          { 0x0000050;}
sub CPCI_REPROG_DATA_REG ()           { 0x0000100;}
sub CPCI_REPROG_STATUS_REG ()         { 0x0000104;}
sub CPCI_REPROG_CTRL_REG ()           { 0x0000108;}
sub CPCI_DMA_ADDR_I_REG ()            { 0x0000140;}
sub CPCI_DMA_ADDR_E_REG ()            { 0x0000144;}
sub CPCI_DMA_SIZE_I_REG ()            { 0x0000148;}
sub CPCI_DMA_SIZE_E_REG ()            { 0x000014c;}
sub CPCI_DMA_CTRL_I_REG ()            { 0x0000150;}
sub CPCI_DMA_CTRL_E_REG ()            { 0x0000154;}
sub CPCI_DMA_XFER_TIME_REG ()         { 0x0000180;}
sub CPCI_DMA_RETRIES_REG ()           { 0x0000184;}
sub CPCI_CNET_READ_TIME_REG ()        { 0x0000188;}
sub CPCI_DMA_INGRESS_PKT_CNT_REG ()   { 0x0000400;}
sub CPCI_DMA_EGRESS_PKT_CNT_REG ()    { 0x0000404;}
sub CPCI_CPCI_REG_READ_CNT_REG ()     { 0x0000408;}
sub CPCI_CPCI_REG_WRITE_CNT_REG ()    { 0x000040c;}
sub CPCI_CNET_REG_READ_CNT_REG ()     { 0x0000410;}
sub CPCI_CNET_REG_WRITE_CNT_REG ()    { 0x0000414;}
sub CPCI_CLOCK_CHECK_N_CLK_REG ()     { 0x0000500;}
sub CPCI_CLOCK_CHECK_P_MAX_REG ()     { 0x0000504;}
sub CPCI_CLOCK_CHECK_N_EXP_REG ()     { 0x0000508;}
sub CPCI_PCI_CLK_CNT_REG ()           { 0x0000510;}
sub CPCI_CPCI_RESET_CNT_REG ()        { 0x0000520;}





1;

__END__
