use ["flatlib.sml"];
(*
use ["lib/Overloadings"];

use ["lib/Integer.sig","lib/Real.sig","lib/String.sig","lib/Bool.sig",
     "lib/List.sig","lib/Ref.sig","lib/Array.sig","lib/ByteArray.sig",
     "lib/BasicIO.sig","lib/Pfl.sig"];

use ["lib/Integer.str","lib/Real.str","lib/String.str","lib/Bool.str",
     "lib/List.str","lib/Ref.str","lib/Array.str","lib/ByteArray.str",
     "lib/BasicIO.str","lib/Pfl.str","lib/Output.str"];

structure Pervasives =
  struct
    structure Integer   = Integer
          and Real      = Real
          and String    = String
          and Bool      = Bool
          and List      = List
          and Ref       = Ref
          and Dynamic   = Dynamic
          and Array     = Array
          and ByteArray = ByteArray
          and BasicIO   = BasicIO
          and Pfl       = Pfl
          and Output    = Output;

    datatype 'a option = NONE | SOME of 'a

    infix before
    fun a before b = a

    infix 3 o 76 2; fun (x:('b -> 'c)) o (y:('a -> 'b)):('a -> 'c) = x o y
  end;

structure Extensions =
  struct
    val TheAssembler = TheAssembler;
    val BCAssembleText = BCAssembleText;
    val NCAssembleText = NCAssembleText;
    val TextSize = TextSize;
    val use = use;
    val usestring = usestring;
    val ExportML = ExportML;
    val ExportFunction = ExportFunction;
    val CurrentState = CurrentState;
    val Debug = Debug;
    val Print = Print;
    val ML = ML;

    exception TimeStampOf = TimeStampOf;
    datatype Stamped = 
      File of string | Now;
    datatype TimeStamp = TimeStamp of {HostId: int, ProcessId: int, Time: int};

    local fun TimeStampOf Now = GetUniqueStamp()
	    | TimeStampOf (File s) = StampOfFile s
    
     in val TimeStampOf: Stamped -> TimeStamp = forgettype TimeStampOf end;

    val CpuTime = CpuTime;
    val collect = collect;
    nonfix getenv 229 1;
    fun getenv(s:string):string = getenv s;
    val system = system
  end;
*)
