(*
 * The picture-drawing constructors available are
 *
 *   circle : real -> picture              give radius
 *   square : real -> picture              give side. Square is positioned
 *                                         relative to its centre
 *   scale  : real*picture -> picture      enlarge or shrink
 *   scalex : real*picture -> picture      scale in X direction only
 *   rotate : real*picture -> picture      clockwise, in degrees
 *   shift  : real*real*picture -> picture translate
 *   paint  : colour*picture -> picture
 *   rgb    : int*int*int -> colour        use values 0-255 for R, G, B
 *
 * Pictures are objects that display graphically on a square area that has
 * its origin centrally positioned, and that runs from roughly -2.0 to
 * 2.0 in both directions.  Thus "circle 2.0" will be a circle that
 * almost fills the screen.
 *)

val colours = [black, red, green, blue, yellow, cyan, magenta, white];

fun spider(n, k::k') =
  if n = 0 then circle 0.0
  else add(paint(k, circle(real n / 3.0)),
           spider(n-1, k'));

val web = spider(6, colours);

add(shift(~0.5, 0.0, web), shift(0.5, 0.0, web));

