(*
 *   Useful Functions that will make an appearence at top level
 *             (the "Edinburgh" SML library)
 *  1: operations on lists
 *  2: list creators 
 *  3: stream operations
 *)

native(prefix "native_");  (* where will this go ? *)
 
local
    fun native_filter p l = 
    let
	fun native_filter'(l) = if null l then [] else
	    let 
		val (a::x) = l
	    in
		if p a then a::native_filter'(x) else native_filter'(x)
	    end
    in
	native_filter'(l)
    end;
in
    val filter = native_filter
end;

(*************************************************************
 * list operations 
 *)

infix --;

fun x -- y = 
let
    fun native_f' (x,y,z) = if x = y then x::z
    else native_f'(x,y-1,y::z)
in    
   if x<=y then native_f' (x,y,[]) else []
end;



(* Gordons Rand fun *)

local
	fun MakeRandom (seed: int) =
	  let
	    val seed' = ref seed
	    fun Random () =
	     (seed' := (32501 * !seed' + 6923) mod 32768;
	      !seed')
	  in
	    Random
	  end
	
	val Random = MakeRandom 17;
	fun makeTest (n, sofar) =
	  if n=0 then sofar else makeTest (n-1, Random() :: sofar);
in
  fun rand x = makeTest(x,[])
end;

(* how about a lazy rand stream ? *)
