/**********************************************************
 *  This work by Richard Leivers (rjl67@cam.ac.uk)        * 
 *  is licenced under the Creative Commons                *
 *  Attribution-Non-Commercial-Share Alike 2.0 UK:        *
 *  England & Wales License.                              *
 *                                                        *
 *  To view a copy of this licence, visit                 *
 *  http://creativecommons.org/licenses/by-nc-sa/2.0/uk/  *
 *  or send a letter to Creative Commons,                 *
 *  171 Second Street, Suite 300, San Francisco,          *
 *  California 94105, USA.                                *
 *                                                        *
 **********************************************************	
 *	Manchester Baby simulator in Java  	*
 * 	Richard Leivers - July 2009        	*
 * 										*
 *	RENDER MODULE						*
 ****************************************/

import java.awt.*;
import javax.swing.*;

class DisplayPanel extends JPanel {
	
	Memory mem;
	
	// Store a reference to the memory
	public DisplayPanel (Memory mem) {
		this.mem = mem;
	}
	
	public void paintComponent (Graphics g) {
		
		// Colour background black
		g.setColor(Color.black);
		g.fillRect(0,0,800,600);
		
		g.setFont (new Font("Courier", Font.PLAIN, 15));
		
		// Loop through memory lines
		for (int i = 0; i < 32; i++) {
			
			// String may need padding with zeros
			String line = Integer.toBinaryString(mem.getMemLine(i));
			while (line.length() < 32) line = "0"+line;
			
			String lineLabel = Integer.toHexString(i).toUpperCase();
			if (lineLabel.length()== 1) lineLabel = "0"+lineLabel;
			g.setColor(Color.white);
			g.drawString (lineLabel, 16, (i*16)+28);

			String dataLabel = Integer.toString(mem.getMemLine(i), 16).toUpperCase();
			if (line.charAt(0) == '1') {
				g.drawString ("-", 570, (i*16)+28);
				dataLabel = dataLabel.substring(1);
			}
			while (dataLabel.length()!= 8) dataLabel = "0"+dataLabel;
			g.drawString (dataLabel, 585, (i*16)+28);
			
			// Loop within memory line
			for (int j = 31; j >= 0; j--) {
				
				// If bit is high, create bright green 'on' blob
				if (line.charAt(j) == '1') {
					g.setColor(Color.green);
					g.fillOval(((31-j)*16)+48, (i*16)+16+3, 14, 10);
				}
				// Otherwise a dull little 'off' blob
				else {
					g.setColor(new Color(0,100,0));
					g.fillOval(((31-j)*16)+48, (i*16)+16+5, 14, 6);
				}
			}
		}			
	}
}	

