#include <stdlib.h>
#include <jni.h>
 
#define USER_CLASSPATH "." 
 
int main(int argc, char *argv[])
{
	JNIEnv *env;
	JavaVM *jvm;
	jint res;
	jclass cls;
	jmethodID mid;
	jstring jstr;
	jobjectArray args;
 
	JavaVMInitArgs vm_args;
	JavaVMOption options[4];
 
	options[0].optionString = "-Djava.compiler=NONE";	/* disable JIT */
	options[1].optionString = "-Djava.class.path=.";	/* user classes */
	options[2].optionString = "-Djava.library.path=.";	/* set native library path */
	options[3].optionString = "-verbose:jni";		/* print JNI-related messages */
 
	vm_args.version = JNI_VERSION_1_4;
	
	vm_args.options = options;
	vm_args.nOptions = 4;
	vm_args.ignoreUnrecognized = 1;
 
	/* Note that in the Java 2 SDK, there is no longer any need to call 
	* JNI_GetDefaultJavaVMInitArgs. 
	*/
	res = JNI_CreateJavaVM(&jvm, (void **)&env, &vm_args);
	
	if (res < 0) {
		fprintf(stderr, "Can't create Java VM\n");
		exit(1);
	}
 
	cls = (*env)->FindClass(env, "JVMinCTest");
	if (cls == 0) {
		fprintf(stderr, "Can't find JVMinCTest class\n");
		exit(1);
	}
 
	mid = (*env)->GetStaticMethodID(env, cls, "main", "([Ljava/lang/String;)V");
	if (mid == 0) {
		fprintf(stderr, "Can't find main method in class\n");
		exit(1);
	}
 
	jstr = (*env)->NewStringUTF(env, " from C!");
	if (jstr == 0) {
		fprintf(stderr, "Out of memory\n");
		exit(1);
	}
	args = (*env)->NewObjectArray(env, 1, (*env)->FindClass(env, "java/lang/String"), jstr);
	if (args == 0) {
		fprintf(stderr, "Out of memory\n");
		exit(1);
	}
	(*env)->CallStaticVoidMethod(env, cls, mid, args);
 
	(*jvm)->DestroyJavaVM(jvm);
 
	return 0;
}
