package uk.ac.cam.cl.rkh23.blobtracker;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.Vector;

import javax.media.Buffer;
import javax.media.CaptureDeviceInfo;
import javax.media.CaptureDeviceManager;
import javax.media.Format;
import javax.media.Manager;
import javax.media.MediaLocator;
import javax.media.Player;
import javax.media.control.FormatControl;
import javax.media.control.FrameGrabbingControl;
import javax.media.format.VideoFormat;
import javax.media.util.BufferToImage;

public class JMFFrameSource implements FrameInterface {
	
	// I obtained this information from JMF Registry.  You may need 
	// to change it if you want to use your own webcam
	private static final String CAPTURE_DEVICE = "vfw:Microsoft WDM Image Capture (Win32):0";

	/**
	 * This is a Player object from the Java Media Framework.  We
	 * need it to access the data stream
	 */
	private Player mPlayer=null;
	
	/**
	 * This control allows us to get individual frames from the webcam
	 */
	private FrameGrabbingControl mFrameGrabber;
	
	/**
	 * The width of a frame in pixels
	 */
	private int mWidth;
	
	/**
	 * The height of a frame in pixels;
	 */
	private int mHeight;
	
	/**
	 * Constructor sets up the frame grabber for the webcam used
	 * in the lectures
	 */
	public JMFFrameSource(int w, int h) {
		mWidth = w;
		mHeight = h;
		open(CAPTURE_DEVICE);
	}
		
	public void open(String descriptor) {
		
		int formatid=0;
		if (mWidth==640 && mHeight==480) formatid=0;
		else if (mWidth==320 && mHeight==240) formatid=3;
		else if (mWidth==160 && mHeight==120) formatid=1;
		
	    try {
	    	Format f[]=null;
	    	 MediaLocator ml=null;	
	    	
	    	Vector devices = CaptureDeviceManager.getDeviceList(null);

	 	    if (devices == null || devices.size() == 0) {
	 	      System.out.println("Sorry - there are no valid capture devices.");
	 	      System.exit(0);
	 	    }

	 	    for (int i = 0; i < devices.size(); i++) {
	 	      CaptureDeviceInfo devInfo = (CaptureDeviceInfo) devices.elementAt(i);
	 	      String devName = devInfo.getName();
	 	      if (devName.equals(CAPTURE_DEVICE)) {  
	 	        System.out.println("Found capture device: " + CAPTURE_DEVICE);
	 	        f = devInfo.getFormats();
	 	        ml=devInfo.getLocator();   // this method may not work
	 	      }
	 	    }
	    	
	    
		  mPlayer = Manager.createRealizedPlayer(ml);
		  FormatControl fc = (FormatControl)mPlayer.getControl("javax.media.control.FormatControl");
		  fc.setFormat(f[formatid]);
	    }
	    catch (Exception e) {
	      System.out.println("Failed to create player - can't continue!");
	      System.exit(0);
	    }

	    // create the frame grabber
	    mFrameGrabber =  (FrameGrabbingControl) mPlayer.getControl(
	                            "javax.media.control.FrameGrabbingControl");
	    if (mFrameGrabber == null) {
	      System.out.println("Frame grabber could not be created");
	      System.exit(0);
	    }

	    System.out.println("Starting the player...");
	    mPlayer.start();
	}
	
	

	/**
	 * Shut down the Player object
	 */
	public void close() {
		mPlayer.stop();
		mPlayer.close();
	}


	@Override
	public BufferedImage getNextFrame() {
		
		if (mFrameGrabber==null) return null;

		Buffer buf = mFrameGrabber.grabFrame(); 
		
		if (buf==null) {
	      System.out.println("No grabbed frame");
	      try {
			Thread.sleep(100);
	      } catch (InterruptedException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
	      }
	    }
		
		// There is a buffer, but check if it's empty or not
		VideoFormat videoFormat = (VideoFormat) buf.getFormat();
	    if (videoFormat == null) {
	      return null;
	    }

	    
	    // initialize bufferToImage with the video format info.
	    BufferToImage bti= new BufferToImage(videoFormat);

	    BufferedImage im = (BufferedImage)(bti.createImage(buf));
	    if (im == null) {
	      System.out.println("No grabbed image");
	      return null;
	    }
	    return im;
	}
	
	
	
	
}
