package uk.ac.cam.cl.rkh23.blobtracker;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.util.List;

import javax.swing.JPanel;

public class DisplayPanel extends JPanel {

	/**
	 * Serial ID
	 */
	private static final long serialVersionUID = 1L;
	
	/**
	 * List of regions to highlight in red
	 */
	private List< Region > mHighlightRegions = null;
	
	private List<Pixel> mHighlightPixels = null;

	/**
	 * The image to draw to the screen and highlight
	 */
	private Image mImage = null;
	
	
	/**
	 * Set a new image and update the screen
	 * @param i
	 */
	public void setImage(Image i) {
		mImage=i;
	}
	
	/**
	 * Set the Regions to highlight
	 * @param regions
	 */
	public void setHighlightRegions(List< Region > regions) {
		mHighlightRegions = regions;
	}
	
	/**
	 * Set the Regions to highlight
	 * @param regions
	 */
	public void setHighlightPixels(List< Pixel > pixels) {
		mHighlightPixels = pixels;
	}
	
	
	/**
	 * Swing calls this method after it has drawn what it needs to.
	 * We use it to add the image we want on top
	 */
	public void paintComponent(Graphics g) {
		Graphics2D g2 = (Graphics2D)g;
		g2.setColor(Color.white);
		g2.fill(getVisibleRect());
		if (mImage!=null) g2.drawImage(mImage,0,0,null);
		
		
		if (mHighlightPixels!=null) {
			for (Pixel p : mHighlightPixels) {
				// Select a different colour
				g2.setColor(Color.red);
				g2.drawLine(p.getX(), p.getY(), p.getX(), p.getY());
			}
		}
		
		if (mHighlightRegions!=null) {
			for (List<Pixel> rpix : mHighlightRegions) {
				// Select a different colour
				g2.setColor(Color.green);
				// Paint each pixel
				for (Pixel p : rpix) {
					g2.drawLine(p.getX(), p.getY(), p.getX(), p.getY());
				}	
			}
		}
		
		
	}

}
