package uk.ac.cam.cl.rkh23.photo.view;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

import javax.swing.DefaultListModel;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

import uk.ac.cam.cl.rkh23.photo.ModelControllerInterface;

/**
 * This class is registered with the view components
 * to handle all of their input events
 * @author rkh23
 *
 */
public class PhotoOrganiserController implements ActionListener, ListSelectionListener, MouseListener {
	
	/**
	 * Useful to link to our view.  Doing this couples the
	 * view and the controller, but that's almost always
	 * what happens anyway...
	 */
	private PhotoOrganiserView mView;
	
	
	/**
	 * Simple constructor
	 * @param v associates the view
	 */
	public PhotoOrganiserController(PhotoOrganiserView v) {
		mView = v;
	}

	
	/**
	 * actionPerformed is the function that gets called 
	 * by the GUI when something happens.  It is specified in
	 * the ActionListener interface
	 * 
	 */
	@Override
	public void actionPerformed(ActionEvent e) {
		
		// Retrieve the command we associated with 
		// whatever event occurred
		String cmd = e.getActionCommand();
		
		// We also need to talk to the model
		ModelControllerInterface model = mView.getModel();
		
		// Note we use .equals() and not ==
		// for comparison of Strings. Make sure
		// you understand why!
		
		
		// Adding a photo
		if (cmd.equals("ADDPHOTO")) {
			// Use a standard dialog to select the file
			final JFileChooser fc = new JFileChooser();
			int returnval = fc.showDialog(mView,"Select");
			if (returnval==JFileChooser.APPROVE_OPTION) {
				model.addPhoto(
						fc.getSelectedFile().getAbsolutePath(),
						mView.getCurrentAlbum()
				);
			}
			
		}
		
		
		// Deleting a photo
		else if (cmd.equals("DELPHOTO")) {
			if (mView.getSelectedPhoto()!=null) {
				model.deletePhoto(mView.getSelectedPhoto(),mView.getCurrentAlbum());
				mView.selectPhoto(null);
			}
			else JOptionPane.showMessageDialog(mView,
				    "No photo has been selected!",
				    "Whoops",
				    JOptionPane.ERROR_MESSAGE);
		}
		
		
		// Adding an album
		else if (cmd.equals("ADDALBUM")) {
			String name = (String)JOptionPane.showInputDialog(
                    "Please name the new album");
			model.createAlbum(name);

		}
		
		// Deleting an album
		else if (cmd.equals("DELALBUM")) {
			String currentAlbum = mView.getCurrentAlbum();
			if (currentAlbum!=null) {
				mView.displayAlbum(null);
				model.deleteAlbum(currentAlbum);
			}
			else JOptionPane.showMessageDialog(mView,
				    "None of the albums have been selected!",
				    "Whoops",
				    JOptionPane.ERROR_MESSAGE);

		}
		
		// Error!
		else {
			// ignore
		
		}
	}


	/**
	 * This function is called whenever the user selects 
	 * something in the album JList
	 */
	@Override
	public void valueChanged(ListSelectionEvent e) {
		if (e.getValueIsAdjusting()) return;
		// Tell the view that an album has been selected
		JList source = (JList)e.getSource();
		int last = source.getSelectedIndex();
		String album = (String) (((DefaultListModel)source.getModel()).getElementAt(last));
		mView.selectPhoto(null);
		mView.displayAlbum(album);
	}

	//==========================================
	// The methods below come from MouseListener
	// We use them to catch clicks on objects
	// So we only implement one of them
	//==========================================
	
	@Override
	public void mouseClicked(MouseEvent e) {
		if (e.getSource() instanceof PhotoTile) {
			// We have selected a thumbnail
			PhotoTile pt = (PhotoTile) e.getSource();
			mView.selectPhoto(pt.getPhoto());
		}
	}
	@Override
	public void mouseEntered(MouseEvent e) {}
	@Override
	public void mouseExited(MouseEvent e) {}
	@Override
	public void mousePressed(MouseEvent e) {}
	@Override
	public void mouseReleased(MouseEvent e) {}
	

}
