(*$Header: /a/rathlin/disk/src/master/edml/EDML4/EdinburghML/UPTODATE/RCS/sun3nc.sml,v 2.1 91/09/06 14:21:56 edml Exp $
 *$Log:	sun3nc.sml,v $
Revision 2.1  91/09/06  14:21:56  edml
Incremental Garbage Collector/Sun3 Native code
build sml.exp head from phase2.exp

Revision 2.0  91/06/09  17:10:36  ajg
*** empty log message ***

Revision 1.9  91/04/22  22:48:16  ajg
2nd term

*)

(*************************************)
(*				     *)
(*  680x0 Functions and definitions  *)
(*				     *)
(*************************************)

local (* all 68k native code goes inside this *)

(**********************************************************************)
(*
 *  The following is part of every M/C def
 *
 *)

datatype 'a Bounding = (* the entry and exit notation *)
    SK 
  | D0 
  | A0 
  | ANY of 'a;    (* SK' | DO' (* boxed variations *) *)

val Default_Bound = SK; (* to be SK *)
    
type LAB = string;  (* the type for labels *)

local
  val tmp_label = ref 0
in
  fun ResetNCLabels () = tmp_label := 0;
  fun makeNClabel (n) = "NC_" ^ ($ n);
  fun getNClabel () = (tmp_label := !tmp_label+1;makeNClabel(!tmp_label));
end;

val Switch = "0x91";
val Switch = 145;
val BcTag = "0x4e93";
(* (* later ... *)
val MC68K = {
	     NCexception = ref false,    (* NC->NC raise using NC *)
	     Regression = ref false      (* use Unix assembler *)
	     }
*)
(**********************************************************************)
(*
 *  The Following is m/c varient 
 *)

(* 
 * the operands
 *)
 
datatype NCopd = A of int             (* An      *)
               | D of int             (* Dn      *)
               | PC of int            (* PC@(n)  *)
	       | @@ of int            (* An@     *)
	       | @- of int            (* An@-    *)
               | @+ of int            (* An@+    *)
               | @$ of int * int      (* An@(m)  *)
               | W  of int            (* #imm:w  *)
	       | L of int * int;      (* #imm:l  *)
(*
 *   the types 
 *) 

(* 
 * Now the instuctions 
 *)

datatype 'a NCop  =  addl  of NCopd * NCopd
                | andl  of NCopd * NCopd
		| bcc   of int * 'a
		| bra   of 'a
		| bsr   of 'a
		| clrl  of NCopd
		| cmpl  of NCopd * NCopd
		| cmpmb of NCopd * NCopd
		| cmpw  of NCopd * NCopd
		| dbcc  of int * NCopd * 'a
		| exg   of NCopd * NCopd
		| extl  of NCopd
		| even
		| jsr   of NCopd
		| jmp   of NCopd
		| lea   of NCopd * NCopd
		| movel of NCopd * NCopd
		| movew of NCopd * NCopd
		| negl  of NCopd
		| nop
		| orl   of NCopd * NCopd
		| rts
		| subl  of NCopd * NCopd 
		| tstl  of NCopd
		| tstw  of NCopd
		| byte  of (int list)
		| label of 'a
		| jplst of ('a * int list)
		| word  of (int list);


(*
 *  The conditionals for the flow of control
 *)
		  
val hi = 2  and ls = 3  and cc = 4  and cs = 5
and ne = 6  and eq = 7  and pl = 10 and mi = 11
and ge = 12 and lt = 13 and gt = 14 and le = 15;
		  
(*
 *	The Cop out: the byte code inline insertion code
 *
 *)

fun Byte_Code_Insert t =
    let
	val data = map (fn x => "\n\t.byte 0x"^(Hex(x,2))) t
     in
	(Default_Bound,[
	     jsr (@@ 3),
	     byte (t@[Switch]),
	     even
	     ],Default_Bound,1000)  (* 1000 = infinity ?? *)
     end;


(* 
 * These are used to provide a very readable 68kcode.sml 
 *
 *)

infix ||;
    
fun x || y = (x^"\n"^y);

infix |>;
    
fun x |> y = (x^"\n\t"^y);

fun >> y = ("\n\t"^y);



(*
 * The 68K libary ... 
 *
 *) 

local


    val Switch = 145;   
    fun NCraise (n) = [];
    


(*
 *  return a long Label
 *
 *)

fun L' n = 
    let 
	val t = n div 65536
	val b = n mod 65536
    in 
	if t < 0 
	    then L(65536+t,b)
	else L(t,b)
    end;

(*
 *  And the unboxed version
 *
 *)

fun CxL n = 
    let 
	val t = n div 65536
	val b = n mod 65536
    in 
	if t < 0 
	    then L(16384+t,b)
	else L(49152+t,b)
    end;

(*
 * Raise an Internal exception, ie Hd, Tl, Bind 
 * 
 * Check for short exception, and, if pos, jump (short circuit it!)
 * YACH. (yet another childish hack)
 *
 *)
fun NCraise (n) = 
let
	val _ = ()
in
    [
    movel(L' n,@- 5),	(* top object is the exception number *)
    jsr(@@ 3),		(* back to BC *)
    byte [190,Switch]	(* collect the bins *)
    ]
end;

(***********************

(*   *)
	   (*"movel  *)movel((*d4 *)D 4,(*a0 *)A 0"    (* fetch the trap top *)
	|> (*"tstl  *)tstl((*a0@ *)@@ 0"
	|> "beq "^lab1      (* the top level has to be raised ... *)
	|> (*"movel  *)movel((*a0@ *)@@ 0,(*a1 *)A 1" 
	|> (*"tstl  *)tstl((*a1@ *)@@ 1"       (* and get the exception, (might . 2 0) *)
	|> "bne "^lab1      (* again the top level has to be raised ... *)
			(* now free to handle exception internaly !!!! *)
	|> "nop"	(* but cope out for now .. *)

(* first check if ret'ing to BC ... *)

	|> (*"movel  *)movel((*a0@( *)@$(00x0c:w),(*a1 *)A 1"   (* FP = (Closure * )TrapTop[3]; *)
	|> (*"movel  *)movel((*a1@ *)@@ 1,(*a1 *)A 1"
	|> (*"cmpw  *)cmpw(#"^BcTag^",(*a1@( *)@$(10x6:w)"  (* see if BC text *)
|> "beq "^lab1		(* use normal exception rasing mech. *)

(* going for NC -> NC continuation (space rats ?) *) (* one day ... *)

	|> (*"movel  *)movel((*a0@( *)@$(00x0c:w),(*a4 *)A 4"  (* FP = (Closure * )TrapTop[3]; (finaly) *)

	|> (*"movel  *)movel((*d5 *)D 5,(*a1 *)A 1"
	|> (*"movel  *)movel((*a1@( *)@$(10x4:w),(*a5 *)A 5"
	|> (*"subl  *)subl((*a0@( *)@$(00x10:w),(*a5 *)A 5" 
		(* AP = IPtrOff_((CurrentProcess -> ArgStk), TrapTop[4]); *)

	|> (*"movel  *)movel((*a1@( *)@$(10x8:w),(*d4 *)D 4"
	|> (*"subl  *)subl((*a0@( *)@$(00x8:w),(*d4 *)D 4"
  	     (* TrapTop = IPtrOff_((CurrentProcess -> CtlStk), TrapTop[2]);*)

	|> (*"movel  *)movel((*d6 *)D 6,(*a1 *)A 1"
	|> (*"movel  *)movel((*a1@( *)@$(10x4:w),(*a1 *)A 1"   (* BuiltinExn ? *)
	|> (*"movel  *)movel((*a1@( *)@$(10x"^Hex(n*4,4)^":w),(*d0 *)D 0"(* get the appro. exception *)
			(* *(--AP) = (LWord)(exception); *)

	|> (*"movel  *)movel((*a4@ *)@@ 4,(*a1 *)A 1"
	|> (*"subl  *)subl((*a0@( *)@$(00x4:w),(*a1 *)A 1"    (* subtract a -ve number => add offset *)
		(* PC = (Byte * )IPtrOff_((FP -> text), TrapTop[1]); *)

	|> (*"movew  *)movew((*a1@( *)@$(10x2:w),(*d1 *)D 1"    (* access into the table *) 
	|> (*"extl  *)extl((*d1 *)D 1"
	|> (*"addl  *)addl((*d1 *)D 1,(*a1 *)A 1"    (* access into the table *) 
			(*  PC += PCSwTab_(ExcCount+1); *)
	|> (*"lea  *)lea((*a0@( *)@$(00x14:w),(*a7 *)A 7"    (* CP = TrapTop + 5 *)
	|> (*"jmp  *)jmp((*a1@ *)@@ 1"   (* hyperspace ... *)

	|| lab1^":"
	|> 

(*	*) "move"^quick(n,128,8)^",(*d0 *)D 0" 
	|> (*"jsr  *)jsr((*a3@ *)@@ 3" 			(* back to BC *)
	|> ".byte 0xbe"			(* and raise the exception *)
	|> ".even"
end;
*********************)

(*
 *	Heap allocation stuff.
 *	Note: can loop for-ever if heap full, but this is fatal anyway ...
 * 	NOTE: remember to do movel (D 2,A 2)
 *
 *)

fun NCAllocate(len,tag,presize) = (* the allocation macro *)
    let 
	val lab1 = getNClabel()
	val lab2 = getNClabel()
    in
    [
     label (lab1),
     movel(A 2,D 2),		(* d2 = new heap allocation addr *)
     addl(L' len,D 2),
     cmpl(D 3,D 2),
     bcc(ls,lab2),
     jsr(@@ 3),			(* back to BC *)
     byte [85,Switch],		(* collect the bins *)
     even,			(* return to good old NC *)
     bra (lab1),		(* and try, try try again *)
     label (lab2),
     movel(L(49152+tag,presize),@$(2,~4))
     ]

    (* NOTE: remember to do movel (D 2,A 2) *)

end;

(* 
 *  later will include loop unroling /etc
 *
 *)

fun (*native*)Loop_use (0,s,ic) = ([],0)
  | Loop_use (n,s,ic) = 
    if n < 5 then 
	let 
	    val (x,c) =  Loop_use (n-1,s,ic)
	in
	    (s @ x,ic+c) 
	end
    else
	let
	    val lab1 = getNClabel()
	    val lab2 = getNClabel()
	in
	    ([
	      movel (L' n,D 1),
	      bra(lab2),
	      label(lab1)
	      ] @s@
	      [
	       label(lab2),
	       dbcc(1,D 1,lab1)        (* dbcc 1 => dbra *)
	       ],4+10+(n*(ic+10))+12)
    end;

in
    val NCuse = {
		 Switch = Switch,
		 NCraise = NCraise,
		 L' = L',
		 CxL = CxL,
		 NCAllocate = NCAllocate,
		 Loop_use = Loop_use
		 }
end;
(*
 * A 68k assember for NC4ESML --- the 68k specific assembler
 *
 *)  

(*
 *  Pass 3, Decompose assembly language into primitives
 *
 *)

local

local
    val {AddEntry,FindVal,...} = MakeDict ((op <):LAB*LAB->bool)
in	
(*  val NoDict = NewTable : (string,int)SYMBOLTABLE*)
  val AddEntry = AddEntry
  val FindVal = FindVal
end;

fun toword n = if n < 0 then 65536+n else n;

(*AJGDEL exception NC4ESML_assm of string;*)

(*AJGDEL exception Getit;*)

exception Branch of (LAB * int) 
      and Label of LAB 
      and Even
      and JpLst of (LAB * int);

(* 
 * is a value inside a range ?
 *)

fun bound (p,n,m) =
	case p of
	  [x] 		=> x > n andalso x < m
	| 0::y::_ 	=> bound([y],n,m)
	| 65535::y::_ 	=> bound([y-65536],n,m)
	| _ => false;

(* 
 * get n significant bits from a list
 *)

fun get8 [p] = p
  | get8 [0,p] = p
  | get8 [65535,p] = p mod 256
  | get8 _ = raise (Comp_ncg "68K assm error (get8)")

fun get3 (0::p::x) = (p mod 8,x)
  | get3 _ = raise (Comp_ncg "68K assm error (get3)")

(*
 *  turn a byte list into a word list
 *)

fun btow [] = [] | btow [n] = [n*256] | btow (n::m::t) = n*256+m::btow(t);

fun (*native*) interp1 (n,a) = case n of
          (D n) 	=> ((0,n),a)
	| (A n)		=> ((1,n),a)
	| (@@ n) 	=> ((2,n),a) 
	| (@+ n) 	=> ((3,n),a) 
	| (@- n) 	=> ((4,n),a) 
	| (@$(n,x))	=> ((5,n),(toword (x)::a))
	| (W n)		=> ((7,4),toword (n)::a)
	| (L (n,m))	=> ((7,4),m::n::a)
	| (PC (x))	=> ((7,2),(toword (x)::a));

fun (*native*) interp2 (x,y) = 
let
  val ((sm,sr),t) = interp1 (x,[])
  val ((dm,dr),t) = interp1 (y,t)
in
	(sm,sr,dm,dr,rev t)
end;

fun (*native*) OpCode(a,b,c,d,e) = (4096*a+512*b+64*c+8*d+e);

(*
 * the add macro function 
 *) 

fun i_addl(x,b) = 
let
    val (sm,sr,dm,dr,p) = interp2 x
in
    if (sm,sr)=(7,4) andalso dm<>1 			(* addl #x,E *)
	then if bound(p,0,9) 	
		 then let 
			  val (x,p) = get3 p
			  val b = if b = 13 then 2 else 6
		      in                                (* quick *)
			  OpCode(5,x,b,dm,dr)::p
		      end
	     else 
		 let
		     val b = if b = 13 then 3 else 2
		 in
		     OpCode(0,b,2,dm,dr)::p	  	(* long *)
		 end
    else if dm = 0 					(* addl X,d(n) *)
	then OpCode(b,dr,2,sm,sr)::p

			else if dm = 1 			(* addl X,a(n) *)
	then OpCode(b,dr,7,sm,sr)::p

			else if sm = 0 			(* addl d(n),X *)
	then OpCode(b,sr,6,dm,dr)::p

	else raise (Comp_ncg("internal address mode error: addl"))
end;

fun i_cmpl(x,t,s) = 
let
    val (sm,sr,dm,dr,p) = interp2 x
in
    if dm <> 0
	then raise (Comp_ncg("internal address mode error: cmpl"))
    else OpCode(t,dr,s,sm,sr)::p
end;


fun (*native*) i_movel(x,b) = 
let
    val (sm,sr,dm,dr,p) = interp2 x
in
    if (dm,sm,sr,b) = (0,7,4,2) andalso bound(p,~129,128) 
	then [OpCode(7,dr,0,0,get8 p)]
    else (OpCode(b,dr,dm,sm,sr)::p)
end;

fun i_exg (x,t) = 
let
    val (sm,sr,dm,dr,p) = interp2 x
in
    if (sm,dm) = (0,0) then [OpCode(t,sr,5,0,dr)]
	else if (sm,dm) = (1,1) then [OpCode(t,sr,5,1,dr)]
	else if (sm,dm) = (0,1) then [OpCode(t,sr,6,1,dr)]
	    else raise (Comp_ncg("internal address mode error: exg"))
end;



fun i_tstl(x,t) = 
let
  val ((sm,sr),p) = interp1 (x,[])
in
    (OpCode(0,0,t,sm,sr)::p)
end;

fun i_bra(s,t) = raise Branch(s,OpCode(6,0,0,0,256*t));

fun i_dbra(t,r,s) = 
    let
	val ((sm,sr),p) = interp1 (r,[])
    in
	if sm = 0 
	    then raise Branch(s,OpCode(5,0,4*t+3,1,sr))
	else raise Comp_ncg("internal address mode error")
end

(*
fun pntjmplist (l,[x]) = "\t.word 0x1,(FAM_"^($ x)^"-"^l^")+0x4\n"^l^":"
  | pntjmplist _ = raise (Comp_ncg "Too big a list");
*)


fun i_lea(x,t) = 
let
    val (sm,sr,dm,dr,p) = interp2 x
in
    if dm = 1 
	then OpCode(4,dr,t,sm,sr)::p
    else raise (Comp_ncg("internal address mode error"))
end;

fun i_cmpmb(x) = 
let
    val (sm,sr,dm,dr,p) = interp2 x
in
    if (dm,sm) = (3,3)
	then OpCode(11,dr,4,1,sr)::p
    else raise (Comp_ncg("internal address mode error"))
end;

fun i_andl(x,t) =
let
    val (sm,sr,dm,dr,p) = interp2 x
in
    if (sm,sr) = (7,4) 				(* andi #x,... *)
	then let
		 val x = (fn 12 => 1 | 8 => 0) t;
	     in
		 OpCode(0,x,2,dm,dr)::p
	     end
    else if dm = 0				(* and d0,... *)
	     then OpCode(t,dr,2,sm,sr)::p
	 else OpCode(t,sr,6,dm,dr)::p
end;

in
    
fun MLAssembler (n,_) =
let
	fun (*native*) AssIt' (n,m,l,t) = (* instuctions in/out, len, table *)
	    if null n 
		then (m,l,t)  (* return instructions + env *)
	    else 
		let 
		    val x = jumpcase hd n of 
			  word(x)	=> x
			| label(s)	=> raise Label s
		        | byte(s)	=> btow s
			| jplst(a,b)	=> ((raise JpLst(a,hd b))
			      handle Hd => raise (Comp_ncg "jumping error"))
			| addl(n) 	=> i_addl  (n,13)
			| andl(n)       => i_andl  (n,12)
			| bcc(n,m) 	=> i_bra   (m,n)
			| bra(n) 	=> i_bra   (n,0)
			| bsr(n) 	=> i_bra   (n,1)
			| clrl(n)  	=> i_tstl  (n,266)
			| cmpl(n)  	=> i_cmpl  (n,11,2)
			| cmpmb(n)  	=> i_cmpmb (n)
			| cmpw(n)  	=> i_cmpl  (n,11,1)
			| dbcc(n) 	=> i_dbra  (n)
			| exg(n)  	=> i_exg   (n,12)
			| extl(n)  	=> i_tstl  (n,291)
			| even  	=> raise Even
			| jmp(n)	=> i_tstl  (n,315)
			| jsr(n)	=> i_tstl  (n,314)
			| lea(n)  	=> i_lea   (n,7)
			| movel(n) 	=> i_movel (n,2)
			| movew(n) 	=> i_movel (n,3)
			| negl(n)	=> i_tstl  (n,274)
			| nop		=> [20081]
			| orl(n)        => i_andl  (n,8)
			| rts	  	=> [20085]
			| subl(n) 	=> i_addl  (n,9)
			| tstl(n)  	=> i_tstl  (n,298)
		        | tstw(n)  	=> i_tstl  (n,297)
		in
    			AssIt'(tl n,Word (x,l)::m,length x+l,t)
		end handle (Branch (x,y)) => AssIt'(tl n,
				 (Jump ((x,false),l+1))
						    ::(Word([y],l))
						    ::m,l+2,t)

	      		 | (Label x)  => AssIt'(tl n,m,l,AddEntry (x,l,t))
			 | (Even)  =>  AssIt'(tl n,m,l,t)
			 | (JpLst (a,b)) => AssIt'(tl n,
					    Jump(("FAM_"^($b),true),l+1)
					    ::Word([01],l)
						   ::m,l+2,AddEntry(a,l,t));
				
						    

	fun backwords x = (if x < 2 then 32767+x else x-1)*2;

	fun (*native*) AssSection (ass,m,l,t) = 
	    if null ass 
		then (m,l,(fn ((y,y'),z) => 
			   if y' 
			       then backwords((FindVal(y,t)-z)+2)
			   else backwords((FindVal(y,t)-z)+1)))
	    else 
		let
		    val (m,l,t) = AssIt' (hd ass,m,l,t)
		in
		    AssSection(tl ass,m,l,t)
		end;
	val _ = if !(#PrintDebug Ncopt) 
		    then outstring("Pass 3: Assembling (in ML)\n")
		else ()
in
    AssSection (n,[],0,NewTable)
end;

end;


local
fun pntlst (x,h) = 
    let
	fun hex x  = "0x"^Hex(x,h);
	    
	fun pnl [] = ""
	  | pnl (h::t) = "," ^ (hex h) ^ (pnl t);
    in
	(hex (hd x)) ^ (pnl (tl x))
    end;

fun pntjmplist (l,[x]) = "\t.word 0x1,(FAM_"^($ x)^"-"^l^")+0x4\n"^l^":"
  | pntjmplist _ = raise (Comp_ncg "Too big a list");

fun pntsnhex x = if x < 0 then ("@(-0x"^Hex(0-x,4)^":w)")
		 else if x < 32768 
			  then ("@(0x"^Hex(x,4)^":w)")
		      else ("@(-0x"^Hex(65536-x,4)^":w)");
		     
fun pnt1arg (D n) 	= "d"^($ n)
  | pnt1arg (A n)	= "a"^($ n)
  | pnt1arg (@@ n) 	= "a"^($ n)^"@"
  | pnt1arg (@+ n) 	= "a"^($ n)^"@+"
  | pnt1arg (@- n) 	= "a"^($ n)^"@-" 
  | pnt1arg (@$(n,x))	= "a"^($ n)^(pntsnhex x)
  | pnt1arg (W n)	= "#0x"^(Hex (n,4))
  | pnt1arg (L (n,m))	= "#0x"^(Hex (n,4))^(Hex (m,4))
  | pnt1arg (PC (x))	= "pc"^(pntsnhex x);

fun pnt2arg(x,y) = (pnt1arg x) ^ "," ^ (pnt1arg y);

fun pntj (0)  = "ra"
  | pntj (2)  = "hi"
  | pntj (3)  = "ls"
  | pntj (4)  = "cc"
  | pntj (5)  = "cs"
  | pntj (6)  = "ne"
  | pntj (7)  = "eq"
  | pntj (10) = "pl"
  | pntj (11) = "mi"
  | pntj (12) = "ge"
  | pntj (13) = "lt"
  | pntj (14) = "gt"
  | pntj (15) = "le";


fun pntjmp (m,x)  = "b" ^ (pntj x) ^ "l " ^ m;

fun pntdbcc (x,n,m)  = "db"^ (pntj x) ^ " " ^ (pnt1arg n) ^ "," ^ m;
    
    
fun PrintInst x = if null x then "" else
let
    fun T x = "\t" ^ x;
	
    val i = case hd x of 
	word(x)		=> T ".word "^(pntlst (x,4))
      | label(s)	=> s^":"
      | byte(x)		=> T ".byte "^(pntlst (x,2))
      | jplst(l,s)	=> pntjmplist(l,s)
      | addl(n) 	=> T "addl "^(pnt2arg n)
      | andl(n)       	=> T "andl "^(pnt2arg n)
      | bcc(n,m) 	=> T (pntjmp(m,n))
      | bra(n) 	 	=> T (pntjmp(n,0))
      | bsr(n) 	 	=> T "bsr "^n
      | clrl(n)  	=> T "clrl "^(pnt1arg n)
      | cmpl(n)  	=> T "cmpl "^(pnt2arg n)
      | cmpmb(n)  	=> T "cmpmb "^(pnt2arg n)
      | cmpw(n)  	=> T "cmpw "^(pnt2arg n)
      | dbcc(n) 	=> T (pntdbcc(n))
      | exg(n)  	=> T "exg "^(pnt2arg n) 
      | extl(n)  	=> T "extl "^(pnt1arg n)
      | even		=> T ".even"
      | jmp(n)		=> T "jmp "^(pnt1arg n)
      | jsr(n)		=> T "jsr "^(pnt1arg n)
      | lea(n)  	=> T "lea "^(pnt2arg n)
      | movel(n) 	=> T "movel "^(pnt2arg n)
      | movew(n) 	=> T "movew "^(pnt2arg n)
      | negl(n)		=> T "negl "^(pnt1arg n)
      | nop		=> T "nop"
      | orl(n)       	=> T "orl "^(pnt2arg n)
      | rts	  	=> T "rts"
      | subl(n) 	=> T "subl "^(pnt2arg n)
      | tstl(n)  	=> T "tstl "^(pnt1arg n)
      | tstw(n)  	=> T "tstw "^(pnt1arg n)

in
    i ^ "\n" ^ PrintInst(tl x)
end;

    fun readin (fd,n,sz,st) = 
	if n=sz  
	    then (close_in(fd);
		  if !(#PrintDebug Ncopt) 
		      then outstring("[Finished reading assembly file]\n") 
		  else ();
		      (st,sz,(fn (_,_) => sz)))
	else readin(fd,n+2,sz,( Word(
		     [ 256 * ord(input(fd,1)) + ord(input(fd,1)) ]
			 ,n div 2)::st));

(*
	val regheader = 
		"#NO_APP" || "" || "\t.text"  || "nativeclosure:" || ""
*)
	val regheader = "" || "\t.text"  || "nativeclosure:" || ""
	val regfooter = "" || "" 

	val assemblyfile = "_projectcode";

	fun PlaceLabel (x) = "FAM_"^($ x)^":";
in
     fun UseUnixAss (ncd,txt) =
      let
	val fd = open_out(assemblyfile^".s")
	fun os s = output(fd,s)
	val _ = os regheader
	val _ = map (os o PrintInst) ncd
	val _ = os regfooter
	val _ = close_out(fd)
	val _ = if !(#PrintDebug Ncopt) 
		    then outstring("Pass 3: Assembling .... \n")
		else ()
	val {VetText,nametext,...} = Text;
	val _ = if !(#PrintDebug Ncopt) then(
		system("echo \"--- AJG REGRESSION ---\" >> storetext.tmp~");
		system("date >> storetext.tmp~");
		system("echo "^(nametext txt)^" >> storetext.tmp~");
		system("cat < " ^assemblyfile^".s >> storetext.tmp~")
					     )
		else ()

(* using gas for now, speed up correction later 
 *  - f = no preprocessing


	val _ = system("/home/ajg/bin/sun3/a68 -f -o " ^assemblyfile^".o "
				^assemblyfile^".s")
 *)
	val _ = system("as -o " ^assemblyfile^".o "^assemblyfile^".s")
(*	val _ = system("strip "^assemblyfile^".o")*)
	val fd = open_in(assemblyfile^".o")
	val _ = input(fd,4);
	val sz = (fn [_,n2,n3,n4]  => n2*65536+n3*256+n4) 
	                 (map ord (explode(input(fd,4))));
	val _ = if !(#PrintDebug Ncopt) 
		    then outstring("[Reading "^ $ sz ^ " Bytes from as]\n")
		else ()
	val _ = if sz = 0 
		    then raise (Comp_ncg ("Unix Assembler Failure") )
		else ()
	val _ = input(fd,24); (* skip the blurb *)
(* 
 These are for the result table to pick up ....
 *)     in    
	readin(fd,0,sz,[])
      end
end;



   val {prim,usefun,optprim,option,reset,
        Prim,Usefun,Optprim,Option,...} = DynamicDB;

    val _ = reset ();  (* clear the database for re-entry *)
       
(* 
 *  Extra-Function Flow of control
 *
 *)

val _ = let
    val {L',Loop_use,...} = NCuse;
	val OpBind = (SK,[],SK,0);

	val OpApplFrame = (A0,
			   [movel(A 0,A 4),
			    movel(@@ 0,A 1),
			    jsr(@$(1,6))],
			    SK,4+12+18)

	fun OpTailApply (INT2(x,y)) =  
	    let
		val (i,c) = case y of
		    0 => ([],0)
		  | 1 => ([addl(L(0,4),A 5)],8)
		  | 2 => ([addl(L(0,8),A 5)],8)
		  | y => ([lea(@$(5,4*y),A 5)],8)
		val (l,lc) = Loop_use(y,[movel(@- 5,@- 0)],22)
	    in
		(A0,[movel(A 0,A 4),
		     lea(@$(5,4*(x+y)),A 0)
		     ] @ i @ l @
		     [
		      movel(A 0,A 5),
		      movel(@@ 4,A 1),
		      jmp(@$(1,6))
		      ],D0,8+c+lc+4+12+12+10)
	    end;
	    
	fun OpDestTailApply (INT x) = 
	    let
		val (l,lc) = Loop_use(x,[movel(@+ 0,@- 5)],22) (*Desttuple*)
	    in
		(A0,l @ 
		 [
		  movel(@$(4,4),A 4),		 (*Getfree(1)*)
		  movel(@@ 4,A 0),
		  jmp(@$(0,6))
		  ],SK,16+12+12+10)
	    end;
		 
	fun OpReturn (INT x) =  

	    let 
		val lab1 = getNClabel();
		val (i,c) = if x > 0 then ([addl(L'(x*4),A 5)],8) else ([],0);
	    in

		(D0,i @ [
			 movel(D 0,@- 5),
			 tstl(@@ 7),
			 bcc(mi,lab1),
			 rts,
			 label(lab1),
			 jsr(@@ 3),
			 byte [171],      (* the Return Byte Code: OpRet(0) *)
			 even
			 ], Default_Bound,c+14+12+12+16)
	    end;


	val OpCurrClos = (SK,[movel(A 4,A 0)],A0,4);

	val OpSaveFrame = (A0,[movel(A 4,@- 7)],A0,14);

	val OpRestFrame  = (SK,[movel(@+ 7,A 4)],SK,12);

	val OpCurrAppl = (SK,[
			      movel(A 4,@- 7),
			      bsr ("FAM_0")
			      ],SK,14+12);

in
     prim	140		OpBind;
     prim       72		OpApplFrame;
     usefun	70      	OpReturn;
     prim 	182 		OpCurrClos;
     prim 	71		OpSaveFrame;
     prim 	73		OpRestFrame;
     optprim 	[182,71,72] 	OpCurrAppl;        (* needs bsr *) 
     usefun 	97		OpTailApply; 
     usefun     218		OpDestTailApply;
   (* * *) outline "Extra Function Flow of Control" (* * *)
end;

(* 
 *  Intra-Function Flow of control
 *
 *)

val _ = let
    val {L',Loop_use,...} = NCuse;
    fun OpJump (JINT x) = (Default_Bound,[bra ("FAM_"^($ x))],Default_Bound,10)
    local
	fun OpCondJump (JINT x,s) = (D0,[
					cmpl  (D 7,D 0),
				        bcc(s,"FAM_"^($x))
					],Default_Bound,8+12)
    in
	fun OpFalseJump  (x)   = OpCondJump(x,eq);
	fun OpTrueJump   (x)   = OpCondJump(x,ne);
	fun OpFalseJump' [_,x] = OpCondJump(x,eq);
	fun OpTrueJump'  [_,x] = OpCondJump(x,ne)
    end;
(*		      lit   hand  loc   lit   dint  popt  *)

    fun PatchINTPATT [INTLIST l,INT 0,INT x,INT 0,_] =
	(SK,[
	     movel(@$(5,4),D 0),
	     subl(D 7,D 0),
	     cmpl (L' x,D 0),
	     bcc(ne,"FAM_"^($(hd l))),
	     movel (@$(5,4),@@ 5)
	     ],SK,18+8+14+12+20)

    fun PatchDestNil [INTLIST l,INT 0,INT 0,_] =
	(SK,[
	     movel(@$(5,4),D 0),
	     tstl (D 0),
	     bcc(ne,"FAM_"^($(hd l))),
	     movel (D 0,@@ 5)
	     ],SK,18+14+12+12)

    fun PatchDestQCons [INTLIST l,INT 0,INT 0,_] =
	(SK,[
	     movel(@$(5,4),D 0),
	     tstl (D 0),
	     bcc(eq,"FAM_"^($(hd l))),
	     movel (D 0,@@ 5)
	     ],SK,18+14+12+12)

(*
    fun PatchINTPATT x = (outstring ("\n#"^($(length x)));
			  (map (fn 
				INT x => outstring ("INT ("^($x)^", " )
			      | INTLIST  x => outstring "LIST, " 
			      | _     => outstring"other" 
				    ) (x));
			   (SK,[],SK,1000));
*)
in
    usefun  	56	OpJump;
    usefun	57 	OpTrueJump;
    usefun	58	OpFalseJump;
    option	[30,57] OpFalseJump';
    option	[30,58] OpTrueJump';

    option      [139,63,68,206] PatchDestNil;
    option      [139,63,174,206] PatchDestQCons;
(*
    option      [139,63,183,200,206] PatchINTPATT;*)

   (* * *) outline "Intra function flow of control" (* * *)
end;

(*
 * 
 * 	Exception Stuff, handles, pattern matching, etc.
 * 
 *)

val _ = let
    val {L',Loop_use,...} = NCuse;
	fun OpNewHandle (INTLIST x) = 
	let 
		val lab1 = getNClabel()
		val lab2 = getNClabel()
	in
		(SK,[
		     movel(D 5,A 0),
		     movel(@$(0,4),D 1),
		     lea(@$(5,4),A 1),
		     subl(A 1,D 1),
		     movel(D 1,@- 7),
		     movel(A 4,@- 7),
		     movel(@$(0,8),D 1),
		     subl(D 4,D 1),
		     movel(D 1,@- 7),
		     movel(@@ 4,D 1),
		     bra(lab2),
		     jplst(lab1,x),
		     label(lab2),
		     lea(PC ~6,A 0),  (* 0xc:w = sun, 0xa:w for gas  *)
		     subl(A 0,D 1),
		     movel(D 1,@- 7),
		     movel(@+ 5,@- 7),  (* the exception (0 ?) *)
		     movel(A 7,D 4)
		     ],SK,500)
	end

	val OpPopTrap =
		(D0,[
		     movel(D 5,A 0),
		     movel(@$(0,8),D 4),
		     subl(@$(7,8),D 4),
		     lea(@$(7,20),A 7)
		     ],D0,4+16+16+14);

	fun OpUnTrap (JINT x) =
		(SK,[
		     movel(D 5,A 0),
		     movel(@$(0,8),D 4),
		     subl(@$(7,8),D 4),
		     lea(@$(7,20),A 7),
		     bra ("FAM_"^($ x))
		     ],SK,4+16+16+14);
in
    usefun    	139 	OpNewHandle;
    prim	206 	OpPopTrap;
    usefun      79      OpUnTrap;
    (* * *) outline "Exception Handling" (* * *)
end;

(*
 * Stack manipulation operations
 *
 *)

val _ = let
    val {L',Loop_use,...} = NCuse;

    fun OpGetLocal (x) = (SK,[],ANY(fn y => movel(@$(5,x*4),y)),16);

    fun OpGetLocal1 (INT 0) = (D0,[movel(D 0,@- 5)],D0,12)
      | OpGetLocal1 (INT x) = OpGetLocal x;

    fun OpGetLocal2 (INT 0) = (A0,[movel(A 0,@- 5)],A0,12)
      | OpGetLocal2 (INT x) = OpGetLocal x;

    fun OpGetLocal3 (INT 0) = (SK,[movel(@@ 5,D 0)],D0,12)
      | OpGetLocal3 (INT x) = OpGetLocal x;

    fun OpGetLocal4 (INT 0) = (SK,[movel(@@ 5,A 0)],A0,12)
      | OpGetLocal4 (INT x) = OpGetLocal x;

    fun OpGetLocal5 (INT 0) = (SK,[movel(@@ 5,@- 5)],SK,20)
      | OpGetLocal5 (INT x) = OpGetLocal x;

	val OpAt = (A0,[],ANY (fn y => movel(@@ 0,y)),12);

        (* val OpRef *)

	val OpAssign = (D0,[
			    movel(@+ 5,A 0),
			    movel(D 0,@@ 0),
			    movel (L' 0,D 0)],D0,(*X*)99);

	fun OpPop (INT x) = (SK,[addl(L' (4*x),A 5)],SK,12);

	fun OpSqueeze (INT x) = (D0,[addl(L' (4*x),A 5)],D0,12);

	fun OpSlide (INT2 (x,y)) =
	let 
		val lab1 = getNClabel()
		val lab2 = getNClabel()
		val (i,c) = if y < 0 
				then ([],0) 
			    else 
		    let
			val (l,lc) = Loop_use(y,[movel(@- 5,@- 0)],22)
		    in
			(lea(@$(5,(4*y)),A 5)::l,8+lc)
		    end
	in
		(SK,[
		     lea(@$(5,4*(x+y)),A 0)
		     ] @ i @
		     [
		      movel(A 0,A 5)
		      ],SK,8+4+c)
	end;

	fun OpGetFree (INT x) = (SK,[],ANY(fn y => movel(@$(4,4*x),y)),16)

	fun OpGetLit (INT x) = (SK,[movel(@@ 4,A 0), movel(@@ 0,A 0)],
				ANY (fn y => movel(@$(0,4*x),y)),12+12+16)

in
    Usefun	63	[OpGetLocal1,
			 OpGetLocal2,
			 OpGetLocal3,
			 OpGetLocal4, 
			 OpGetLocal5];
    prim 	54	OpAt;
    prim	55	OpAssign;
    usefun      64      OpPop;
    usefun	66	OpSqueeze; 
    usefun 	175	OpSlide;       (* FIX LATER .... *) 
     usefun	1	OpGetFree;
     usefun 	99	OpGetLit;
    (* * *) outline "Trivial Stack Manipulations" (* * *)
end;

(*
 *  Boolean operations
 *
 *)

val _ = let
    val {L',...} = NCuse;
	val OpNot = (D0, [ word [2560,1]     (* eorb(L' 1,D 0) *)
			  ],D0,8);

	val OpAnd = (D0,[andl (@+ 5,D 0)],D0,14);

	val OpOr = (D0,[orl (@+ 5,D 0)], D0,14);

	fun OpEqBool _ =
	let 
		val lab1 = getNClabel()
	in
		(D0, [
		      movel(D 7,D 1),
		      cmpl(@+ 5,D 0),
                      bcc(ne,lab1),
		      addl(L' 1,D 1),
		      label(lab1)
		      ],ANY(fn x => movel(D 1,x)),4+14+10+8+4)
	end
in
    prim 	30	OpNot;
    prim	31	OpAnd;
    prim	32	OpOr;
    usefun	41	OpEqBool;
    (* * *) outline "Boolean Operations" (* * *)
end;

(*
 *	Numeric Operations
 *
 *)

val _ = let
    val {L',CxL,...} = NCuse;
	fun OpByteNum (INT x) = 
	    if x = 0 
		then (SK,[],ANY (fn x => movel(D 7,x)),4)
	    else if x < 128 
		     then (SK,[movel(L' x,D 0),orl(D 7,D 0)],D0,4+8)
		 else (SK,[],ANY(fn y => movel(CxL x,y)),28)
in
    usefun 	183	OpByteNum;
    (* * *) outline "Numeric Operation" (* * *)
end;

(*
 *	Arithmetic Operations
 *
 *)

val _ = let
    val {L',...} = NCuse;

	val OpNeg = (D0,[
			 subl(D 7,D 0),
			 negl(D 0),
			 addl(D 7,D 0)
			 ],D0,8+6+8);

	val OpPlus =  (D0,[
			   addl(@+ 5,D 0),
			   subl(D 7,D 0)
			   ],D0,8+8);

	fun OpINTPLUS [INT x,_] = (D0,[addl(L' x,D 0)],D0,8);

	val OpDiff = (D0,[
			  subl(@+ 5,D 0),
			  negl(D 0),
			  addl(D 7,D 0)
			  ],D0,14+6+8);

	fun OpINTDIFF [INT x,_] = (D0,[subl(L' x,D 0)],D0,8);

	val OpTimes =  (D0,[
			    subl(D 7,@@ 5),
			    subl(D 7,D 0),
			    word[19485,2048], (* mulsl a5@+,d0 *)
			    addl(D 7,D 0)
			    ],D0,14+8+76+8);
	val OpDiv =  (D0,[
			  subl(D 7,@@ 5),
			  subl(D 7,D 0),
			  word[19557,7168], (* divsl a5@-,d0:d1 *)
			  addl(D 7,D 0)
			  ],D0,14+8+76+8);

	val OpMod =  (D0,[
			  subl(D 7,@@ 5),
			  subl(D 7,D 0),
			  word[19557,6145], (* divsl a5@-,d1:d0 *)
			  addl(D 7,D 0)
			  ],D0,14+8+76+8);

in
    prim 	33	OpNeg;
    prim 	34	OpPlus;
    prim 	35	OpDiff;
    prim 	36	OpTimes; 

    option    [183,34]	OpINTPLUS;
    option    [183,35]	OpINTDIFF;
(*
    prim 	37 	OpDiv;
    prim	38 	OpDiv;
    prim	39 	OpMod;
*)
    (* * *) outline "Arith Operations" (* * *)
end;


(*
 *  	List Operations
 *
 *)


val _ = let
    val {NCraise,L',...} = NCuse;
	
	fun OpHd _ =
	    let 
		val lab1 = getNClabel()
	    in
		(D0, [
		      tstl(D 0),
		      bcc(ne,lab1)
		      ] @ NCraise(0) @
		      [
		       label(lab1),
		       movel(D 0,A 0)
		       ],ANY (fn x => movel(@@ 0,x)),4+12+4+12)

	    end;

	fun OpTl _ =
	    let 
		val lab1 = getNClabel()
	    in
		(D0,[
		     tstl(D 0),
                     bcc(ne,lab1)
		     ] @ NCraise(1) @
		     [
		      label(lab1),
		      movel(D 0,A 0)
		      ], ANY (fn x => movel(@$(0,4),x)),4+12+4+16)

	end

	fun OpNull _ =
	    let 
		val lab1 = getNClabel()
	    in
		(D0,[
		     movel(D 7,D 1),
		     tstl(D 0),
		     bcc(ne,lab1),
		     addl(L' 1,D 1),
		     label(lab1)
		     ], ANY (fn x => movel(D 1,x)),4+8+12+4+4)
	end
	local
	    fun NULLJUMP ([_,JINT y],s) =
		(D0,[
		     tstl (D 0),
		     bcc(s,"FAM_"^($y))
		     ],SK,4+12)

	    fun LOCALNULLJUMP ([INT x,_,JINT y],s) =
		(SK,[
		     tstl(@$(5,x*4)),
		     bcc(s,"FAM_"^($y))
		     ],SK,12+12)
	in
	    fun NullJumpT (x) = NULLJUMP(x,eq);
	    fun NullJumpF (x) = NULLJUMP(x,ne);
	    fun NullJumpT'(x) = LOCALNULLJUMP(x,eq);
	    fun NullJumpF'(x) = LOCALNULLJUMP(x,ne);
	end
in
    usefun	17		OpHd;
    usefun	18		OpTl;
    usefun	19		OpNull;
    option    [19,57]		NullJumpT;
    option    [19,58]		NullJumpF;
    option    [63,19,57]	NullJumpT';
    option    [63,19,58]	NullJumpF';
    (* * *) outline "List Operations" (* * *)
end;

(*
 *  	Ops on tuples 
 *
 *)

val _ = let
	fun OpQuadot (INT x) = (A0,[],ANY (fn y => movel(@$(0,x*4),y)),16)
in
    usefun 	24	OpQuadot;
    (* * *) outline "Access tuples" (* * *)
end;

(*
 *  'Comparing' Op Codes
 *
 *)

val _ = let
    val {L',...} = NCuse;
    fun tobra 42 = ne
      | tobra 44 = cc
      | tobra 45 = ls
      | tobra 46 = hi
      | tobra 47 = cs;

    fun tobra' 42 = eq
      | tobra' 44 = cs
      | tobra' 45 = hi
      | tobra' 46 = ls
      | tobra' 47 = cc;

    fun OpCMP (INT x) =
	let 
	    val lab1 = getNClabel()
	    val s = tobra x
	in
		(D0,[
		     movel(D 7,D 1),
		     cmpl(@+ 5,D 0),
		     bcc(s,lab1),
		     addl(L' 1,D 1),
		     label(lab1)
		     ],ANY (fn x => movel(D 1,x)),4+14+12+6+4)
	end

    local
	fun CMPJUMP ([INT x,JINT y],s) =
	    let
		val s = tobra x
	    in
		(D0,[
		     cmpl(@+ 5,D 0),
		     bcc(s,"FAM_"^($y))
		     ],SK,14+12)
	    end
    in
	fun OpCJFalse  (x)   = CMPJUMP(x,eq);
	fun OpCJTrue   (x)   = CMPJUMP(x,ne);
    end;
in

    usefun 	42	OpCMP;
    option   [42,58]    OpCJFalse;
    option   [42,57]    OpCJTrue;
    (* * *) outline "Integer Comparing" (* * *)
end;

(*
 *  	heap allocation op-codes
 *
 *)

val _ = let
    val {NCAllocate,Loop_use,L',...} = NCuse;
	
(*	fun OpTuple2 _ =
	let 
		val lab1 = getNClabel()
	in
		(D0, NCAllocate(8+4,3,2) @
		 [
		  movel(@+ 5,@@ 2),
		  movel(D 0,@$(2,4)),
		  exg(D 2,A 2)],
		  ANY (fn x => (movel(D 2,x))),12+16+4+100)
	end;
*)
	val OpTuple_0 = (SK,[], ANY (fn x => clrl(x)),6);

	fun OpTuple (INT n) = 
	    let
		val (cd,ct) = Loop_use(n,[movel(@+ 5,@- 0)],20)
		val lab1 = getNClabel()
	    in
		(SK,[cmpl(A 2,D 3),
		  bcc(gt,lab1),
		  jsr(@@ 3),		(* back to BC *)
		  byte [85,Switch],	(* collect the bins *)
		  even,			(* return to good old NC *)
		  label(lab1),
		  movel(L (49152+(if n = 2 then 3 else 4),n),@@ 2),
		  lea (@$(2,n*4+4),A 0),
		  movel (A 0,A 2) ] @ cd,A0,ct+4+4+100)
	    end;
in
(*    usefun	83      OpTuple2; *)
    prim	2	OpTuple_0;
    usefun	12	OpTuple;
    (* * *) outline "Heap Allocation" (* * *)
end;

(*
 *  OpDest{*} operations
 *
 *)

val _ = let
    val {NCraise,L',Loop_use,...} = NCuse;
    fun OpDestTuple (INT2 (x,y)) = 
	let
		val lab1 = getNClabel()
		val lab2 = getNClabel()
		val (cd,cst) = Loop_use(x-1,[movel(@+ 0,@- 5)],20)
	in
		(SK,[
		     movel(@$(5,y*4),A 0),
		     movel(@@ 0,@$(5,y*4)),
		     addl(L' 4,A 0)] 
		     @ cd , SK , 16+18+8+cst)
	end;

(*	fun OpDestBigVar x =*)

	fun OpDestNil (INT x) =
	let
		val lab1 = getNClabel()
	in
		(D0, [ if x = 0 then tstl(D 0) else tstl(@$(5,(x-1)*4)),
			     bcc(eq,lab1) ] @
			     NCraise(17) @
			     [label(lab1)],D0,6+12)
	end;

	fun OpDestQCons (INT x) =
	let
		val lab1 = getNClabel()
	in
		(D0, [ if x = 0 then tstl(D 0) else tstl(@$(5,(x-1)*4)),
			     bcc(ne,lab1) ] @
			     NCraise(17) @
			     [label(lab1)],D0,6+12)
	end;
			
	fun OpDestInt (INT x) =
	let 
		val lab1 = getNClabel()
	in
	    (D0, [
		  cmpl(@$(5,x*4),D 0),
		  bcc(eq,lab1)] @
		  NCraise(17)  @
		  [label(lab1)],SK,14+12)
	end;


in
    usefun	172	OpDestTuple;
    usefun	68	OpDestNil;
    usefun	174	OpDestQCons;
    usefun	200	OpDestInt;
    (* * *) outline "Structure Decomposision" (* * *)
end;

(*
 *  Closure stuff
 *
 *)
val _ = let
    val {NCAllocate,Loop_use,L',...} = NCuse;

	fun OpClosure (INT n) = 
	    let
		val (cd,cst) = Loop_use(n,[movel(@+ 5,@+ 2)],20)
		val lab1 = getNClabel()
	    in
		  (SK,[cmpl(A 2,D 3),
		       bcc(gt,lab1),
		       jsr(@@ 3),		(* back to BC *)
		       byte [85,Switch],	(* collect the bins *)
		       even,			(* return to good old NC *)
		       label(lab1),
		       movel(L (49152+4,n),@+ 2),
		       movel(A 2,A 0) ] @ cd ,A0,cst+100+4+12+4+4)
	    end;
	    
	fun OpDumClosure (INT n) = 
	    let
		val (cd,cst) = Loop_use(n,[clrl(@+ 2)],14)
		val lab1 = getNClabel()
	    in
		  (SK,[cmpl(A 2,D 3),
		       bcc(gt,lab1),
		       jsr(@@ 3),		(* back to BC *)
		       byte [85,Switch],	(* collect the bins *)
		       even,			(* return to good old NC *)
		       label(lab1),
		       movel(L (49152+4,n),@+ 2),
		       movel(A 2,A 0) ] @ cd ,A0,cst+100+4+12+4+4)
	    end;
	    
	    
	fun OpRecClosure (INT2(n,m)) = 
	    let
		val (cd,cst)=Loop_use(n,[movel(@+ 5,@+ 0)],20) (* n or n-1*)
	    in
		(SK,[movel(@$(5,m*4),A 0)] @ cd ,SK,cst+4+16)
	    end;
	    
in

    usefun	60	OpClosure;
    usefun	61	OpDumClosure;
    usefun	62	OpRecClosure;
    (* * *) outline "Closure Operations" (* * *)
end;

(****

(*
 * String stuff 
 *
 *)

val _ = let
 	fun OpEqString _ = 
	let 
		val lab1 = getNClabel()
		val lab2 = getNClabel()
		val lab3 = getNClabel()
	in
		(A0,>>
		   (*"movel  *)movel((*a5@+ *)@+ 5,(*a1 *)A 1"   (* 2nd arg goes into (*a1 *)A 1,1st in (*a0 *)A 0 *)
		|> (*"movel  *)movel((*d7 *)D 7,(*d0 *)D 0"
		|> (*"movew  *)movew((*a0@( *)@$(0-0x2:w),(*d1 *)D 1"   (* the 1st len *)
		|> (*"cmpw  *)cmpw((*a1@( *)@$(1-0x2:w),(*d1 *)D 1"    (* cmp lengths *)
		|> "bne "^lab1		   (* false if different *)
		|> (*"tstw  *)tstw((*d1 *)D 1"
		|> "beq "^lab3		   (* true if both "" *)
		|> (*"extl  *)extl((*d1 *)D 1"
		|> "subql #0x1,(*d1 *)D 1"
		|| lab2^":"
		|> (*"cmpmb  *)cmpmb((*a0@+ *)@+ 0,(*a1@+ *)@+ 1"	   (* compare all values ... *)
		|> "dbne (*d1 *)D 1,"^lab2
		|> "bne "^lab1		   (* false if ever different *)
		|| lab3^":"
		|> "addql #0x1,(*d0 *)D 0"	   (* Ahh, a true *)
		|| lab1^":",D0)
	end;

 	fun OpDestString (INT x) = 
	let 
		val lab1 = getNClabel()
		val lab2 = getNClabel()
		val lab3 = getNClabel()
	in
		(A0,>>
		   (*"movel  *)movel((*a5@( *)@$(50x"^Hex(x*4,4)^":w),(*a1 *)A 1"
		|> (*"movew  *)movew((*a0@( *)@$(0-0x2:w),(*d1 *)D 1"   (* the 1st len *)
		|> (*"cmpw  *)cmpw((*a1@( *)@$(1-0x2:w),(*d1 *)D 1"    (* cmp lengths *)
		|> "bne "^lab3		   (* false if different *)
		|> (*"tstw  *)tstw((*d1 *)D 1"
		|> "beq "^lab1		   (* true if both "" *)
		|> (*"extl  *)extl((*d1 *)D 1"
		|> "subql #0x1,(*d1 *)D 1"
		|| lab2^":"
		|> (*"cmpmb  *)cmpmb((*a0@+ *)@+ 0,(*a1@+ *)@+ 1"	   (* compare all values ... *)
		|> "dbne (*d1 *)D 1,"^lab2
		|> "beq "^lab1		   (* false if ever different *)
		|| lab3^":"
		|> NCraise(17)  (* correct again, so raise the roof *)
		|| lab1^":",SK)

	end
(*
 	fun OpStringLEQ _ =  (* one day ... *)
	let 
		val lab1 = getNClabel()
		val lab2 = getNClabel()
		val lab3 = getNClabel()
	in
		(A0,>>
		   (*"movel  *)movel((*a5@+ *)@+ 5,(*a1 *)A 1"   (* 2nd arg goes into (*a1 *)A 1,1st in (*a0 *)A 0 *)
		|> (*"movel  *)movel((*d7 *)D 7,(*d0 *)D 0"
		|> (*"movew  *)movew((*a0@( *)@$(0-0x2:w),(*d1 *)D 1"   (* the 1st len *)
		|> (*"cmpw  *)cmpw((*a1@( *)@$(1-0x2:w),(*d1 *)D 1"    (* cmp lengths *)
		|> "bne "^lab1		   (* false if different *)
		|> (*"tstw  *)tstw((*d1 *)D 1"
		|> "beq "^lab3		   (* true if both "" *)
		|> (*"extl  *)extl((*d1 *)D 1"
		|> "subql #0x1,(*d1 *)D 1"
		|| lab2^":"
		|> (*"cmpmb  *)cmpmb((*a0@+ *)@+ 0,(*a1@+ *)@+ 1"	   (* compare all values ... *)
		|> "dbgt (*d1 *)D 1,"^lab2
		|> "bgt "^lab1		   (* false if ever different *)
		|| lab3^":"
		|> "addql #0x1,(*d0 *)D 0"	   (* Ahh, a true *)
		|| lab1^":",D0)
	end;
*)
in
(*
    UseFun	43	OpEqString;
    UseFun	204	OpDestString;
(*	val _ = InsertC 107 (OpStringLEQ) (K "OpStringLEQ");*)
*)    (* * *) outline "String Operations" (* * *)

end;
*)

local
    val SKD0 = movel (@+ 5,D 0);
    val SKA0 = movel (@+ 5,A 0);
    val D0SK = movel (D 0,@- 5);
    val D0A0 = movel (D 0,A 0);
    val A0SK = movel (A 0,@- 5);
    val A0D0 = movel (A 0,D 0);
in
    fun (* native *)InterboundLabel(inp,out,lab) = 
	if lab < 0 
	    then ([],0)
	else
	    let 
		val l = label ("FAM_"^ ($lab));
	    in
		jumpcase inp of
		SK => (case out of
		       SK => ([l],0)
		     | D0 => ([l,SKD0],12)
		     | A0 => ([l,SKA0],12)
(*		     | ANY f => ([l,f (@+ 5)],8)
*)			)

	      | D0 => (case out of
		       SK => ([D0SK,l],12)
		     | D0 => ([D0SK,l,SKD0],14+12)
		     | A0 => ([D0SK,l,SKA0],14+12)
(*		     | ANY f => ([DOSK,l,f (@+ 5)],8)
*)			)

	      | A0 => (case out of 
		       SK => ([A0SK,l],14)
		     | D0 => ([A0SK,l,SKD0],14+12)
		     | A0 => ([A0SK,l,SKA0],14+12)
(*		     | ANY f => ([AOSK,l,f (@+ 5)],8)
*)			   )
    
	      | ANY f => (case out of
			  SK => ([f (@- 5),l],8)
			| D0 => ([f (@- 5),l,SKD0],8+14)
			| A0 => ([f (@- 5),l,SKA0],8+14)
(*			| ANY g => ([f (@- 5),l,g (@+ 5)],8+8)
*)			      )
	    end;


    fun (*native*) Interbound(inp,out) = jumpcase inp of
			  SK => (case out of
				 SK => ([],0)
			       | D0 => ([SKD0],12)
			       | A0 => ([SKA0],12)
(*			       | ANY f => ([f (@+ 5)],8)
*)				     )
					 
			| D0 => (case out of
				 SK => ([D0SK],12)
			       | D0 => ([],0)
			       | A0 => ([D0A0],4)
(*			       | ANY f => ([f (D 0)],0)
*)				  )
					 
			| A0 => (case out of 
				 SK => ([A0SK],12)
			       | D0 => ([A0D0],4)
			       | A0 => ([],0)
(*			       | ANY f => ([f (A 0)],0)
*)					 )

			| ANY f => (case out of
				    SK => ([f (@- 5)],8)
				  | D0 => ([f (D 0)],0)
				  | A0 => ([f (A 0)],0)
(*				  | ANY g => ([f (D 0),g (D 0)],0)
*)					);
				  
end;
(*
 *   scoring for ANY = presume moving into d0, and add to total code score 
 *)	     

fun Link(x,y,l,b) = 
    if b 
	then InterboundLabel(x,y,l)
    else Interbound(x,y);



(*
 *  This table is all the rest of the NCG should need to see of
 *  the 68K specific parts 
 *
 *)

in

val NativeCoder = {
		   LabelOrder = (fn (x,y:LAB) => (x < y)),

		   Linker = Link,  (* bridging domino *)
		   Assembler = (fn x => if !(#Regression Ncopt) 
				   then UseUnixAss x
			       else MLAssembler x),
		   DefLink = Default_Bound, (* default binding *)
		   Byte_Insertion = Byte_Code_Insert, 
		   ResetNCLabels = ResetNCLabels,
		   HeapType = 514 (* the heap type 0x0202 *)
		   };


end;
