syntax nonfix NewProcess 130 3;
syntax nonfix NewState 151 1;
syntax nonfix SmashProcess 114 1;
syntax nonfix SmashState 152 1;
syntax nonfix CurrentState 153 0;
syntax nonfix ExportState 113 2;
syntax nonfix ExportCurrentState 158 1;
syntax nonfix CurrentProcess 129 0;
syntax nonfix SpawnProcess 148 2;
syntax nonfix WaitForProcess 132 1;
syntax nonfix WaitForProcesses 155 1;
syntax nonfix SuspendProcess 131 1;
syntax nonfix StopProcess 82 1;
syntax nonfix RescheduleProcess 150 1;

syntax nonfix ReturnStack 133 1;
syntax nonfix CurrentFrame 134 1;
syntax nonfix TrapStack 135 1;
syntax nonfix ArgStack 154 1;

let type process = 
  (|ANextProc: void;
    ArgStk: void;
    CtlStk: void;
    CtrlCEnabled: void;
    Env: void;
    Father: void;
    Frame: void;
    WaitingFor: void
  |);


let rec NewProcess((f:void -> void),
                    argstacksize: int, ctlstacksize: int):process =
            NewProcess(f,argstacksize, ctlstacksize)
 and rec SmashProcess(p: process):void = SmashProcess(p)
 and rec CurrentProcess():process = CurrentProcess()
 and rec SpawnProcess(p: process, o: bool):void = SpawnProcess(p,o)
 and rec WaitForProcess(p:process):process = WaitForProcess(p)
 and rec WaitForProcesses(_):void = WaitForProcesses()
 and rec SuspendProcess(_):void = SuspendProcess()
 and rec StopProcess(_): void = StopProcess()
 and rec RescheduleProcess(_): void = RescheduleProcess()
 and rec CurrentFrame(s:process): object = CurrentFrame(s)
 and rec ReturnStack(s:process): object array = ReturnStack(s)
 and rec TrapStack(s:process): (string list # object) array = TrapStack(s)
 and rec ArgStack(s:process): object array = ArgStack(s);

let type state = 
  (|ActiveStreams: void;
    BuiltInExceptions: string ref array;
    EmptyTok: string;
    EmptyArray: void array;
%    DynamicTextList:     ref (|text list|);%
    StartupClosure: closure;
    FunIdClosure: closure;
    FunCompText: text;
    XConText: text;
    WaitingProcesses: void; 
    StdIn: instream;
    StdOut: outstream;
    StdErr: outstream;
    GCMsgs: bool ref;
    CompactGC: bool ref
  |);

let rec NewState(pl: process list): state = NewState(pl)
and rec SmashState(s:state):void = SmashState(s)
and rec CurrentState():state = CurrentState()
and rec ExportCurrentState(f: string):bool = ExportCurrentState(f)
and rec ExportState(f: string, s: state):bool = ExportState(f,s);

let StopProcess() = (WaitForProcesses(); StopProcess());

let resume(p) = (SpawnProcess(p,true); WaitForProcess(p));
let detach() = SuspendProcess();
