/*
 * Decompiled with CFR 0.152.
 */
package raytrace;

import com.sun.opengl.util.texture.Texture;
import com.sun.opengl.util.texture.TextureCoords;
import com.sun.opengl.util.texture.TextureData;
import com.sun.opengl.util.texture.TextureIO;
import framework.M3d;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.media.opengl.GL;
import javax.media.opengl.GLException;
import raytrace.engine.RGBCanvas;

public class GLTextureCanvas
implements RGBCanvas {
    BufferedImage image;
    Graphics2D imageAccessor;
    Texture texture = null;
    TextureCoords frame;

    public GLTextureCanvas(int width, int height) {
        this.image = new BufferedImage(width, height, 5);
        this.imageAccessor = this.image.createGraphics();
    }

    @Override
    public void fill(double x, double y, double dx, double dy, M3d color) {
        float r = Math.max(Math.min((float)color.get(0), 1.0f), 0.0f);
        float g = Math.max(Math.min((float)color.get(1), 1.0f), 0.0f);
        float b = Math.max(Math.min((float)color.get(2), 1.0f), 0.0f);
        this.imageAccessor.setColor(new Color(r, g, b));
        this.imageAccessor.fillRect((int)x, (int)y, (int)dx, (int)dy);
    }

    public void clear() {
        this.imageAccessor.setColor(new Color(1, 1, 1));
        this.imageAccessor.fillRect(0, 0, this.image.getWidth(), this.image.getHeight());
    }

    @Override
    public int getWidth() {
        return this.image.getWidth();
    }

    @Override
    public int getHeight() {
        return this.image.getHeight();
    }

    public void render(GL gl) {
        if (this.texture == null) {
            gl.glTexParameteri(3553, 10241, 9729);
            this.texture = TextureIO.newTexture((BufferedImage)this.image, (boolean)false);
            this.texture.bind();
            this.texture.enable();
            this.frame = this.texture.getImageTexCoords();
        } else {
            this.texture.updateImage(new TextureData(0, 0, false, this.image));
        }
        gl.glBegin(7);
        gl.glTexCoord2f(this.frame.left(), this.frame.top());
        gl.glVertex3f(-0.5f, -0.5f, 0.0f);
        gl.glTexCoord2f(this.frame.left(), this.frame.bottom());
        gl.glVertex3f(-0.5f, 0.5f, 0.0f);
        gl.glTexCoord2f(this.frame.right(), this.frame.bottom());
        gl.glVertex3f(0.5f, 0.5f, 0.0f);
        gl.glTexCoord2f(this.frame.right(), this.frame.top());
        gl.glVertex3f(0.5f, -0.5f, 0.0f);
        gl.glEnd();
    }

    public void write(GL gl, String filename) {
        try {
            TextureIO.write((Texture)this.texture, (File)new File(filename));
        }
        catch (GLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

