/*
 * Decompiled with CFR 0.152.
 */
package framework;

public class MathUtil {
    public static boolean IsZero(double r) {
        return Math.abs(r) <= 1.0E-6;
    }

    public static double cbrt(double x) {
        return x > 0.0 ? Math.pow(x, 0.3333333333333333) : (x < 0.0 ? -Math.pow(-x, 0.3333333333333333) : 0.0);
    }

    public static double sqr(double x) {
        return Math.pow(x, 2.0);
    }

    public static int SolveQuadric(double[] c, double[] s) {
        double p = c[1] / (2.0 * c[2]);
        double q = c[0] / c[2];
        double D = p * p - q;
        if (MathUtil.IsZero(D)) {
            s[0] = -p;
            return 1;
        }
        if (D < 0.0) {
            return 0;
        }
        double sqrt_D = Math.sqrt(D);
        s[0] = sqrt_D - p;
        s[1] = -sqrt_D - p;
        return 2;
    }

    public static int SolveCubic(double[] c, double[] s) {
        int num;
        double A = c[2] / c[3];
        double sq_A = A * A;
        double B = c[1] / c[3];
        double C = c[0] / c[3];
        double q = 0.5 * (0.07407407407407407 * A * sq_A - 0.3333333333333333 * A * B + C);
        double p = 0.3333333333333333 * (-0.3333333333333333 * sq_A + B);
        double cb_p = p * p * p;
        double D = q * q + cb_p;
        if (MathUtil.IsZero(D)) {
            if (MathUtil.IsZero(q)) {
                s[0] = 0.0;
                num = 1;
            } else {
                double u = MathUtil.cbrt(-q);
                s[0] = 2.0 * u;
                s[1] = -u;
                num = 2;
            }
        } else if (D < 0.0) {
            double phi = 0.3333333333333333 * Math.acos(-q / Math.sqrt(-cb_p));
            double t = 2.0 * Math.sqrt(-p);
            s[0] = t * Math.cos(phi);
            s[1] = -t * Math.cos(phi + 1.0471975511965976);
            s[2] = -t * Math.cos(phi - 1.0471975511965976);
            num = 3;
        } else {
            double sqrt_D = Math.sqrt(D);
            double u = MathUtil.cbrt(sqrt_D - q);
            double v = -MathUtil.cbrt(sqrt_D + q);
            s[0] = u + v;
            num = 1;
        }
        double sub = 0.3333333333333333 * A;
        int i = 0;
        while (i < num) {
            int n = i++;
            s[n] = s[n] - sub;
        }
        return num;
    }

    public static int SolveQuartic(double[] c, double[] s) {
        int num;
        double[] coeffs = new double[4];
        double A = c[3] / c[4];
        double B = c[2] / c[4];
        double C = c[1] / c[4];
        double D = c[0] / c[4];
        double sq_A = A * A;
        double p = -0.375 * sq_A + B;
        double q = 0.125 * sq_A * A - 0.5 * A * B + C;
        double r = -0.01171875 * sq_A * sq_A + 0.0625 * sq_A * B - 0.25 * A * C + D;
        if (MathUtil.IsZero(r)) {
            coeffs[0] = q;
            coeffs[1] = p;
            coeffs[2] = 0.0;
            coeffs[3] = 1.0;
            num = MathUtil.SolveCubic(coeffs, s);
            s[num++] = 0.0;
        } else {
            coeffs[0] = 0.5 * r * p - 0.125 * q * q;
            coeffs[1] = -r;
            coeffs[2] = -0.5 * p;
            coeffs[3] = 1.0;
            MathUtil.SolveCubic(coeffs, s);
            double z = s[0];
            double u = z * z - r;
            double v = 2.0 * z - p;
            if (MathUtil.IsZero(u)) {
                u = 0.0;
            } else if (u > 0.0) {
                u = Math.sqrt(u);
            } else {
                return 0;
            }
            if (MathUtil.IsZero(v)) {
                v = 0.0;
            } else if (v > 0.0) {
                v = Math.sqrt(v);
            } else {
                return 0;
            }
            coeffs[0] = z - u;
            coeffs[1] = q < 0.0 ? -v : v;
            coeffs[2] = 1.0;
            num = MathUtil.SolveQuadric(coeffs, s);
            coeffs[0] = z + u;
            coeffs[1] = q < 0.0 ? v : -v;
            coeffs[2] = 1.0;
            double[] s2 = new double[2];
            int n2 = MathUtil.SolveQuadric(coeffs, s2);
            int j = 0;
            while (j < n2) {
                s[num + j] = s2[j];
                ++j;
            }
            num += n2;
        }
        double sub = 0.25 * A;
        int i = 0;
        while (i < num) {
            int n = i++;
            s[n] = s[n] - sub;
        }
        return num;
    }
}

