/*
 * Decompiled with CFR 0.152.
 */
package blobby.engine;

import blobby.engine.ImplicitSurface;
import blobby.engine.OctTreeEdge;
import framework.M3d;
import framework.SimpleMesh;
import java.util.LinkedList;
import java.util.List;

public class Octree
extends SimpleMesh {
    private static final int[][][] tetrahedra;
    private static final int[][][] faces;
    private int level;
    private M3d[][][] corners;
    private LinkedList<M3d> targets;
    private Octree[][][] children;
    private ImplicitSurface surface;
    private Octree[] neighbors;

    static {
        int[][][] nArrayArray = new int[5][][];
        int[][] nArrayArray2 = new int[4][];
        nArrayArray2[0] = new int[3];
        int[] nArray = new int[3];
        nArray[1] = 1;
        nArray[2] = 1;
        nArrayArray2[1] = nArray;
        int[] nArray2 = new int[3];
        nArray2[0] = 1;
        nArray2[2] = 1;
        nArrayArray2[2] = nArray2;
        int[] nArray3 = new int[3];
        nArray3[0] = 1;
        nArray3[1] = 1;
        nArrayArray2[3] = nArray3;
        nArrayArray[0] = nArrayArray2;
        int[][] nArrayArray3 = new int[4][];
        nArrayArray3[0] = new int[3];
        int[] nArray4 = new int[3];
        nArray4[2] = 1;
        nArrayArray3[1] = nArray4;
        int[] nArray5 = new int[3];
        nArray5[0] = 1;
        nArray5[2] = 1;
        nArrayArray3[2] = nArray5;
        int[] nArray6 = new int[3];
        nArray6[1] = 1;
        nArray6[2] = 1;
        nArrayArray3[3] = nArray6;
        nArrayArray[1] = nArrayArray3;
        int[][] nArrayArray4 = new int[4][];
        int[] nArray7 = new int[3];
        nArray7[0] = 1;
        nArray7[1] = 1;
        nArrayArray4[0] = nArray7;
        int[] nArray8 = new int[3];
        nArray8[1] = 1;
        nArray8[2] = 1;
        nArrayArray4[1] = nArray8;
        int[] nArray9 = new int[3];
        nArray9[0] = 1;
        nArray9[2] = 1;
        nArrayArray4[2] = nArray9;
        nArrayArray4[3] = new int[]{1, 1, 1};
        nArrayArray[2] = nArrayArray4;
        int[][] nArrayArray5 = new int[4][];
        nArrayArray5[0] = new int[3];
        int[] nArray10 = new int[3];
        nArray10[1] = 1;
        nArray10[2] = 1;
        nArrayArray5[1] = nArray10;
        int[] nArray11 = new int[3];
        nArray11[1] = 1;
        nArrayArray5[2] = nArray11;
        int[] nArray12 = new int[3];
        nArray12[0] = 1;
        nArray12[1] = 1;
        nArrayArray5[3] = nArray12;
        nArrayArray[3] = nArrayArray5;
        int[][] nArrayArray6 = new int[4][];
        nArrayArray6[0] = new int[3];
        int[] nArray13 = new int[3];
        nArray13[0] = 1;
        nArrayArray6[1] = nArray13;
        int[] nArray14 = new int[3];
        nArray14[0] = 1;
        nArray14[2] = 1;
        nArrayArray6[2] = nArray14;
        int[] nArray15 = new int[3];
        nArray15[0] = 1;
        nArray15[1] = 1;
        nArrayArray6[3] = nArray15;
        nArrayArray[4] = nArrayArray6;
        tetrahedra = nArrayArray;
        int[][][] nArrayArray7 = new int[6][][];
        int[][] nArrayArray8 = new int[4][];
        int[] nArray16 = new int[3];
        nArray16[2] = 1;
        nArrayArray8[0] = nArray16;
        int[] nArray17 = new int[3];
        nArray17[0] = 1;
        nArray17[2] = 1;
        nArrayArray8[1] = nArray17;
        nArrayArray8[2] = new int[]{1, 1, 1};
        int[] nArray18 = new int[3];
        nArray18[1] = 1;
        nArray18[2] = 1;
        nArrayArray8[3] = nArray18;
        nArrayArray7[0] = nArrayArray8;
        int[][] nArrayArray9 = new int[4][];
        int[] nArray19 = new int[3];
        nArray19[1] = 1;
        nArrayArray9[0] = nArray19;
        nArrayArray9[1] = new int[3];
        int[] nArray20 = new int[3];
        nArray20[2] = 1;
        nArrayArray9[2] = nArray20;
        int[] nArray21 = new int[3];
        nArray21[1] = 1;
        nArray21[2] = 1;
        nArrayArray9[3] = nArray21;
        nArrayArray7[1] = nArrayArray9;
        int[][] nArrayArray10 = new int[4][];
        int[] nArray22 = new int[3];
        nArray22[1] = 1;
        nArray22[2] = 1;
        nArrayArray10[0] = nArray22;
        nArrayArray10[1] = new int[]{1, 1, 1};
        int[] nArray23 = new int[3];
        nArray23[0] = 1;
        nArray23[1] = 1;
        nArrayArray10[2] = nArray23;
        int[] nArray24 = new int[3];
        nArray24[1] = 1;
        nArrayArray10[3] = nArray24;
        nArrayArray7[2] = nArrayArray10;
        int[][] nArrayArray11 = new int[4][];
        int[] nArray25 = new int[3];
        nArray25[2] = 1;
        nArrayArray11[0] = nArray25;
        int[] nArray26 = new int[3];
        nArray26[0] = 1;
        nArray26[2] = 1;
        nArrayArray11[1] = nArray26;
        int[] nArray27 = new int[3];
        nArray27[0] = 1;
        nArrayArray11[2] = nArray27;
        nArrayArray11[3] = new int[3];
        nArrayArray7[3] = nArrayArray11;
        int[][] nArrayArray12 = new int[4][];
        int[] nArray28 = new int[3];
        nArray28[0] = 1;
        nArray28[2] = 1;
        nArrayArray12[0] = nArray28;
        int[] nArray29 = new int[3];
        nArray29[0] = 1;
        nArrayArray12[1] = nArray29;
        int[] nArray30 = new int[3];
        nArray30[0] = 1;
        nArray30[1] = 1;
        nArrayArray12[2] = nArray30;
        nArrayArray12[3] = new int[]{1, 1, 1};
        nArrayArray7[4] = nArrayArray12;
        int[][] nArrayArray13 = new int[4][];
        int[] nArray31 = new int[3];
        nArray31[0] = 1;
        nArrayArray13[0] = nArray31;
        nArrayArray13[1] = new int[3];
        int[] nArray32 = new int[3];
        nArray32[1] = 1;
        nArrayArray13[2] = nArray32;
        int[] nArray33 = new int[3];
        nArray33[0] = 1;
        nArray33[1] = 1;
        nArrayArray13[3] = nArray33;
        nArrayArray7[5] = nArrayArray13;
        faces = nArrayArray7;
    }

    Octree(ImplicitSurface surface, int level, M3d[][][] coords, int x, int y, int z, List<M3d> possibleTargets) {
        boolean isOdd = (x + y + z & 1) != 0;
        this.surface = surface;
        this.level = level;
        this.corners = new M3d[2][2][2];
        this.targets = new LinkedList();
        this.neighbors = new Octree[6];
        int i = 0;
        while (i < 2) {
            int j = 0;
            while (j < 2) {
                int k = 0;
                while (k < 2) {
                    this.corners[i][j][k] = coords[x + i][y + j][z + k];
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        for (M3d pt : possibleTargets) {
            if (!this.encloses(pt)) continue;
            this.targets.add(pt);
        }
        if (this.level == surface.getTargetLevel()) {
            i = 0;
            while (i < tetrahedra.length) {
                int crossings = 0;
                OctTreeEdge[] arr = new OctTreeEdge[4];
                int[][] tet = tetrahedra[i];
                int j = 0;
                while (j < tet.length) {
                    int k = j + 1;
                    while (k < tet.length) {
                        M3d A = this.corners[tet[j][0]][isOdd ? 1 - tet[j][1] : tet[j][1]][tet[j][2]];
                        M3d B = this.corners[tet[k][0]][isOdd ? 1 - tet[k][1] : tet[k][1]][tet[k][2]];
                        if (surface.isHot(A) != surface.isHot(B)) {
                            arr[crossings++] = surface.requireEdge(A, B, null);
                        }
                        ++k;
                    }
                    ++j;
                }
                if (crossings == 4) {
                    boolean zeroOneAdjacent = arr[0].hasSharedEndPoint(arr[1]);
                    OctTreeEdge a = arr[0];
                    OctTreeEdge b = zeroOneAdjacent ? arr[1] : arr[2];
                    OctTreeEdge c = zeroOneAdjacent ? arr[2] : arr[1];
                    OctTreeEdge d = arr[3];
                    this.addPolyWithOrientation(a.getInterpolatedVertex(), b.getInterpolatedVertex(), c.getInterpolatedVertex(), arr[0].getNormalDir());
                    this.addPolyWithOrientation(b.getInterpolatedVertex(), c.getInterpolatedVertex(), d.getInterpolatedVertex(), arr[0].getNormalDir());
                } else if (crossings == 3) {
                    this.addPolyWithOrientation(arr[0].getInterpolatedVertex(), arr[1].getInterpolatedVertex(), arr[2].getInterpolatedVertex(), arr[0].getNormalDir());
                }
                ++i;
            }
        }
    }

    void addTarget(M3d pt) {
        this.targets.add(pt);
    }

    boolean encloses(M3d pt) {
        return pt.getX() >= this.corners[0][0][0].getX() && pt.getX() <= this.corners[1][1][1].getX() && pt.getY() >= this.corners[0][0][0].getY() && pt.getY() <= this.corners[1][1][1].getY() && pt.getZ() >= this.corners[0][0][0].getZ() && pt.getZ() <= this.corners[1][1][1].getZ();
    }

    boolean isInteresting() {
        if (!this.targets.isEmpty()) {
            return true;
        }
        boolean first = this.surface.isHot(this.corners[0][0][0]);
        int i = 0;
        while (i < 2) {
            int j = 0;
            while (j < 2) {
                int k = 0;
                while (k < 2) {
                    if (this.surface.isHot(this.corners[i][j][k]) != first) {
                        return true;
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    boolean hasInterestingFace(int faceIndex) {
        int[] firstFaceCorner = faces[faceIndex][0];
        boolean first = this.surface.isHot(this.corners[firstFaceCorner[0]][firstFaceCorner[1]][firstFaceCorner[2]]);
        int i = 1;
        while (i < 4) {
            int[] corner = faces[faceIndex][i];
            if (this.surface.isHot(this.corners[corner[0]][corner[1]][corner[2]]) != first) {
                return true;
            }
            ++i;
        }
        return false;
    }

    M3d getPointJustBeyondFace(int faceIndex) {
        M3d faceCenter = new M3d();
        M3d center = this.corners[0][0][0].plus(this.corners[1][1][1]).times(0.5);
        int i = 0;
        while (i < 4) {
            int[] corner = faces[faceIndex][i];
            M3d pt = this.corners[corner[0]][corner[1]][corner[2]];
            faceCenter = faceCenter.plus(pt);
            ++i;
        }
        faceCenter = faceCenter.times(0.25);
        return center.plus(faceCenter.minus(center).times(1.1));
    }

    M3d[][][] makeSubCorners() {
        int j;
        M3d[][][] subCorners = new M3d[3][3][3];
        int i = 0;
        while (i < 2) {
            j = 0;
            while (j < 2) {
                int k = 0;
                while (k < 2) {
                    subCorners[i * 2][j * 2][k * 2] = this.corners[i][j][k];
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i <= 2) {
            j = 0;
            while (j <= 2) {
                subCorners[1][i][j] = this.surface.subdivideEdge(subCorners[0][i][j], subCorners[2][i][j], null);
                subCorners[i][1][j] = this.surface.subdivideEdge(subCorners[i][0][j], subCorners[i][2][j], null);
                subCorners[i][j][1] = this.surface.subdivideEdge(subCorners[i][j][0], subCorners[i][j][2], null);
                j += 2;
            }
            i += 2;
        }
        i = 0;
        while (i <= 2) {
            subCorners[i][1][1] = this.surface.subdivideFace(subCorners[i][0][1], subCorners[i][2][1], subCorners[i][1][0], subCorners[i][1][2]);
            subCorners[1][i][1] = this.surface.subdivideFace(subCorners[0][i][1], subCorners[2][i][1], subCorners[1][i][0], subCorners[1][i][2]);
            subCorners[1][1][i] = this.surface.subdivideFace(subCorners[1][0][i], subCorners[1][2][i], subCorners[0][1][i], subCorners[2][1][i]);
            i += 2;
        }
        subCorners[1][1][1] = this.surface.subdivideCube(subCorners[0][1][1], subCorners[2][1][1], subCorners[1][0][1], subCorners[1][2][1], subCorners[1][1][0], subCorners[1][1][2]);
        return subCorners;
    }

    int getLevel() {
        return this.level;
    }

    public M3d[][][] getCorners() {
        return this.corners;
    }

    Octree[][][] getChildOctrees() {
        return this.children;
    }

    Octree getNeighbor(int faceIndex) {
        return this.neighbors[faceIndex];
    }

    void setNeighbor(int faceIndex, Octree o) {
        this.neighbors[faceIndex] = o;
    }

    void refine() {
        M3d[][][] subCorners = this.makeSubCorners();
        if (this.children == null) {
            this.children = new Octree[2][2][2];
        }
        int i = 0;
        while (i < 2) {
            int j = 0;
            while (j < 2) {
                int k = 0;
                while (k < 2) {
                    Octree child;
                    if (this.children[i][j][k] == null && (child = new Octree(this.surface, this.level + 1, subCorners, i, j, k, this.targets)).isInteresting()) {
                        this.children[i][j][k] = child;
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }
}

