/*
 * Decompiled with CFR 0.152.
 */
package blobby;

import blobby.engine.ImplicitSurface;
import blobby.engine.ImplicitSurfaceRenderer;
import blobby.engine.MetaBall;
import framework.M3d;
import framework.Renderer;
import java.awt.event.KeyEvent;
import javax.media.opengl.GL;
import javax.media.opengl.GLAutoDrawable;

public class BlobbyDemo
extends Renderer {
    boolean paused = false;
    double d = 0.0;
    ImplicitSurface surface;
    ImplicitSurfaceRenderer surfaceRenderer;
    MetaBall mover;
    long then = 0L;

    @Override
    public String getTitle() {
        return "Blobby Demo";
    }

    @Override
    public void init(GLAutoDrawable glDrawable) {
        GL gl = glDrawable.getGL();
        super.init(glDrawable);
        gl.glEnable(10754);
        gl.glPolygonOffset(0.0f, -100.0f);
        this.showAxes = false;
        this.cameraDistance = 12.0f;
        this.surface = new ImplicitSurface(new M3d(-10.0, -10.0, -10.0), new M3d(10.0, 10.0, 10.0), 5);
        this.mover = new MetaBall(0.0, 0.0, 0.0, 1.0);
        this.surface.addForce(this.mover);
        this.surface.addForce(new MetaBall(-4.0, 0.0, 0.0, 1.0));
        this.surfaceRenderer = new ImplicitSurfaceRenderer(this.surface);
    }

    @Override
    public void keyPressed(KeyEvent e) {
        switch (e.getKeyCode()) {
            case 32: {
                this.paused = !this.paused;
                break;
            }
            case 66: {
                this.surfaceRenderer.setShowBoxes(!this.surfaceRenderer.getShowBoxes());
                break;
            }
            case 69: {
                this.surfaceRenderer.setShowEdges(!this.surfaceRenderer.getShowEdges());
                break;
            }
            case 49: {
                this.surface.setTargetLevel(1);
                break;
            }
            case 50: {
                this.surface.setTargetLevel(2);
                break;
            }
            case 51: {
                this.surface.setTargetLevel(3);
                break;
            }
            case 52: {
                this.surface.setTargetLevel(4);
                break;
            }
            case 53: {
                this.surface.setTargetLevel(5);
                break;
            }
            case 54: {
                this.surface.setTargetLevel(6);
                break;
            }
            case 55: {
                this.surface.setTargetLevel(7);
                break;
            }
            case 56: {
                this.surface.setTargetLevel(8);
                break;
            }
            default: {
                super.keyPressed(e);
            }
        }
    }

    public void display(GLAutoDrawable glDrawable) {
        GL gl = glDrawable.getGL();
        long now = System.currentTimeMillis();
        if (this.then == 0L) {
            this.then = now;
        }
        this.preDisplay(glDrawable);
        if (!this.paused) {
            this.mover.setX(4.0 * Math.cos(this.d));
            this.d += (double)(now - this.then) * 15.0 / 1000.0 * 3.141592 / 64.0;
            this.surface.reset();
            this.surface.refine();
        }
        this.then = now;
        this.surfaceRenderer.render(gl);
        this.postDisplay(glDrawable);
    }
}

