/*
 * Decompiled with CFR 0.152.
 */
package delaunay;

public class Pnt {
    private double[] coordinates;

    public Pnt(double ... coords) {
        this.coordinates = new double[coords.length];
        System.arraycopy(coords, 0, this.coordinates, 0, coords.length);
    }

    public String toString() {
        if (this.coordinates.length == 0) {
            return "Pnt()";
        }
        String result = "Pnt(" + this.coordinates[0];
        int i = 1;
        while (i < this.coordinates.length) {
            result = String.valueOf(result) + "," + this.coordinates[i];
            ++i;
        }
        result = String.valueOf(result) + ")";
        return result;
    }

    public boolean equals(Object other) {
        if (!(other instanceof Pnt)) {
            return false;
        }
        Pnt p = (Pnt)other;
        if (this.coordinates.length != p.coordinates.length) {
            return false;
        }
        int i = 0;
        while (i < this.coordinates.length) {
            if (this.coordinates[i] != p.coordinates[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int hashCode() {
        int hash = 0;
        double[] dArray = this.coordinates;
        int n = this.coordinates.length;
        int n2 = 0;
        while (n2 < n) {
            double c = dArray[n2];
            long bits = Double.doubleToLongBits(c);
            hash = 31 * hash ^ (int)(bits ^ bits >> 32);
            ++n2;
        }
        return hash;
    }

    public double coord(int i) {
        return this.coordinates[i];
    }

    public int dimension() {
        return this.coordinates.length;
    }

    public int dimCheck(Pnt p) {
        int len = this.coordinates.length;
        if (len != p.coordinates.length) {
            throw new IllegalArgumentException("Dimension mismatch");
        }
        return len;
    }

    public Pnt extend(double ... coords) {
        double[] result = new double[this.coordinates.length + coords.length];
        System.arraycopy(this.coordinates, 0, result, 0, this.coordinates.length);
        System.arraycopy(coords, 0, result, this.coordinates.length, coords.length);
        return new Pnt(result);
    }

    public double dot(Pnt p) {
        int len = this.dimCheck(p);
        double sum = 0.0;
        int i = 0;
        while (i < len) {
            sum += this.coordinates[i] * p.coordinates[i];
            ++i;
        }
        return sum;
    }

    public double magnitude() {
        return Math.sqrt(this.dot(this));
    }

    public Pnt subtract(Pnt p) {
        int len = this.dimCheck(p);
        double[] coords = new double[len];
        int i = 0;
        while (i < len) {
            coords[i] = this.coordinates[i] - p.coordinates[i];
            ++i;
        }
        return new Pnt(coords);
    }

    public Pnt add(Pnt p) {
        int len = this.dimCheck(p);
        double[] coords = new double[len];
        int i = 0;
        while (i < len) {
            coords[i] = this.coordinates[i] + p.coordinates[i];
            ++i;
        }
        return new Pnt(coords);
    }

    public double angle(Pnt p) {
        return Math.acos(this.dot(p) / (this.magnitude() * p.magnitude()));
    }

    public Pnt bisector(Pnt point) {
        this.dimCheck(point);
        Pnt diff = this.subtract(point);
        Pnt sum = this.add(point);
        double dot = diff.dot(sum);
        return diff.extend(-dot / 2.0);
    }

    public static String toString(Pnt[] matrix) {
        StringBuilder buf = new StringBuilder("{");
        Pnt[] pntArray = matrix;
        int n = matrix.length;
        int n2 = 0;
        while (n2 < n) {
            Pnt row = pntArray[n2];
            buf.append(" " + row);
            ++n2;
        }
        buf.append(" }");
        return buf.toString();
    }

    public static double determinant(Pnt[] matrix) {
        if (matrix.length != matrix[0].dimension()) {
            throw new IllegalArgumentException("Matrix is not square");
        }
        boolean[] columns = new boolean[matrix.length];
        int i = 0;
        while (i < matrix.length) {
            columns[i] = true;
            ++i;
        }
        try {
            return Pnt.determinant(matrix, 0, columns);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IllegalArgumentException("Matrix is wrong shape");
        }
    }

    private static double determinant(Pnt[] matrix, int row, boolean[] columns) {
        if (row == matrix.length) {
            return 1.0;
        }
        double sum = 0.0;
        int sign = 1;
        int col = 0;
        while (col < columns.length) {
            if (columns[col]) {
                columns[col] = false;
                sum += (double)sign * matrix[row].coordinates[col] * Pnt.determinant(matrix, row + 1, columns);
                columns[col] = true;
                sign = -sign;
            }
            ++col;
        }
        return sum;
    }

    public static Pnt cross(Pnt[] matrix) {
        int len = matrix.length + 1;
        if (len != matrix[0].dimension()) {
            throw new IllegalArgumentException("Dimension mismatch");
        }
        boolean[] columns = new boolean[len];
        int i = 0;
        while (i < len) {
            columns[i] = true;
            ++i;
        }
        double[] result = new double[len];
        int sign = 1;
        try {
            int i2 = 0;
            while (i2 < len) {
                columns[i2] = false;
                result[i2] = (double)sign * Pnt.determinant(matrix, 0, columns);
                columns[i2] = true;
                sign = -sign;
                ++i2;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IllegalArgumentException("Matrix is wrong shape");
        }
        return new Pnt(result);
    }

    public static double content(Pnt[] simplex) {
        Pnt[] matrix = new Pnt[simplex.length];
        int i = 0;
        while (i < matrix.length) {
            matrix[i] = simplex[i].extend(1.0);
            ++i;
        }
        int fact = 1;
        int i2 = 1;
        while (i2 < matrix.length) {
            fact *= i2;
            ++i2;
        }
        return Pnt.determinant(matrix) / (double)fact;
    }

    public int[] relation(Pnt[] simplex) {
        int dim = simplex.length - 1;
        if (this.dimension() != dim) {
            throw new IllegalArgumentException("Dimension mismatch");
        }
        Pnt[] matrix = new Pnt[dim + 1];
        double[] coords = new double[dim + 2];
        int j = 0;
        while (j < coords.length) {
            coords[j] = 1.0;
            ++j;
        }
        matrix[0] = new Pnt(coords);
        int i = 0;
        while (i < dim) {
            coords[0] = this.coordinates[i];
            int j2 = 0;
            while (j2 < simplex.length) {
                coords[j2 + 1] = simplex[j2].coordinates[i];
                ++j2;
            }
            matrix[i + 1] = new Pnt(coords);
            ++i;
        }
        Pnt vector = Pnt.cross(matrix);
        double content = vector.coordinates[0];
        int[] result = new int[dim + 1];
        int i2 = 0;
        while (i2 < result.length) {
            double value = vector.coordinates[i2 + 1];
            result[i2] = Math.abs(value) <= 1.0E-6 * Math.abs(content) ? 0 : (value < 0.0 ? -1 : 1);
            ++i2;
        }
        if (content < 0.0) {
            i2 = 0;
            while (i2 < result.length) {
                result[i2] = -result[i2];
                ++i2;
            }
        }
        if (content == 0.0) {
            i2 = 0;
            while (i2 < result.length) {
                result[i2] = Math.abs(result[i2]);
                ++i2;
            }
        }
        return result;
    }

    public Pnt isOutside(Pnt[] simplex) {
        int[] result = this.relation(simplex);
        int i = 0;
        while (i < result.length) {
            if (result[i] > 0) {
                return simplex[i];
            }
            ++i;
        }
        return null;
    }

    public Pnt isOn(Pnt[] simplex) {
        int[] result = this.relation(simplex);
        Pnt witness = null;
        int i = 0;
        while (i < result.length) {
            if (result[i] == 0) {
                witness = simplex[i];
            } else if (result[i] > 0) {
                return null;
            }
            ++i;
        }
        return witness;
    }

    public boolean isInside(Pnt[] simplex) {
        int[] result;
        int[] nArray = result = this.relation(simplex);
        int n = result.length;
        int n2 = 0;
        while (n2 < n) {
            int r = nArray[n2];
            if (r >= 0) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public int vsCircumcircle(Pnt[] simplex) {
        int result;
        Pnt[] matrix = new Pnt[simplex.length + 1];
        int i = 0;
        while (i < simplex.length) {
            matrix[i] = simplex[i].extend(1.0, simplex[i].dot(simplex[i]));
            ++i;
        }
        matrix[simplex.length] = this.extend(1.0, this.dot(this));
        double d = Pnt.determinant(matrix);
        int n = d < 0.0 ? -1 : (result = d > 0.0 ? 1 : 0);
        if (Pnt.content(simplex) < 0.0) {
            result = -result;
        }
        return result;
    }

    public static Pnt circumcenter(Pnt[] simplex) {
        int dim = simplex[0].dimension();
        if (simplex.length - 1 != dim) {
            throw new IllegalArgumentException("Dimension mismatch");
        }
        Pnt[] matrix = new Pnt[dim];
        int i = 0;
        while (i < dim) {
            matrix[i] = simplex[i].bisector(simplex[i + 1]);
            ++i;
        }
        Pnt hCenter = Pnt.cross(matrix);
        double last = hCenter.coordinates[dim];
        double[] result = new double[dim];
        int i2 = 0;
        while (i2 < dim) {
            result[i2] = hCenter.coordinates[i2] / last;
            ++i2;
        }
        return new Pnt(result);
    }

    public static void main(String[] args) {
        Pnt p = new Pnt(1.0, 2.0, 3.0);
        System.out.println("Pnt created: " + p);
        Pnt[] matrix1 = new Pnt[]{new Pnt(1.0, 2.0), new Pnt(3.0, 4.0)};
        Pnt[] matrix2 = new Pnt[]{new Pnt(7.0, 0.0, 5.0), new Pnt(2.0, 4.0, 6.0), new Pnt(3.0, 8.0, 1.0)};
        System.out.print("Results should be -2 and -288: ");
        System.out.println(String.valueOf(Pnt.determinant(matrix1)) + " " + Pnt.determinant(matrix2));
        Pnt p1 = new Pnt(1.0, 1.0);
        Pnt p2 = new Pnt(-1.0, 1.0);
        System.out.println("Angle between " + p1 + " and " + p2 + ": " + p1.angle(p2));
        System.out.println(p1 + " subtract " + p2 + ": " + p1.subtract(p2));
        Pnt v0 = new Pnt(0.0, 0.0);
        Pnt v1 = new Pnt(1.0, 1.0);
        Pnt v2 = new Pnt(2.0, 2.0);
        Pnt[] vs = new Pnt[]{v0, new Pnt(0.0, 1.0), new Pnt(1.0, 0.0)};
        Pnt vp = new Pnt(0.1, 0.1);
        System.out.println(vp + " isInside " + Pnt.toString(vs) + ": " + vp.isInside(vs));
        System.out.println(v1 + " isInside " + Pnt.toString(vs) + ": " + v1.isInside(vs));
        System.out.println(vp + " vsCircumcircle " + Pnt.toString(vs) + ": " + vp.vsCircumcircle(vs));
        System.out.println(v1 + " vsCircumcircle " + Pnt.toString(vs) + ": " + v1.vsCircumcircle(vs));
        System.out.println(v2 + " vsCircumcircle " + Pnt.toString(vs) + ": " + v2.vsCircumcircle(vs));
        System.out.println("Circumcenter of " + Pnt.toString(vs) + " is " + Pnt.circumcenter(vs));
    }
}

