/*
 * Decompiled with CFR 0.152.
 */
package raytrace.engine;

import framework.M3d;
import framework.M4x4;
import framework.Ray;
import raytrace.engine.Camera;
import raytrace.engine.HitList;
import raytrace.engine.Material;
import raytrace.engine.RGBCanvas;
import raytrace.engine.RayCollision;
import raytrace.engine.Scene;

public class RayTracer {
    public static final double MIN_TRAVEL = 0.001;
    public static final int NUM_REFLECTIONS = 3;
    public static final boolean SHADOWS = false;
    public static final M3d clearColor = new M3d(0.5, 0.5, 0.5);
    public static final M3d black = new M3d(0.0, 0.0, 0.0);
    private Scene scene;
    private RGBCanvas canvas;
    private Camera camera;
    float pixelSize;
    boolean recalculate;
    boolean renderInProgress = false;
    int pos = 0;
    int stop = 1;
    float w;
    float h;
    float sx;
    float sy;

    public static M3d secondaryRay(Scene scene, Ray ray, int numLevels) {
        HitList hits = new HitList();
        if (scene.traceRay(ray, hits)) {
            return RayTracer.illuminate(scene, ray, (RayCollision)hits.get(0), numLevels + 1);
        }
        return clearColor;
    }

    public static M3d illuminate(Scene scene, Ray eyeRay, RayCollision hit, int numReflectionBounces) {
        Material hitMaterial = hit.material;
        double diffuseSum = 0.0;
        double specularSum = 0.0;
        M3d normal = hit.normal.dot(eyeRay.direction) > 0.0 ? hit.normal.times(-1.0) : hit.normal;
        M3d nVDotN = normal.times(normal.dot(eyeRay.direction));
        M3d reflectedColor = new M3d(0.0, 0.0, 0.0);
        M3d transparencyColor = new M3d(0.0, 0.0, 0.0);
        M3d baseColor = hitMaterial.getColor();
        for (M3d light : scene.getLights()) {
            HitList hits = new HitList();
            Ray shadowRay = new Ray(hit.point, light.minus(hit.point).normalized());
            boolean shadowed = false;
            if (shadowed) continue;
            diffuseSum += normal.dot(light.minus(hit.point).normalized());
            M3d N = normal;
            M3d L = light.minus(hit.point).normalized();
            M3d R = N.times(2.0 * L.dot(N)).minus(L);
            M3d E = eyeRay.direction.times(-1.0);
            specularSum += Math.pow(Math.max(R.dot(E), 0.0), hitMaterial.getSpecularShininess());
        }
        if (numReflectionBounces < 3 && hitMaterial.getReflectivity() > 0.0) {
            M3d reflection = eyeRay.direction.minus(nVDotN.times(2.0)).normalized();
            Ray eyeRayReflected = new Ray(hit.point, reflection);
            reflectedColor = RayTracer.secondaryRay(scene, eyeRayReflected, numReflectionBounces);
            reflectedColor = reflectedColor.times(hitMaterial.getReflectivity());
        }
        if (numReflectionBounces < 3 && hitMaterial.getTransparency() > 0.0) {
            Ray eyeRayPassedThrough;
            if (hitMaterial.getRefractiveIndex() == 1.0 || eyeRay.direction.times(-1.0).dot(normal) > 0.99999) {
                eyeRayPassedThrough = new Ray(hit.point, eyeRay.direction);
            } else {
                double nOne = hit.normal.dot(eyeRay.direction) > 0.0 ? hitMaterial.getRefractiveIndex() : 1.0;
                double nTwo = hit.normal.dot(eyeRay.direction) <= 0.0 ? hitMaterial.getRefractiveIndex() : 1.0;
                double thetaOne = Math.acos(normal.dot(eyeRay.direction.times(-1.0)));
                double thetaTwo = Math.asin(Math.sin(thetaOne) * nOne / nTwo);
                M3d axis = normal.times(-1.0).cross(eyeRay.direction);
                M4x4 bend = M4x4.rotation(axis, thetaTwo);
                eyeRayPassedThrough = new Ray(hit.point, bend.times(normal.times(-1.0)));
            }
            transparencyColor = RayTracer.secondaryRay(scene, eyeRayPassedThrough, numReflectionBounces);
            transparencyColor = transparencyColor.times(hitMaterial.getTransparency());
        }
        double localLighting = hitMaterial.getKa() + diffuseSum * hitMaterial.getKd() + specularSum * hitMaterial.getKs();
        M3d localColor = baseColor.times(localLighting).times(1.0 - Math.max(hitMaterial.getReflectivity(), hitMaterial.getTransparency()));
        M3d totalColor = localColor.plus(reflectedColor).plus(transparencyColor);
        return totalColor;
    }

    public RayTracer(Scene scene, RGBCanvas canvas, Camera camera) {
        this.scene = scene;
        this.canvas = canvas;
        this.camera = camera;
        this.pixelSize = (float)Math.max(canvas.getWidth(), canvas.getHeight()) / 4.0f;
        this.findProgressiveRenderConstants();
        this.renderInProgress = true;
    }

    public void fireRay(int x, int y, float w, float h, float sx, float sy) {
        HitList hits;
        float cellLeft = this.camera.viewWidth / 2.0f * (((float)x - w / 2.0f) / w);
        float cellRight = this.camera.viewWidth / 2.0f * (((float)(x + 1) - w / 2.0f) / w);
        float cellTop = this.camera.viewHeight / 2.0f * (((float)y - h / 2.0f) / h);
        float cellBottom = this.camera.viewHeight / 2.0f * (((float)(y + 1) - h / 2.0f) / h);
        float cellX = (cellLeft + cellRight) / 2.0f;
        float cellY = (cellTop + cellBottom) / 2.0f;
        M3d interceptRight = this.camera.right.times(cellX);
        M3d interceptUp = this.camera.up.times(cellY);
        M3d intercept = this.camera.position.plus(this.camera.direction.times(this.camera.distanceToViewingPlane)).plus(interceptUp).plus(interceptRight);
        Ray ray = new Ray(this.camera.position, intercept.minus(this.camera.position).normalized());
        if (this.scene.traceRay(ray, hits = new HitList())) {
            this.canvas.fill(sx * (float)x, sy * (float)y, sx, sy, RayTracer.illuminate(this.scene, ray, (RayCollision)hits.get(0), 0));
        } else {
            this.canvas.fill(sx * (float)x, sy * (float)y, sx, sy, clearColor);
        }
    }

    public void renderScene() {
        float sx = this.canvas.getWidth();
        float sy = this.canvas.getHeight();
        int x = 0;
        while ((float)x < this.w) {
            int y = 0;
            while ((float)y < this.h) {
                this.fireRay(x, y, this.w, this.h, sx, sy);
                ++y;
            }
            ++x;
        }
    }

    private void findProgressiveRenderConstants() {
        this.w = (float)this.canvas.getWidth() / this.pixelSize;
        this.h = (float)this.canvas.getHeight() / this.pixelSize;
        this.sx = (float)this.canvas.getWidth() / this.w;
        this.sy = (float)this.canvas.getHeight() / this.w;
        this.pos = 0;
        this.stop = (int)this.h * (int)this.w;
        this.recalculate = false;
    }

    public boolean renderSceneProgressively() {
        if (this.recalculate) {
            this.findProgressiveRenderConstants();
        }
        if (this.renderInProgress) {
            int counter = 0;
            while (counter < 64 && this.pos < this.stop) {
                int x = this.pos % (int)this.w;
                int y = this.pos / (int)this.h;
                this.fireRay(x, y, this.w, this.h, this.sx, this.sy);
                ++this.pos;
                ++counter;
            }
            if (this.pos < this.stop) {
                int y = this.pos / (int)this.h;
                this.canvas.fill(0.0, this.sy * (float)(y + 1), this.canvas.getWidth(), this.sy, black);
            } else if (this.pixelSize > 1.0f) {
                this.pixelSize /= 4.0f;
                if (this.pixelSize < 1.0f) {
                    this.pixelSize = 1.0f;
                }
                this.recalculate = true;
            } else {
                this.renderInProgress = false;
            }
        }
        return this.renderInProgress;
    }

    public boolean getRenderInProgress() {
        return this.renderInProgress;
    }

    public void resetProgressiveRender() {
        this.pixelSize = (float)Math.max(this.canvas.getWidth(), this.canvas.getHeight()) / 4.0f;
        this.recalculate = true;
        this.renderInProgress = true;
    }
}

