/*
 * Decompiled with CFR 0.152.
 */
package raytrace.engine;

import framework.M3d;
import framework.M4x4;
import framework.Ray;
import raytrace.engine.HitList;
import raytrace.engine.RayCollision;

public abstract class Primitive {
    private M4x4 l2p = new M4x4();
    private M4x4 l2p4Normals = new M4x4();
    private M4x4 p2l = new M4x4();

    public M4x4 getLocalToParent() {
        return this.l2p;
    }

    public M4x4 getParentToLocal() {
        return this.p2l;
    }

    public void setLocalTransform(M4x4 l2p) {
        this.l2p = l2p;
        this.l2p4Normals = l2p.extract3x3().inverted().transposed();
        this.p2l = l2p.inverted();
    }

    protected M3d getNormal(M3d point) {
        return new M3d(0.0, 0.0, 0.0);
    }

    protected RayCollision recordCollision(double t, Ray ray, HitList collisions) {
        if (t >= 0.001) {
            RayCollision hit = new RayCollision();
            hit.t = t;
            hit.point = ray.at(t);
            hit.normal = this.getNormal(hit.point);
            collisions.insert(hit);
            return hit;
        }
        return null;
    }

    boolean traceRay(Ray ray, HitList collisions) {
        HitList hits;
        Ray transformedRay = ray.transformedBy(this.p2l);
        if (this.testLocalRay(transformedRay, hits = new HitList())) {
            for (RayCollision collision : hits) {
                M3d notTheNormal = Math.abs(collision.normal.getX()) < 0.9 ? new M3d(1.0, 0.0, 0.0) : new M3d(0.0, 1.0, 0.0);
                M3d A = collision.normal.cross(notTheNormal);
                M3d B = collision.normal.cross(A);
                M3d ptA = collision.point.plus(A);
                M3d ptB = collision.point.plus(B);
                M3d ptAP = this.l2p.times(ptA);
                M3d ptBP = this.l2p.times(ptB);
                M3d AD = ptAP.minus(this.l2p.times(collision.point));
                M3d BD = ptBP.minus(this.l2p.times(collision.point));
                collision.normal = AD.cross(BD).normalized();
                collision.point = this.l2p.times(collision.point);
                collision.t = ray.origin.minus(collision.point).length();
                collisions.insert(collision);
            }
            return true;
        }
        return false;
    }

    abstract boolean testLocalRay(Ray var1, HitList var2);
}

