/*
 * Decompiled with CFR 0.152.
 */
package raytrace.engine;

import framework.M3d;
import framework.Ray;
import raytrace.engine.HitList;
import raytrace.engine.Material;
import raytrace.engine.MaterialPrimitive;
import raytrace.engine.RayCollision;

public class Plane
extends MaterialPrimitive {
    static final M3d YAxis = new M3d(0.0, 1.0, 0.0);

    public Plane(M3d color) {
        super(color);
    }

    @Override
    protected M3d getNormal(M3d point) {
        return YAxis;
    }

    @Override
    boolean testLocalRay(Ray ray, HitList collisions) {
        double t = -ray.origin.getY() / ray.direction.getY();
        RayCollision hit = this.recordCollision(t, ray, collisions);
        if (hit != null) {
            M3d pt = ray.at(t);
            int x = (int)Math.floor(pt.getX());
            int z = (int)Math.floor(pt.getZ());
            Material mat = new Material(this.getMaterial());
            mat.setColor(pt.length() <= 5.0 ? mat.getColor().times(x + z & 1) : (pt.length() <= 5.25 ? new M3d(0.2f, 0.6f, 0.8f) : mat.getColor()));
            mat.setReflectivity(0.5);
            hit.material = mat;
            return true;
        }
        return false;
    }
}

