/*
 * Decompiled with CFR 0.152.
 */
package morph;

import framework.M3d;
import framework.Renderer;
import javax.media.opengl.GL;
import javax.media.opengl.GLAutoDrawable;

public class MorphingSurface
extends Renderer {
    private static final int di = 32;
    private static final int dj = 32;
    private int tick = 0;
    private MeshPt[][] mesh;
    Generator sphere = new Generator(){

        @Override
        public M3d get(double u, double v) {
            v = Math.PI * (v - 0.5);
            return new M3d(Math.cos(u *= Math.PI * 2) * Math.cos(v), Math.sin(u) * Math.cos(v), Math.sin(v));
        }
    };
    Generator powerSphere = new Generator(){

        @Override
        public M3d get(double u, double v) {
            v = Math.PI * (v - 0.5);
            double x = Math.cos(u *= Math.PI * 2) * Math.cos(v);
            double y = Math.sin(u) * Math.cos(v);
            double z = Math.sin(v);
            return new M3d(x * x * x, y * y * y, z * z * z);
        }
    };
    Generator cylinder = new Generator(){

        @Override
        public M3d get(double u, double v) {
            v = 2.0 * (v - 0.5);
            return new M3d(Math.cos(u *= Math.PI * 2), Math.sin(u), v);
        }
    };
    Generator torus = new Generator(){

        @Override
        public M3d get(double u, double v) {
            v = Math.PI * 2 * v + Math.PI;
            M3d pt = new M3d(1.0 + 0.25 * Math.cos(v), 0.0, 0.25 * Math.sin(v));
            return new M3d(pt.get(0) * Math.cos(u *= Math.PI * 2) - pt.get(1) * Math.sin(u), pt.get(0) * Math.sin(u) + pt.get(1) * Math.cos(u), pt.get(2));
        }
    };

    @Override
    public String getTitle() {
        return "Parametric Morph";
    }

    public void buildMesh() {
        Generator[] generators = new Generator[]{this.sphere, this.powerSphere, this.cylinder, this.torus};
        int which = this.tick / 500;
        double t = Math.sin((double)(this.tick % 500) * 1.5707963267948966 / 500.0);
        Generator A = generators[which % generators.length];
        Generator B = generators[(which + 1) % generators.length];
        this.mesh = new MeshPt[32][32];
        int i = 0;
        while (i < 32) {
            int j = 0;
            while (j < 32) {
                double u = (double)i / 31.0;
                double v = (double)j / 31.0;
                this.mesh[i][j] = new MeshPt(A.get(u, v).times(1.0 - t).plus(B.get(u, v).times(t)), i, j);
                ++j;
            }
            ++i;
        }
    }

    public MeshPt getMesh(int i, int j) {
        while (i < 0) {
            i += 32;
        }
        while (j < 0) {
            j += 32;
        }
        return this.mesh[i % 32][j % 32];
    }

    public void display(GLAutoDrawable gLDrawable) {
        int j;
        GL gl = gLDrawable.getGL();
        float t = (float)this.tick / 10.0f;
        gl.glClear(16384);
        gl.glClear(256);
        gl.glLoadIdentity();
        gl.glTranslatef(0.0f, 0.0f, -4.0f);
        gl.glRotatef(t, 1.0f, 0.0f, 0.0f);
        gl.glRotatef(t, 0.0f, 1.0f, 0.0f);
        gl.glRotatef(t, 0.0f, 0.0f, 1.0f);
        gl.glRotatef(t, 0.0f, 1.0f, 0.0f);
        this.buildMesh();
        gl.glBegin(7);
        int i = 0;
        while (i < 31) {
            j = 0;
            while (j < 31) {
                this.getMesh(i, j).normal(gl).color(gl).vertex(gl);
                this.getMesh(i + 1, j).normal(gl).color(gl).vertex(gl);
                this.getMesh(i + 1, j + 1).normal(gl).color(gl).vertex(gl);
                this.getMesh(i, j + 1).normal(gl).color(gl).vertex(gl);
                ++j;
            }
            ++i;
        }
        gl.glEnd();
        gl.glTranslatef(0.0f, 0.0f, 1.0E-5f);
        gl.glColor3i(0, 0, 0);
        i = 0;
        while (i < 31) {
            j = 0;
            while (j < 31) {
                gl.glBegin(2);
                this.getMesh(i, j).vertex(gl);
                this.getMesh(i + 1, j).vertex(gl);
                this.getMesh(i + 1, j + 1).vertex(gl);
                this.getMesh(i, j + 1).vertex(gl);
                gl.glEnd();
                ++j;
            }
            ++i;
        }
        ++this.tick;
    }

    static interface Generator {
        public M3d get(double var1, double var3);
    }

    class MeshPt
    extends M3d {
        private int i;
        private int j;

        MeshPt(M3d pt, int i, int j) {
            super(pt.get(0), pt.get(1), pt.get(2));
            this.i = i;
            this.j = j;
        }

        MeshPt getAdjacent(int deltai, int deltaj) {
            return MorphingSurface.this.getMesh(this.i + deltai, this.j + deltaj);
        }

        MeshPt vertex(GL gl) {
            gl.glVertex3d(this.get(0), this.get(1), this.get(2));
            return this;
        }

        MeshPt color(GL gl) {
            gl.glColor3d((this.get(0) + 1.0) / 2.0, (this.get(1) + 1.0) / 2.0, (this.get(2) + 1.0) / 2.0);
            return this;
        }

        MeshPt normal(GL gl) {
            M3d a = this.getAdjacent(-1, 0).plus(this.times(-1.0));
            M3d b = this.getAdjacent(0, -1).plus(this.times(-1.0));
            M3d c = this.getAdjacent(1, 0).plus(this.times(-1.0));
            M3d d = this.getAdjacent(0, 1).plus(this.times(-1.0));
            M3d ab = a.cross(b);
            M3d bc = b.cross(c);
            M3d cd = c.cross(d);
            M3d da = d.cross(a);
            M3d n = ab.plus(bc).plus(cd).plus(da).normalized();
            gl.glNormal3d(n.get(0), n.get(1), n.get(2));
            return this;
        }
    }
}

