/*
 * Decompiled with CFR 0.152.
 */
package hierarchy;

import framework.Renderer;
import java.awt.event.KeyEvent;
import javax.media.opengl.GL;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.glu.GLU;
import javax.media.opengl.glu.GLUquadric;

public class HierarchyDemo
extends Renderer {
    private int numLevels = 0;
    private int tick = 0;
    private int displayListId = -1;
    private boolean paused = true;

    @Override
    public String getTitle() {
        return "Hierarchical model";
    }

    @Override
    public void init(GLAutoDrawable glDrawable) {
        super.init(glDrawable);
        GL gl = glDrawable.getGL();
        GLU glu = new GLU();
        GLUquadric quadric = glu.gluNewQuadric();
        glu.gluQuadricOrientation(quadric, 100020);
        this.displayListId = gl.glGenLists(1);
        gl.glNewList(this.displayListId, 4864);
        gl.glPushMatrix();
        gl.glRotatef(90.0f, 1.0f, 0.0f, 0.0f);
        glu.gluSphere(quadric, 0.15, 10, 10);
        gl.glPopMatrix();
        gl.glEndList();
    }

    void renderLevel(GL gl, int level) {
        float t = (float)this.tick / 5.0f;
        gl.glPushMatrix();
        gl.glRotatef(t, 0.0f, 1.0f, 0.0f);
        gl.glCallList(this.displayListId);
        if (level > 0) {
            gl.glScalef(0.75f, 0.75f, 0.75f);
            gl.glDisable(2896);
            gl.glLineWidth(3.0f);
            gl.glBegin(1);
            gl.glColor3f(1.0f, 0.0f, 0.0f);
            gl.glVertex3f(0.0f, 0.0f, 0.0f);
            gl.glVertex3f(1.0f, -0.75f, 0.0f);
            gl.glVertex3f(0.0f, 0.0f, 0.0f);
            gl.glVertex3f(-1.0f, -0.75f, 0.0f);
            gl.glEnd();
            gl.glLineWidth(1.0f);
            gl.glEnable(2896);
            gl.glColor3f(1.0f, 1.0f, 1.0f);
            gl.glPushMatrix();
            gl.glTranslatef(1.0f, -0.75f, 0.0f);
            this.renderLevel(gl, level - 1);
            gl.glPopMatrix();
            gl.glPushMatrix();
            gl.glTranslatef(-1.0f, -0.75f, 0.0f);
            this.renderLevel(gl, level - 1);
            gl.glPopMatrix();
        }
        gl.glPopMatrix();
    }

    @Override
    public void preDisplay(GLAutoDrawable glDrawable) {
        GL gl = glDrawable.getGL();
        super.preDisplay(glDrawable);
        gl.glTranslatef(0.0f, 1.0f, 0.0f);
    }

    public void display(GLAutoDrawable glDrawable) {
        this.preDisplay(glDrawable);
        this.renderLevel(glDrawable.getGL(), this.numLevels);
        if (!this.paused) {
            ++this.tick;
        }
        this.postDisplay(glDrawable);
    }

    @Override
    public void keyPressed(KeyEvent e) {
        switch (e.getKeyChar()) {
            case '+': 
            case '=': {
                if (this.numLevels >= 12) break;
                ++this.numLevels;
                break;
            }
            case '-': 
            case '_': {
                if (this.numLevels <= 0) break;
                --this.numLevels;
                break;
            }
            case ' ': {
                this.paused = !this.paused;
                break;
            }
            default: {
                super.keyPressed(e);
            }
        }
    }
}

