/*
 * Decompiled with CFR 0.152.
 */
package blobby.engine;

import blobby.engine.Octree;
import framework.M3d;
import java.util.LinkedList;

public class OctTreeEdge
extends LinkedList<Octree> {
    M3d a;
    M3d b;
    M3d midPt;
    M3d normalDir;
    M3d interpolatedM3d;
    OctTreeEdge parent;
    OctTreeEdge childA;
    OctTreeEdge childB;

    OctTreeEdge(OctTreeEdge parent, M3d a, M3d b, M3d precomputedMidPt) {
        this.parent = parent;
        this.a = a;
        this.b = b;
        this.midPt = precomputedMidPt == null ? a.plus(b).times(0.5) : precomputedMidPt;
    }

    boolean hasSharedEndPoint(OctTreeEdge e) {
        return this.a == e.a || this.b == e.b || this.a == e.b || this.b == e.a;
    }

    void setMidPt(M3d midPt) {
        this.midPt = midPt;
    }

    void setCrossingData(M3d interpolatedM3d, M3d normalDir) {
        this.interpolatedM3d = interpolatedM3d;
        this.normalDir = normalDir;
    }

    public OctTreeEdge getParent() {
        return this.parent;
    }

    public M3d getMidPt() {
        return this.midPt;
    }

    public M3d getNormalDir() {
        return this.normalDir;
    }

    public M3d getEndPt(int which) {
        return which == 0 ? this.a : this.b;
    }

    public OctTreeEdge getChild(int which) {
        return which == 0 ? this.childA : this.childB;
    }

    public void setChild(int which, OctTreeEdge child) {
        if (which == 0) {
            this.childA = child;
        } else {
            this.childB = child;
        }
    }

    public M3d getInterpolatedVertex() {
        return this.interpolatedM3d;
    }
}

