/*
 * Decompiled with CFR 0.152.
 */
package blobby.engine;

import blobby.engine.ImplicitSurface;
import blobby.engine.Octree;
import framework.M3d;
import java.util.ArrayList;
import java.util.LinkedList;
import javax.media.opengl.GL;

public class ImplicitSurfaceRenderer {
    private ImplicitSurface surface;
    private boolean showEdges = true;
    private boolean showBoxes = false;

    public ImplicitSurfaceRenderer(ImplicitSurface surface) {
        this.surface = surface;
    }

    private void renderOctrees(GL gl, LinkedList<Octree> L, boolean normals) {
        for (Octree octree : L) {
            for (ArrayList poly : octree) {
                if (normals) {
                    gl.glNormal3dv(((M3d)poly.get(2)).minus((M3d)poly.get(1)).cross(((M3d)poly.get(0)).minus((M3d)poly.get(1))).normalized().get(), 0);
                }
                for (M3d pt : poly) {
                    gl.glVertex3dv(pt.get(), 0);
                }
            }
        }
    }

    private void renderOctreeBoxes(GL gl, LinkedList<Octree> L, boolean normals) {
        for (Octree octree : L) {
            int x = 0;
            while (x < 2) {
                int y = 0;
                while (y < 2) {
                    int z = 0;
                    while (z < 2) {
                        if (x > 0) {
                            gl.glVertex3dv(octree.getCorners()[0][y][z].get(), 0);
                            gl.glVertex3dv(octree.getCorners()[1][y][z].get(), 0);
                        }
                        if (y > 0) {
                            gl.glVertex3dv(octree.getCorners()[x][0][z].get(), 0);
                            gl.glVertex3dv(octree.getCorners()[x][1][z].get(), 0);
                        }
                        if (z > 0) {
                            gl.glVertex3dv(octree.getCorners()[x][y][0].get(), 0);
                            gl.glVertex3dv(octree.getCorners()[x][y][1].get(), 0);
                        }
                        ++z;
                    }
                    ++y;
                }
                ++x;
            }
        }
    }

    public boolean getShowBoxes() {
        return this.showBoxes;
    }

    public void setShowBoxes(boolean boxes) {
        this.showBoxes = boxes;
    }

    public boolean getShowEdges() {
        return this.showEdges;
    }

    public void setShowEdges(boolean edges) {
        this.showEdges = edges;
    }

    public void render(GL gl) {
        gl.glDisable(2896);
        if (this.showEdges) {
            gl.glColor3f(0.0f, 0.0f, 0.0f);
            gl.glPolygonMode(1028, 6913);
            gl.glBegin(4);
            this.renderOctrees(gl, this.surface.getFinished(), false);
            gl.glEnd();
        }
        if (this.showBoxes) {
            gl.glColor3f(0.5f, 0.5f, 0.5f);
            gl.glBegin(1);
            this.renderOctreeBoxes(gl, this.surface.getFinished(), false);
            gl.glEnd();
        }
        gl.glEnable(2896);
        gl.glColor3f(1.0f, 1.0f, 1.0f);
        gl.glPolygonMode(1028, 6914);
        gl.glBegin(4);
        this.renderOctrees(gl, this.surface.getFinished(), true);
        gl.glEnd();
    }
}

