/*
 * Decompiled with CFR 0.152.
 */
package delaunay;

import delaunay.DelaunayPanel;
import delaunay.Pnt;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Label;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;

public class DelaunayAp
extends JApplet
implements Runnable,
ActionListener,
MouseListener {
    private boolean debug = false;
    private Component currentSwitch = null;
    private static String windowTitle = "Voronoi/Delaunay Window";
    private JRadioButton voronoiButton = new JRadioButton("Voronoi Diagram");
    private JRadioButton delaunayButton = new JRadioButton("Delaunay Triangulation");
    private JButton clearButton = new JButton("Clear");
    private JCheckBox colorfulBox = new JCheckBox("More Colorful");
    private DelaunayPanel delaunayPanel = new DelaunayPanel(this);
    private JLabel circleSwitch = new JLabel("Show Empty Circles");
    private JLabel delaunaySwitch = new JLabel("Show Delaunay Edges");
    private JLabel voronoiSwitch = new JLabel("Show Voronoi Edges");

    public static void main(String[] args) {
        DelaunayAp applet = new DelaunayAp();
        applet.init();
        JFrame dWindow = new JFrame();
        dWindow.setSize(700, 500);
        dWindow.setTitle(windowTitle);
        dWindow.setLayout(new BorderLayout());
        dWindow.setDefaultCloseOperation(3);
        dWindow.add((Component)applet, "Center");
        dWindow.setVisible(true);
    }

    @Override
    public void init() {
        try {
            SwingUtilities.invokeAndWait(this);
        }
        catch (Exception e) {
            System.err.println("Initialization failure");
        }
    }

    @Override
    public void run() {
        this.setLayout(new BorderLayout());
        ButtonGroup group = new ButtonGroup();
        group.add(this.voronoiButton);
        group.add(this.delaunayButton);
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(this.voronoiButton);
        buttonPanel.add(this.delaunayButton);
        buttonPanel.add(this.clearButton);
        buttonPanel.add(new JLabel("          "));
        buttonPanel.add(this.colorfulBox);
        this.colorfulBox.setSelected(true);
        this.add((Component)buttonPanel, "North");
        JPanel switchPanel = new JPanel();
        switchPanel.add(this.circleSwitch);
        switchPanel.add(new Label("     "));
        switchPanel.add(this.delaunaySwitch);
        switchPanel.add(new Label("     "));
        switchPanel.add(this.voronoiSwitch);
        this.add((Component)switchPanel, "South");
        this.delaunayPanel.setBackground(Color.gray);
        this.add((Component)this.delaunayPanel, "Center");
        this.voronoiButton.addActionListener(this);
        this.delaunayButton.addActionListener(this);
        this.clearButton.addActionListener(this);
        this.colorfulBox.addActionListener(this);
        this.delaunayPanel.addMouseListener(this);
        this.circleSwitch.addMouseListener(this);
        this.delaunaySwitch.addMouseListener(this);
        this.voronoiSwitch.addMouseListener(this);
        this.voronoiButton.doClick();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.debug) {
            System.out.println(((AbstractButton)e.getSource()).getText());
        }
        if (e.getSource() == this.clearButton) {
            this.delaunayPanel.clear();
        }
        this.delaunayPanel.repaint();
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.currentSwitch = e.getComponent();
        if (this.currentSwitch instanceof JLabel) {
            this.delaunayPanel.repaint();
        } else {
            this.currentSwitch = null;
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.currentSwitch = null;
        if (e.getComponent() instanceof JLabel) {
            this.delaunayPanel.repaint();
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.getSource() != this.delaunayPanel) {
            return;
        }
        Pnt point = new Pnt(e.getX(), e.getY());
        if (this.debug) {
            System.out.println("Click " + point);
        }
        this.delaunayPanel.addSite(point);
        this.delaunayPanel.repaint();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    public boolean isColorful() {
        return this.colorfulBox.isSelected();
    }

    public boolean isVoronoi() {
        return this.voronoiButton.isSelected();
    }

    public boolean showingCircles() {
        return this.currentSwitch == this.circleSwitch;
    }

    public boolean showingDelaunay() {
        return this.currentSwitch == this.delaunaySwitch;
    }

    public boolean showingVoronoi() {
        return this.currentSwitch == this.voronoiSwitch;
    }
}

