module malwa_ff(
	input [4:0]	regnum,
				writereg1,
				writereg2,
	input		writeregen1,
				writeregen2,
	input [31:0]regdata,
				writeregdata1,
				writeregdata2,
	output [31:0]out
);

	wire notzero1;
	or nz1(notzero1,regnum[0],regnum[1],regnum[2],regnum[3]);
	
	wire en2;
	malwa_ff_compare c2(regnum,writereg2,writeregen2,en2);
	wire [31:0] muxedin2=en2 ? writeregdata2 : regdata;
	
	wire en1;
	malwa_ff_compare c1(regnum,writereg1,writeregen1,en1);
	wire [31:0] muxedin1=en1 ? writeregdata1 : muxedin2;
	
	wire notzero;
	or nz(notzero,notzero1,regnum[4]);
	and a[31:0](out,muxedin1,notzero);
endmodule

module malwa_ff_compare(
	input [4:0] regnum,
	input [4:0] writereg,
	input		writeregen,
	output		en
);
	wire eq[5:0];
	wire anded[2:0];
	xnor e0(eq[0],regnum[0],writereg[0]); 	and a0(anded[0],eq[0],eq[1]);
	xnor e1(eq[1],regnum[1],writereg[1]);

	xnor e2(eq[2],regnum[2],writereg[2]);	and a1(anded[1],eq[2],eq[3]);
	xnor e3(eq[3],regnum[3],writereg[3]);

	xnor e4(eq[4],regnum[4],writereg[4]);	and a2(anded[2],eq[4],eq[5]);
	assign eq[5]=writeregen;

	and(en,anded[0],anded[1],anded[2]);
endmodule