module main(
	input			CLOCK_50,
	input			CLOCK_27,
	
	output			TD_RESET,		//	IMPORTANT: to use the 27Mhz clock this must be asserted high
	
	input	[3:0]	KEY,
	input	[17:0]	SW,
	
	output			LCD_RW,
	output			LCD_EN,
	output			LCD_RS,
	output	[7:0]	LCD_DATA,
	output			LCD_ON,
	output			LCD_BLON,
	
	output 	[17:0]	SRAM_ADDR,
	inout	[15:0]	SRAM_DQ,
	output			SRAM_WE_N,
	output			SRAM_OE_N,
	output			SRAM_UB_N,
	output			SRAM_LB_N,
	output			SRAM_CE_N,
	
	output 	[9:0]	VGA_R,
	output 	[9:0]	VGA_G,
	output 	[9:0]	VGA_B,
	output			VGA_CLK,
	output			VGA_BLANK,
	output 			VGA_HS,
	output 			VGA_VS,
	output			VGA_SYNC,
	
	output	[11:0]	DRAM_ADDR,
	output			DRAM_BA_0,
	output			DRAM_BA_1,
	output			DRAM_CAS_N,
	output			DRAM_CKE,
	output			DRAM_CLK,
	output			DRAM_CS_N,
	inout	[15:0]	DRAM_DQ,
	output			DRAM_LDQM,
	output			DRAM_UDQM,
	output			DRAM_RAS_N,
	output			DRAM_WE_N,
	
	input			UART_RXD,
	output			UART_TXD,
	
	inout			PS2_CLK,
	inout			PS2_DAT,
	
	inout			I2C_SCLK,
	inout			I2C_SDAT,
	
	output			AUD_ADCLRCK,
	input			AUD_ADCDAT,
	output			AUD_DACLRCK,
	output			AUD_DACDAT,
	output			AUD_XCK,
	inout			AUD_BCLK,
	
	output	[6:0]	HEX0, HEX1, HEX2, HEX3, HEX4, HEX5, HEX6, HEX7,
	output [17:0] LEDR
	);


	assign TD_RESET = 1;


	wire RST;
	assign RST = KEY[3];


	wire CLOCK_111, CLOCK_SOUND;
	SRAM_PLL	 	(	.inclk0(CLOCK_50),
						.c0(CLOCK_111),
						.c1(CLOCK_SOUND)
					);
	
	wire CLOCK_AVALON;
	VGA_PLL		 	(	.inclk0(CLOCK_27),
						.c0(VGA_CLK),
						.c1(CLOCK_AVALON),
						.c2(DRAM_CLK)
					);


//------------------------------------------------------------------------------
//				THE VGA SUBSYSTEM
//------------------------------------------------------------------------------
	wire [39:0] SRAM_FIFO_WRITE_DATA, SRAM_FIFO_READ_DATA;
	wire SRAM_FIFO_READ_ACK, SRAM_FIFO_WRITE_REQ, SRAM_FIFO_READ_EMPTY, SRAM_FIFO_WRITE_FULL;
	SRAM_FIFO			(	SRAM_FIFO_WRITE_DATA,
							CLOCK_111, SRAM_FIFO_READ_ACK,
							CLOCK_AVALON, SRAM_FIFO_WRITE_REQ,
							SRAM_FIFO_READ_DATA, SRAM_FIFO_READ_EMPTY, SRAM_FIFO_WRITE_FULL
						);
	
	wire [39:0] VGA_FIFO_WRITE_DATA, VGA_FIFO_READ_DATA;
	wire VGA_FIFO_READ_ACK, VGA_FIFO_WRITE_REQ, VGA_FIFO_READ_EMPTY, VGA_FIFO_WRITE_FULL;
	VGA_FIFO			(	~RST, VGA_FIFO_WRITE_DATA,
							VGA_CLK, VGA_FIFO_READ_ACK,
							CLOCK_111, VGA_FIFO_WRITE_REQ,
							VGA_FIFO_READ_DATA, VGA_FIFO_READ_EMPTY, VGA_FIFO_WRITE_FULL
						);
	
	SRAM_CONTROLLER		(	CLOCK_111, RST,
							SRAM_FIFO_READ_DATA, SRAM_FIFO_READ_ACK, SRAM_FIFO_READ_EMPTY,
							SRAM_ADDR, SRAM_DQ, SRAM_WE_N, SRAM_OE_N, SRAM_UB_N, SRAM_LB_N, SRAM_CE_N,
							VGA_FIFO_WRITE_DATA, VGA_FIFO_WRITE_REQ, VGA_FIFO_WRITE_FULL
						);
	
	wire [14:0] VGA_TB_WRITE_DATA, VGA_TB_READ_DATA;
	wire [11:0] VGA_TB_READ_ADDR, VGA_TB_WRITE_ADDR;
	wire VGA_TB_WRITE_REQ;
	VGA_TB				(	VGA_TB_WRITE_DATA,
							VGA_TB_READ_ADDR, VGA_CLK,
							VGA_TB_WRITE_ADDR, CLOCK_AVALON, VGA_TB_WRITE_REQ,
							VGA_TB_READ_DATA
						);
	
	wire [11:0] VGA_CHARMAP_READ_ADDR;
	wire [7:0] VGA_CHARMAP_READ_DATA;
	VGA_CHARMAP			(	VGA_CHARMAP_READ_ADDR, VGA_CLK,
							8'd0, 1'b0,
							VGA_CHARMAP_READ_DATA
						);
	
	wire VGA_CHARACTER_SET;
	VGA_CONTROLLER		(	VGA_CLK, RST,
							1'b0,
							VGA_FIFO_READ_DATA, VGA_FIFO_READ_ACK, VGA_FIFO_READ_EMPTY,
							VGA_TB_READ_ADDR, VGA_TB_READ_DATA, VGA_CHARMAP_READ_ADDR, VGA_CHARMAP_READ_DATA,
							VGA_R, VGA_G, VGA_B, VGA_BLANK, VGA_HS, VGA_VS, VGA_SYNC
						);
//------------------------------------------------------------------------------


//------------------------------------------------------------------------------
//				THE SOUND SUBSYSTEM
//------------------------------------------------------------------------------
	wire			SCL_OE_N;
	wire			SDA_OE_N;
	wire			SCL;
	wire			SDA;
	assign I2C_SCLK		=	SCL_OE_N	?	1'bz	:	SCL	;
	assign I2C_SDAT		=	SDA_OE_N	?	1'bz	:	SDA	;
	
	I2C_AV_Config		(	.iCLK(CLOCK_AVALON),
							.iRST_N(RST),
							.I2C_SCLK(I2C_SCLK),
							.I2C_SDAT(I2C_SDAT)
						);
	
	assign AUD_ADCLRCK	=	AUD_DACLRCK;
	assign AUD_XCK		=	CLOCK_SOUND;
//------------------------------------------------------------------------------


	wire			reset_n;
	wire	[31:0]	address;
	wire	[1:0]	byteenable;
	wire			irq;
	wire	[5:0]	irqnumber;
	wire			write_n;
	wire			read_n;
	wire			waitrequest;
	wire	[15:0]	writedata;
	wire	[15:0]	readdata;
	
	wire [22:0]	ava_address_from_the_scarab;
	wire [1:0] ava_byteenable_from_the_scarab;
	wire ava_read_from_the_scarab;
	wire [15:0] ava_readdata_to_the_scarab;
	wire ava_waitrequest_to_the_scarab;
	wire ava_write_from_the_scarab;
	wire [15:0] ava_writedata_from_the_scarab;

	subsystemMMU	mmu (	CLOCK_AVALON, reset_n, address, byteenable, irq, irqnumber, write_n, read_n, waitrequest, writedata, readdata,
						ava_address_from_the_scarab,
						ava_byteenable_from_the_scarab,
						ava_read_from_the_scarab,
						ava_readdata_to_the_scarab,
						ava_waitrequest_to_the_scarab,
						ava_write_from_the_scarab,
						ava_writedata_from_the_scarab,
						VGA_CHARACTER_SET,
						SRAM_FIFO_WRITE_DATA, SRAM_FIFO_WRITE_REQ, SRAM_FIFO_WRITE_FULL,
						VGA_TB_WRITE_ADDR, VGA_TB_WRITE_DATA, VGA_TB_WRITE_REQ,
						SW[17], KEY[0], LCD_RW, LCD_EN, LCD_RS, LCD_DATA, LCD_ON, LCD_BLON,
						HEX0,HEX1,HEX2,HEX3,HEX4,HEX5,HEX6,HEX7,LEDR
					);


	systemAvalon	avalon (	CLOCK_AVALON, RST,
						PS2_CLK, PS2_DAT,
						ava_address_from_the_scarab,
						ava_byteenable_from_the_scarab,
						ava_read_from_the_scarab,
						ava_readdata_to_the_scarab,
						ava_waitrequest_to_the_scarab,
						ava_write_from_the_scarab,
						ava_writedata_from_the_scarab,
						CLOCK_SOUND, AUD_BCLK, AUD_DACDAT, AUD_DACLRCK,
						I2C_SCLK, SCL, SCL_OE_N, I2C_SDAT, SDA, SDA_OE_N,
						address, byteenable, irq, irqnumber, read_n, readdata, reset_n, waitrequest, write_n, writedata,
						DRAM_ADDR, {DRAM_BA_1, DRAM_BA_0}, DRAM_CAS_N, DRAM_CKE, DRAM_CS_N, DRAM_DQ, {DRAM_UDQM, DRAM_LDQM}, DRAM_RAS_N, DRAM_WE_N,
						UART_RXD, UART_TXD
					);


endmodule
