`define WIDTH_TAG	10:0
`define WIDTH_VALID	3:0

module cache_validator(
	input				clk,

	input [3:0]			i_match,
	input [1:0]			i_set,
	input [7:0]			i_index,
	input [1:0]			i_line,
	input				i_validwrite,
	input [3:0]			i_validwritedata,
	input				i_clearing,
	input [3:0]			i_tagwrite,

	output				i_valid,
	output [15:0]		i_allvaliddata,
	output [15:0]		i_alldirtydata,
	output [`WIDTH_VALID]i_validdata,
	output [`WIDTH_VALID]i_dirtydata,
	output [3:0]		i_allvalid,
	output [3:0]		i_somevalid,
	output [3:0]		i_alldirty,
	output [3:0]		i_somedirty,

	input [3:0]			d_match,
	input [1:0]			d_set,
	input [7:0]			d_index,
	input [1:0]			d_line,
	input				d_validwrite,
	input [3:0]			d_validwritedata,
	input				d_clearing,
	input [3:0]			d_tagwrite,
	input				idle,
	input				d_dowrite,
	input				d_write,
	input				d_mem16,
	input				d_mem8,
	input [1:0]			d_address,

	output				d_valid,
	output [15:0]		d_allvaliddata,
	output [15:0]		d_alldirtydata,
	output [`WIDTH_VALID]d_validdata,
	output [`WIDTH_VALID]d_dirtydata,
	output [3:0]		d_allvalid,
	output [3:0]		d_somevalid,
	output [3:0]		d_alldirty,
	output [3:0]		d_somedirty,
	
	input				flushduring,
	input				flushdone,
	input [1:0]			f_set,
	input [7:0]			f_index,
	
	output reg				problem_a,
	output reg				problem_b
);

	wire [3:0] i_validwrite_repeated={4{i_validwrite}};

	wire [3:0] d_validwrite_repeated={4{d_validwrite || (d_dowrite && d_write)}};

	wire [15:0] i_validwritedata_munged=i_clearing ? 16'b0 : i_allvaliddata | (i_validwritedata<<{i_line,2'b00});
	wire [15:0] i_dirtywritedata_munged=i_clearing ? 16'b0 : i_alldirtydata;
	
	wire [15:0] d_validwritedata_munged=
		idle&&d_dowrite ?
			d_allvaliddata |
			(
				 d_mem16?	 d_address[1] ?			4'b0011
							:						4'b1100
				:d_mem8	?	 d_address[1:0]==2'd0 ?	4'b1000
							:d_address[1:0]==2'd1 ?	4'b0100
							:d_address[1:0]==2'd2 ?	4'b0010
							:d_address[1:0]==2'd3 ?	4'b0001
							:						4'bXXXX
				:									4'b1111
			)<<{d_line,2'b00}
		:
			(flushdone || d_clearing) ? 16'b0 : (d_allvaliddata | (d_validwritedata<<{d_line,2'b00}))
		;

	wire [15:0] d_dirtywritedata_munged=
		idle&&d_dowrite ?
			d_alldirtydata |
			(
				 d_mem16?	 d_address[1] ?			4'b0011
							:						4'b1100
				:d_mem8	?	 d_address[1:0]==2'd0 ?	4'b1000
							:d_address[1:0]==2'd1 ?	4'b0100
							:d_address[1:0]==2'd2 ?	4'b0010
							:d_address[1:0]==2'd3 ?	4'b0001
							:						4'bXXXX
				:									4'b1111
			)<<{d_line,2'b00}
		:
			 (flushdone || d_clearing) ?			16'b0
			:										d_alldirtydata
		;

	wire [127:0] i_validreaddata_set;
	wire [127:0] d_validreaddata_set;
	
	wire [31:0] i_validreaddata= i_set==2'd0 ?	i_validreaddata_set[31:0]
								:i_set==2'd1 ?	i_validreaddata_set[63:32]
								:i_set==2'd2 ?	i_validreaddata_set[95:64]
								:i_set==2'd3 ?	i_validreaddata_set[127:96]
								:				32'hXXXX_XXXX;
	assign i_allvaliddata=i_validreaddata[15:0];
	assign i_alldirtydata=i_validreaddata[31:16];

	wire [31:0] d_validreaddata=flushduring ?
									 f_set==2'd0 ?	d_validreaddata_set[31:0]
									:f_set==2'd1 ?	d_validreaddata_set[63:32]
									:f_set==2'd2 ?	d_validreaddata_set[95:64]
									:f_set==2'd3 ?	d_validreaddata_set[127:96]
									:				32'hXXXX_XXXX
								:
									 d_set==2'd0 ?	d_validreaddata_set[31:0]
									:d_set==2'd1 ?	d_validreaddata_set[63:32]
									:d_set==2'd2 ?	d_validreaddata_set[95:64]
									:d_set==2'd3 ?	d_validreaddata_set[127:96]
									:				32'hXXXX_XXXX;								

	assign d_allvaliddata=d_validreaddata[15:0];
	assign d_alldirtydata=d_validreaddata[31:16];

	assign i_validdata=	 i_line==2'd0 ?	i_allvaliddata[3:0]
						:i_line==2'd1 ?	i_allvaliddata[7:4]
						:i_line==2'd2 ?	i_allvaliddata[11:8]
						:i_line==2'd3 ?	i_allvaliddata[15:12]
						:				4'bXXXX;
	assign d_validdata=	 d_line==2'd0 ?	d_allvaliddata[3:0]
						:d_line==2'd1 ?	d_allvaliddata[7:4]
						:d_line==2'd2 ?	d_allvaliddata[11:8]
						:d_line==2'd3 ?	d_allvaliddata[15:12]
						:				4'bXXXX;

	assign i_dirtydata=	 i_line==2'd0 ?	i_alldirtydata[3:0]
						:i_line==2'd1 ?	i_alldirtydata[7:4]
						:i_line==2'd2 ?	i_alldirtydata[11:8]
						:i_line==2'd3 ?	i_alldirtydata[15:12]
						:				4'bXXXX;
	assign d_dirtydata=	 d_line==2'd0 ?	d_alldirtydata[3:0]
						:d_line==2'd1 ?	d_alldirtydata[7:4]
						:d_line==2'd2 ?	d_alldirtydata[11:8]
						:d_line==2'd3 ?	d_alldirtydata[15:12]
						:				4'bXXXX;

	assign i_allvalid={
		&i_validreaddata_set[111:96],
		&i_validreaddata_set[79:64],
		&i_validreaddata_set[47:32],
		&i_validreaddata_set[15:0]
	};

	assign i_somevalid={
		|i_validreaddata_set[111:96],
		|i_validreaddata_set[79:64],
		|i_validreaddata_set[47:32],
		|i_validreaddata_set[15:0]
	};

	assign i_alldirty={
		&i_validreaddata_set[127:112],
		&i_validreaddata_set[95:80],
		&i_validreaddata_set[63:48],
		&i_validreaddata_set[31:16]
	};

	assign i_somedirty={
		|i_validreaddata_set[127:112],
		|i_validreaddata_set[95:80],
		|i_validreaddata_set[63:48],
		|i_validreaddata_set[31:16]
	};


	assign  d_allvalid={
		&d_validreaddata_set[111:96],
		&d_validreaddata_set[79:64],
		&d_validreaddata_set[47:32],
		&d_validreaddata_set[15:0]
	};

	assign d_somevalid={
		|d_validreaddata_set[111:96],
		|d_validreaddata_set[79:64],
		|d_validreaddata_set[47:32],
		|d_validreaddata_set[15:0]
	};

	assign d_alldirty={
		&d_validreaddata_set[127:112],
		&d_validreaddata_set[95:80],
		&d_validreaddata_set[63:48],
		&d_validreaddata_set[31:16]
	};

	assign d_somedirty={
		|d_validreaddata_set[127:112],
		|d_validreaddata_set[95:80],
		|d_validreaddata_set[63:48],
		|d_validreaddata_set[31:16]
	};

	wire [3:0] wren_a=i_clearing ? i_tagwrite : (i_validwrite_repeated & i_match);
	wire [3:0] wren_b=flushdone ? (1'b1<<f_set) : d_clearing ? d_tagwrite : (d_validwrite_repeated & d_match);
	cache_valid cv[3:0](
		.address_a(i_index),
		.address_b(flushduring ? f_index : d_index),
		.clock_a(clk),
		.clock_b(clk),
		.data_a({i_dirtywritedata_munged,i_validwritedata_munged}),
		.data_b({d_dirtywritedata_munged,d_validwritedata_munged}),
		.wren_a(wren_a),
		.wren_b(wren_b),
		.q_a(i_validreaddata_set),
		.q_b(d_validreaddata_set)
	);
	
	always @(posedge clk)
	begin
		problem_a <= ((i_dirtywritedata_munged&(~i_validwritedata_munged)) != 16'b0) && (|wren_a);
		problem_b <= ((d_dirtywritedata_munged&(~d_validwritedata_munged)) != 16'b0) && (|wren_b);
	end
	
	assign i_valid=&(i_validdata);

	reg lastflushduring;
	always @(posedge clk)
		lastflushduring<=flushduring;

	assign d_valid=	lastflushduring	 ? 1'b0  
					:d_mem16?
						d_address[1] ?
							d_validdata[1] && d_validdata[0]
						:
							d_validdata[3] && d_validdata[2]
					:d_mem8	?
						 d_address[1:0]==2'd0 ?	d_validdata[3]
						:d_address[1:0]==2'd1 ?	d_validdata[2]
						:d_address[1:0]==2'd2 ?	d_validdata[1]
						:d_address[1:0]==2'd3 ?	d_validdata[0]
						:						1'bX
					:	&(d_validdata);
				
endmodule